#!/bin/sh

## Variablen ##
FSTAB=/etc/fstab

if [ -e /etc/init.d/samba.sh ] ; then
	SAMBA=/etc/init.d/samba.sh
else
	SAMBA=/etc/init.d/samba
fi	

NFSSERVER=/etc/init.d/nfsserver
VSFTPD=/etc/init.d/vsftpd
SWAPFILE=/media/usb/swapfile
LOGFILE=/tmp/_manual_fsck.log

DEV="$(mount | grep -Ev "/dev/mmcblk*|/dev/root" | grep -E "ext4|ext3" | awk '{print $1}')"

for i in $DEV ; do
	MOUNTPOINT="$(mount | grep $i | awk '{print $3}')"
	MOUNTPOINTS+=("$MOUNTPOINT")
done


cd /home/root


echo -e "\nStoppe Dienste (Samba, Nfsserver, Vsftpd ...\n" | tee $LOGFILE
$SAMBA stop | tee -a $LOGFILE
$NFSSERVER stop | tee -a $LOGFILE

if [ -e $VSFTPD ] ; then
	$VSFTPD stop | tee -a $LOGFILE
fi

if [ -e $SWAPFILE -o "$(grep ^[^#] $FSTAB | grep -o "swap")" ] ; then 
	echo -e "\nDeaktiviere Swapfile bzw. Swap Partition ...\n" | tee -a $LOGFILE
	swapoff -a
fi


umount_count=0
for i in $DEV ; do
	while mount | grep $i > /dev/null && [ "$?" = "0" ] ; do
		umount_count=$((umount_count+1))
		echo -e "\numounte $i ..." | tee -a $LOGFILE
	
		if [ "$umount_count" -eq "1" ] ; then
			umount $i
		elif [ "$umount_count" -eq "2" ] ; then
			umount -l $i
		elif [ "$umount_count" -eq "3" ] ; then
			umount -f $i
		
			if [ "$?" != "0" ] ; then
				echo -e "\n\n... ABBRUCH ...\n$i umounten 3x fehlgeschlagen,\nsinnlos es weiter zu versuchen.\n" | tee -a $LOGFILE
				umount_count=0 && break
			fi
		fi

		if [ "$?" = "0" ] ; then
			echo -e "\n$i umounten bei Versuch $umount_count erfolgreich abgeschlossen.\n" | tee -a $LOGFILE
			umount_count=0 && break
		fi
	done
done

z=0
for i in $DEV ; do
	if ! $(mount | grep $i > /dev/null) ; then
		FILESYSTEM="$(blkid | grep $i | grep -o '\<ext.*' | awk '{print $1}' | sed "s#\"##g")"
		STARTDATE_TIME="$(date +%a.%d.%b.%Y-%H:%M:%S)"
		echo -e "\n\nStarte Filecheck (fsck) fuer $i\n... -> $STARTDATE_TIME\n" | tee -a $LOGFILE
			{ fsck.$FILESYSTEM -fvp $i ; check="$?"
			if [ "$check" = "8" ] ; then
				echo -e "Exit Status = $check\n"
				echo -e "\n! Funktions Fehler ! -> Filecheck (fsck)\nfuer $i ausfuehren nicht moeglich.\n\n"
			else
				ENDDATE_TIME="$(date +%a.%d.%b.%Y-%H:%M:%S)"
				echo -e "\n\nExit Status = $check\n"
				echo -e "\nFilecheck (fsck) fuer $i\nfertig -> $ENDDATE_TIME\n\n"
			fi; } 2>&1 | tee -a $LOGFILE

		for m in ${MOUNTPOINTS[$z]} ; do
			z=$((z+1))
			
			if ! grep "$m" $FSTAB | grep -v "#" > /dev/null ; then
				sleep 1 && echo "mounte $i nach $m ..." | tee -a $LOGFILE && mount $i $m
			else
				sleep 1 && echo "mounte $i ..." | tee -a $LOGFILE && mount $i
			fi
		done

	else
		echo -e "\n\n$i gemountet, daher kein\nFilecheck (fsck) fuer $i\nmoeglich ! \n" | tee -a $LOGFILE
	fi
done


echo -e "\n\n" | tee -a $LOGFILE
$SAMBA start | tee -a $LOGFILE
$NFSSERVER start | tee -a $LOGFILE

if [ -e $VSFTPD ] ; then
	$VSFTPD start | tee -a $LOGFILE
fi

if [ -e $SWAPFILE ] ; then 
	echo -e "\nAktiviere Swapfile ...\n" | tee -a $LOGFILE
	swapon $SWAPFILE
fi

if [ "$(grep ^[^#] $FSTAB | grep -o "swap")" ] ; then
	echo -e "\nAktiviere Swap Partition ...\n" | tee -a $LOGFILE
	swapon -a
fi


echo -e "\n\n! .......... Nur zur Kontrolle .......... ! \n" | tee -a $LOGFILE
z=0
for i in $DEV ; do
	for m in ${MOUNTPOINTS[$z]} ; do
		z=$((z+1))
		if ! grep "$m" $FSTAB | grep -v "#" > /dev/null ; then
			echo -e "Last mounted on:          $m" | tee -a $LOGFILE
		fi
	done
	
	tune2fs -l $i | egrep -i "mount count|Check interval|Last|Next" | tee -a $LOGFILE
	echo | tee -a $LOGFILE
done


exit
