#!/bin/sh

# Varables #
MOUNT=mount
BLKID=blkid
DF="df -h"
FREE=free
CHECK_FSTAB="cat /etc/fstab"
OUTPUTDIR=/tmp
OUTPUTFILE=$OUTPUTDIR/service1.log
FREE_FILE=$OUTPUTDIR/free.log
DEFAULT='\033[0;39m'
YELLOW='\033[1;33m'
CYAN='\033[0;36m'

# Befehlszeilen (echos 2x, davon 1x teilweise in Farbe fuer Konsole, und 1x extra fuer Logdatei) da
# in der Logdatei die wegen der Farbe haesslichen aussehenden Farbechos ganz unten per sed geloescht
# werden und mit dem zweiten echo (ohne Farbcodes) ersetzt werden.
# Ausgabe zum Befehl mount
echo -e "$YELLOW\n\nAusgabe zum Befehl ${CYAN}$MOUNT$YELLOW :$DEFAULT"
echo -e "\n\nAusgabe zum Befehl $MOUNT :" > $OUTPUTFILE
$MOUNT | tee -a $OUTPUTFILE

# Ausgabe zum Befehl blkid
echo -e "$YELLOW\n\nAusgabe zum Befehl ${CYAN}$BLKID$YELLOW :$DEFAULT"
echo -e "\n\nAusgabe zum Befehl $BLKID :" >> $OUTPUTFILE
$BLKID | tee -a $OUTPUTFILE

# Ausgabe zum Befehl df -h
echo -e "$YELLOW\n\nAusgabe zum Befehl ${CYAN}$DF$YELLOW :$DEFAULT"
echo -e "\n\nAusgabe zum Befehl $DF :" >> $OUTPUTFILE
$DF | tee -a $OUTPUTFILE


# Ausgabe zum Befehl free, Ausgabe anders formatiert (besser lesbar)
echo -e "$YELLOW\n\nAusgabe zum Befehl ${CYAN}$FREE$YELLOW :$DEFAULT"
echo -e "\n\nAusgabe zum Befehl $FREE :" >> $OUTPUTFILE
$FREE > $FREE_FILE

echo -e "${YELLOW}Zum ${CYAN}Speicher${YELLOW} ;$DEFAULT"
echo -e "\nZum Speicher ;" >> $OUTPUTFILE

if grep -q "Speicher:" $FREE_FILE ; then
	GESAMT="$(awk '/Speicher:/ { print $2 }' $FREE_FILE)"
	BENUTZT="$(awk '/Speicher:/ { print $3 }' $FREE_FILE)"
	FREI="$(awk '/Speicher:/ { print $4 }' $FREE_FILE)"
	GEMNS="$(awk '/Speicher:/ { print $5 }' $FREE_FILE)"
	PUFFER_CACHE="$(awk '/Speicher:/ { print $6 }' $FREE_FILE)"
	VERFUEGBAR="$(awk '/Speicher:/ { print $7 }' $FREE_FILE)"
elif grep -q "Mem:" $FREE_FILE ; then
	GESAMT="$(awk '/Mem:/ { print $2 }' $FREE_FILE)"
	BENUTZT="$(awk '/Mem:/ { print $3 }' $FREE_FILE)"
	FREI="$(awk '/Mem:/ { print $4 }' $FREE_FILE)"
	GEMNS="$(awk '/Mem:/ { print $5 }' $FREE_FILE)"
	PUFFER_CACHE="$(awk '/Mem:/ { print $6 }' $FREE_FILE)"
	VERFUEGBAR="$(awk '/Mem:/ { print $7 }' $FREE_FILE)"
fi

echo -e "GESAMT:      \t\t$GESAMT" | tee -a $OUTPUTFILE
echo -e "BENUTZT:     \t\t$BENUTZT" | tee -a $OUTPUTFILE
echo -e "FREI:        \t\t$FREI" | tee -a $OUTPUTFILE
echo -e "GEMNS:       \t\t$GEMNS" | tee -a $OUTPUTFILE
echo -e "PUFFER_CACHE:\t\t$PUFFER_CACHE" | tee -a $OUTPUTFILE
echo -e "VERFUEGBAR:  \t\t$VERFUEGBAR" | tee -a $OUTPUTFILE

echo -e "${YELLOW}Zur ${CYAN}Swap${YELLOW} ;$DEFAULT"
echo -e "\nZur Swap ;" >> $OUTPUTFILE
GESAMT="$(awk '/Swap:/ { print $2 }' $FREE_FILE)"
BENUTZT="$(awk '/Swap:/ { print $3 }' $FREE_FILE)"
FREI="$(awk '/Swap:/ { print $4 }' $FREE_FILE)"

echo -e "GESAMT:     \t\t$GESAMT" | tee -a $OUTPUTFILE
echo -e "BENUTZT:    \t\t$BENUTZT" | tee -a $OUTPUTFILE
echo -e "FREI:       \t\t$FREI" | tee -a $OUTPUTFILE


# Ausgabe zur /etc/fstab
echo -e "$YELLOW\n\nAusgabe zum Befehl ${CYAN}$CHECK_FSTAB (zeigt den Inhalt der fstab)$YELLOW :$DEFAULT"
echo -e "\n\nAusgabe zum Befehl $CHECK_FSTAB (zeigt den Inhalt der fstab) :" >> $OUTPUTFILE
$CHECK_FSTAB | tee -a $OUTPUTFILE

# Loeschen der haesslich aussehenden Farbechos in der Logdatei.
#sed -i '/\[1;3/d' $OUTPUTFILE
#sed -i '/\[0;3/d' $OUTPUTFILE

exit
