# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/webtv.py
from setup import *
from imports import *
cj = {}

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class webtv(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['title'] = Label('Web.tv')
        self['name'] = Label('')
        self['text'] = Label('')
        self['poster'] = Pixmap()
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.onLayoutFinish.append(self.cat)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def cat(self):
        self.index = 'cat'
        self.cat_list = []
        webtv_list = [('http://trt1.web.tv', 'trt1', 'http://thumbs.cdn.web.tv/zq/t0/zqt0cpcbsk__140x79.jpg'),
         ('http://showtv.web.tv', 'showtv', 'http://thumbs.cdn.web.tv/cj/g1/cjg1u9qlici_140x79.jpg'),
         ('http://tgrthaber.web.tv', 'tgrthaber', 'http://thumbs.cdn.web.tv/us/3f/us3fagwxlru_140x79.jpg'),
         ('http://halktv.web.tv', 'halktv', 'http://thumbs.cdn.web.tv/u2/lm/u2lmuhdkwoy_140x79.jpg'),
         ('http://tgrt.web.tv', 'tgrt', 'http://thumbs.cdn.web.tv/pz/qm/pzqmstrwynm_140x79.jpg'),
         ('http://cnbc-e.web.tv', 'CNBC-E', 'http://thumbs.cdn.web.tv/je/mb/jembflgpxmu_140x79.jpg'),
         ('http://flashtv.web.tv', 'flashtv', 'http://thumbs.cdn.web.tv/_d/rx/_drxl0o19ug_140x79.jpg'),
         ('http://startv.web.tv', 'startv', 'http://thumbs.cdn.web.tv/lm/we/lmwedpzlvek_140x79.jpg'),
         ('http://ntv.web.tv', 'ntv', 'http://thumbs.cdn.web.tv/nf/ed/nfedtxdbyva_140x79.jpg'),
         ('http://cnbc.web.tv', 'cnbc', 'http://thumbs.cdn.web.tv/hi/zh/hizhapvqycq_140x79.jpg'),
         ('http://number1.web.tv', 'number1', 'http://thumbs.cdn.web.tv/ho/hs/hohsi8jywps_140x79.jpg'),
         ('http://tv360.web.tv', 'tv360', 'http://thumbs.cdn.web.tv/e7/k7/e7k7iypp0ie_140x79.jpg'),
         ('http://e2tv.web.tv', 'e2tv', 'http://thumbs.cdn.web.tv/tb/zt/tbztufnozpa_140x79.jpg'),
         ('http://dreamturk.web.tv', 'dreamturk', 'http://thumbs.cdn.web.tv/t6/iq/t6iq7o540fk_140x79.jpg'),
         ('http://powertv.web.tv', 'powertv', 'http://thumbs.cdn.web.tv/u6/la/u6lawrkxc5y_140x79.jpg'),
         ('http://2mmonde.web.tv', '2mmonde', 'http://thumbs.cdn.web.tv/ky/ez/kyezaufoxwy_140x79.jpg'),
         ('http://lidertv.web.tv', 'lidertv', 'http://thumbs.cdn.web.tv/fm/pt/fmptjwghyza_140x79.jpg'),
         ('http://zdf.web.tv', 'zdf', 'http://thumbs.cdn.web.tv/sw/fg/swfgiheobiw_140x79.jpg'),
         ('http://cbc.web.tv', 'cbc', 'http://thumbs.cdn.web.tv/5o/7p/5o7pp0ww05c_140x79.jpg'),
         ('http://rai1.web.tv', 'rai1', 'http://thumbs.cdn.web.tv/jn/6q/jn6qngjmhac_140x79.jpg'),
         ('http://emtv.web.tv', 'emtv', 'http://thumbs.cdn.web.tv/eo/2e/eo2ehyk5bks_140x79.jpg'),
         ('http://chaneltv.web.tv', 'chaneltv', 'http://thumbs.cdn.web.tv/ai/2w/ai2wenwd2t2_140x79.jpg'),
         ('http://megaturktv.web.tv', 'megaturktv', 'http://thumbs.cdn.web.tv/6i/l6/6il6w6zevjm_140x79.jpg'),
         ('http://rai2.web.tv', 'rai2', 'http://thumbs.cdn.web.tv/ub/gj/ubgjy9cabrq_140x79.jpg'),
         ('http://rai3.web.tv', 'rai3', 'http://thumbs.cdn.web.tv/lb/5d/lb5d3nyrkku_140x79.jpg'),
         ('http://sts.web.tv', 'sts', 'http://thumbs.cdn.web.tv/t0/sg/t0sgoa6ulxy_140x79.jpg'),
         ('http://rtrplaneta.web.tv', 'rtrplaneta', 'http://thumbs.cdn.web.tv/wc/zf/wczfffgji1s_140x79.jpg'),
         ('http://gunaztv.web.tv', 'gunaztv', 'http://thumbs.cdn.web.tv/h8/sw/h8swenmbtnc_140x79.jpg'),
         ('http://kazakhtv.web.tv', 'kazakhtv', 'http://thumbs.cdn.web.tv/c1/f8/c1f83nddmqa_140x79.jpg'),
         ('http://cctv4.web.tv', 'cctv4', 'http://thumbs.cdn.web.tv/ua/xk/uaxkj63mdno_140x79.jpg'),
         ('http://1tvort.web.tv', '1tvort', 'http://thumbs.cdn.web.tv/ci/5o/ci5ovi5xmcw_140x79.jpg'),
         ('http://daserste.web.tv', 'daserste', 'http://thumbs.cdn.web.tv/an/y2/any2n6ddexy_140x79.jpg'),
         ('http://malatyaertv.web.tv', 'malatyaertv', 'http://thumbs.cdn.web.tv/f7/ut/f7utdxsnwrw_140x79.jpg'),
         ('http://malatyatv.web.tv', 'malatyatv', 'http://thumbs.cdn.web.tv/lx/xa/lxxaiilcjcw_140x79.jpg'),
         ('http://olaytv.web.tv', 'olaytv', 'http://thumbs.cdn.web.tv/ga/zv/gazv3ubwgz6_140x79.jpg'),
         ('http://astv.web.tv', 'astv', 'http://thumbs.cdn.web.tv/cu/s3/cus3_f0vebs_140x79.jpg'),
         ('http://linetv.web.tv', 'linetv', 'http://thumbs.cdn.web.tv/ng/aw/ngawe2b7bta_140x79.jpg'),
         ('http://trt6.web.tv', 'TRT6', 'http://thumbs.cdn.web.tv/q7/ho/q7houpo6iey_140x79.jpg'),
         ('http://bursatv.web.tv', 'bursatv', 'http://thumbs.cdn.web.tv/i9/ym/i9ymofvwaac_140x79.jpg'),
         ('http://estv.web.tv', 'estv', 'http://thumbs.cdn.web.tv/ym/qx/ymqxmzr2kns_140x79.jpg'),
         ('http://kanal26.web.tv', 'kanal26', 'http://thumbs.cdn.web.tv/gi/m8/gim8ehr94ua_140x79.jpg'),
         ('http://caytv.web.tv', 'caytv', 'http://thumbs.cdn.web.tv/5v/kd/5vkductm4da_140x79.jpg'),
         ('http://kanalf.web.tv', 'kanalf', 'http://thumbs.cdn.web.tv/2l/e2/2le2oxa13oi_140x79.jpg'),
         ('http://trtavaz.web.tv', 'TRTAvaz', 'http://thumbs.cdn.web.tv/jj/eo/jjeoq0vipy8_140x79.jpg'),
         ('http://abanttv.web.tv', 'abanttv', 'http://thumbs.cdn.web.tv/re/ke/rekeeylsspa_140x79.jpg'),
         ('http://kanal56.web.tv', 'kanal56', 'http://thumbs.cdn.web.tv/qb/tl/qbtld1rjnbi_140x79.jpg'),
         ('http://dogutv.web.tv', 'dogutv', 'http://thumbs.cdn.web.tv/lm/9r/lm9rjsocgai_140x79.jpg'),
         ('http://kocaelitv.web.tv', 'kocaelitv', 'http://thumbs.cdn.web.tv/jx/za/jxzau3s5__s_140x79.jpg'),
         ('http://on4tv.web.tv', 'on4tv', 'http://thumbs.cdn.web.tv/di/mg/dimgv2gcfjq_140x79.jpg'),
         ('http://kanalc.web.tv', 'kanalc', 'http://thumbs.cdn.web.tv/al/7k/al7kgi96u2k_140x79.jpg'),
         ('http://vuslattv.web.tv', 'VUSLATtv', 'http://thumbs.cdn.web.tv/yh/hv/yhhvxel7rdq_140x79.jpg'),
         ('http://osmanlitv.web.tv', 'osmanlitv', 'http://thumbs.cdn.web.tv/jl/be/jlbej95mrtc_140x79.jpg'),
         ('http://kibristv.web.tv', 'kibristv', 'http://thumbs.cdn.web.tv/c5/0h/c50hrnuqdc6_140x79.jpg'),
         ('http://erentv.web.tv', 'ErenTv', 'http://thumbs.cdn.web.tv/mx/ds/mxdsz1gexoi_140x79.jpg'),
         ('http://kanalfirat.web.tv', 'kanalfirat', 'http://thumbs.cdn.web.tv/lm/zd/lmzdvrqwxdo_140x79.jpg'),
         ('http://gaziantepolay.web.tv', 'gaziantepolay', 'http://thumbs.cdn.web.tv/lt/mi/ltmijdzmbmm_140x79.jpg'),
         ('http://gelisimtv.web.tv', 'gelisimtv', 'http://thumbs.cdn.web.tv/uj/c0/ujc02sfvh7a_140x79.jpg'),
         ('http://kanal23.web.tv', 'kanal23', 'http://thumbs.cdn.web.tv/mb/nu/mbnuba25foi_140x79.jpg'),
         ('http://kanal32.web.tv', 'kanal32', 'http://thumbs.cdn.web.tv/ag/rq/agrqvb84aou_140x79.jpg'),
         ('http://ciftcitv.web.tv', 'ciftcitv', 'http://thumbs.cdn.web.tv/pn/iw/pniwl54sdhi_140x79.jpg'),
         ('http://karabukbrttv.web.tv', 'karabukbrttv', 'http://thumbs.cdn.web.tv/wi/be/wibeifbqd7y_140x79.jpg'),
         ('http://tv5.web.tv', 'tv5', 'http://thumbs.cdn.web.tv/tr/dt/trdta7gzhv2_140x79.jpg'),
         ('http://tv25.web.tv', 'TV25', 'http://thumbs.cdn.web.tv/os/ez/osezfgdb4bw_140x79.jpg'),
         ('http://rtv.web.tv', 'rtv', 'http://thumbs.cdn.web.tv/1l/6d/1l6daai2ntu_140x79.jpg'),
         ('http://tv41.web.tv', 'tv41', 'http://thumbs.cdn.web.tv/sw/oc/swocpzqhkg2_140x79.jpg'),
         ('http://vantv.web.tv', 'vantv', 'http://thumbs.cdn.web.tv/xf/eg/xfegsw5gilu_140x79.jpg'),
         ('http://bitlistv.web.tv', 'bitlistv', 'http://thumbs.cdn.web.tv/lm/s_/lms_zlhd2vg_140x79.jpg'),
         ('http://rumelitv.web.tv', 'rumelitv', 'http://thumbs.cdn.web.tv/on/df/ondfq3pby1g_140x79.jpg'),
         ('http://kanal5.web.tv', 'kanal5', 'http://thumbs.cdn.web.tv/h1/bh/h1bhiz8y0bm_140x79.jpg'),
         ('http://tv58.web.tv', 'tv58', 'http://thumbs.cdn.web.tv/j5/3l/j53lfsdcuc2_140x79.jpg'),
         ('http://kanal24.web.tv', 'kanal24', 'http://thumbs.cdn.web.tv/xk/rk/xkrk2xlosjx_140x79.jpg'),
         ('http://megatv.web.tv', 'megatv', 'http://thumbs.cdn.web.tv/lv/kv/lvkvst4qrye_140x79.jpg'),
         ('http://anadolutv.web.tv', 'ANADOLUTV', 'http://thumbs.cdn.web.tv/2i/os/2iost2tfuce_140x79.jpg'),
         ('http://anadolumtv.web.tv', 'anadolumtv', 'http://thumbs.cdn.web.tv/we/tm/wetmn4giooa_140x79.jpg'),
         ('http://krttv.web.tv', 'KrtTV', 'http://thumbs.cdn.web.tv/0j/mn/0jmnrd28h8m_140x79.jpg'),
         ('http://turkiyemtv.web.tv', 'turkiyemtv', 'http://thumbs.cdn.web.tv/rp/a1/rpa1vvfwzos_140x79.jpg'),
         ('http://canerzincantv.web.tv', 'Canerzincantv', 'http://thumbs.cdn.web.tv/l7/ie/l7iecar5es6_140x79.jpg'),
         ('http://damlatv.web.tv', 'DamlaTV', 'http://thumbs.cdn.web.tv/uo/oo/uooollzkwwc_140x79.jpg'),
         ('http://diyartv.web.tv', 'diyartv', 'http://thumbs.cdn.web.tv/od/uh/oduhc6gwjwa_140x79.jpg'),
         ('http://egetv.web.tv', 'egetv', 'http://thumbs.cdn.web.tv/pb/ke/pbken7ialym_140x79.jpg'),
         ('http://tontv.web.tv', 'tontv', 'http://thumbs.cdn.web.tv/mv/g8/mvg8kisj8by_140x79.jpg'),
         ('http://kozatv.web.tv', 'kozatv', 'http://thumbs.cdn.web.tv/yl/pz/ylpzsuxfsyw_140x79.jpg'),
         ('http://manisamedyatv.web.tv', 'manisamedyatv', 'http://thumbs.cdn.web.tv/zd/rr/zdrrpfmzuxe_140x79.jpg'),
         ('http://arafattv.web.tv', 'arafattv', 'http://thumbs.cdn.web.tv/8j/jg/8jjghpt5eoc_140x79.jpg'),
         ('http://azaditv.web.tv', 'azaditv', 'http://thumbs.cdn.web.tv/lw/x7/lwx7kfaz0zq_140x79.jpg'),
         ('http://kibrisgenctv.web.tv', 'kibrisgenctv', 'http://thumbs.cdn.web.tv/by/fk/byfk2vfovke_140x79.jpg'),
         ('http://diyalogtv.web.tv', 'diyalogtv', 'http://thumbs.cdn.web.tv/pa/cp/pacpsenu6eo_140x79.jpg'),
         ('http://karadenizturk.web.tv', 'karadenizturk', 'http://thumbs.cdn.web.tv/xx/zb/xxzbcrlajkk_140x79.jpg'),
         ('http://jiyantv.web.tv', 'jiyantv', 'http://thumbs.cdn.web.tv/oo/x7/oox767yxeng_140x79.jpg'),
         ('http://vizyon58.web.tv', 'vizyon58', 'http://thumbs.cdn.web.tv/vk/d1/vkd1fwqeg2o_140x79.jpg'),
         ('http://pamukkaletv.web.tv', 'pamukkaletv', 'http://thumbs.cdn.web.tv/dz/xn/dzxnfzfzo0c_140x79.jpg'),
         ('http://konyatv.web.tv', 'konyatv', 'http://thumbs.cdn.web.tv/lz/gt/lzgted8kses_140x79.jpg'),
         ('http://srt1.web.tv', 'srt1', 'http://thumbs.cdn.web.tv/e1/of/e1ofvkjokyg_140x79.jpg'),
         ('http://kudustv.web.tv', 'kudustv', 'http://thumbs.cdn.web.tv/gj/ms/gjmsjkixlp6_140x79.jpg'),
         ('http://vizyonturk.web.tv', 'vizyonturk', 'http://thumbs.cdn.web.tv/zb/nc/zbnckvtgivs_140x79.jpg'),
         ('http://megasuare.web.tv', 'megasuare', 'http://thumbs.cdn.web.tv/l2/8s/l28sezataw2_140x79.jpg'),
         ('http://sinemafon.web.tv', 'sinemafon', 'http://thumbs.cdn.web.tv/hv/ff/hvff3ioptq2_140x79.jpg'),
         ('http://maksim.web.tv', 'maksim', 'http://thumbs.cdn.web.tv/cq/wn/cqwnshh0lc2_140x79.jpg'),
         ('http://yesilsinema.web.tv', 'yesilsinema', 'http://thumbs.cdn.web.tv/lr/nv/lrnvuwkbvpu_140x79.jpg'),
         ('http://seyran.web.tv', 'seyran', 'http://thumbs.cdn.web.tv/bx/f3/bxf3cxr8beg_140x79.jpg'),
         ('http://gonul.web.tv', 'gonul', 'http://thumbs.cdn.web.tv/zh/c7/zhc7wellazg_140x79.jpg'),
         ('http://rustavi.web.tv', 'rustavi', 'http://thumbs.cdn.web.tv/pn/jk/pnjkaiiyxmf_140x79.jpg'),
         ('http://imedi.web.tv', 'imedi', 'http://thumbs.cdn.web.tv/ge/vv/gevvrnepwbe_140x79.jpg'),
         ('http://govend.web.tv', 'govend', 'http://thumbs.cdn.web.tv/p7/1y/p71yddimzcu_140x79.jpg'),
         ('http://fhm.web.tv', 'fhm', 'http://thumbs.cdn.web.tv/is/pk/ispkjs1tsxo_140x79.jpg'),
         ('http://hanci.web.tv', 'hanci', 'http://thumbs.cdn.web.tv/1z/op/1zopiargljc_140x79.jpg'),
         ('http://sumedya.web.tv', 'sumedya', 'http://thumbs.cdn.web.tv/yr/gy/yrgyokosmbk_140x79.jpg'),
         ('http://maestrotv.web.tv', 'maestrotv', 'http://thumbs.cdn.web.tv/y0/gy/y0gylqal0ft_140x79.jpg'),
         ('http://havintv.web.tv', 'havintv', 'http://thumbs.cdn.web.tv/k2/ih/k2ihzmt9hog_140x79.jpg'),
         ('http://7kazakhstan.web.tv', '7kazakhstan', 'http://thumbs.cdn.web.tv/ti/ya/tiyaolermze_140x79.jpg'),
         ('http://4eylultv.web.tv', '4eylultv', 'http://thumbs.cdn.web.tv/lr/mq/lrmqzanlkku_140x79.jpg'),
         ('http://corumtv.web.tv', 'corumtv', 'http://static.cdn.web.tv/images/default_7k_140x79.jpg'),
         ('http://erttv.web.tv', 'ERTTV', 'http://thumbs.cdn.web.tv/yx/xb/yxxbuwcotty_140x79.jpg'),
         ('http://aksutv.web.tv', 'aksutv', 'http://thumbs.cdn.web.tv/kj/5t/kj5t81dlvve_140x79.jpg'),
         ('http://kanal48tv.web.tv', 'kanal48tv', 'http://thumbs.cdn.web.tv/yq/by/yqbykusrbba_140x79.jpg'),
         ('http://manisa.web.tv', 'manisa', 'http://thumbs.cdn.web.tv/vh/4v/vh4vhpj26c2_140x79.jpg'),
         ('http://gtv.web.tv', 'gtv', 'http://thumbs.cdn.web.tv/ne/7d/ne7dsz4zowj_140x79.jpg'),
         ('http://budemstv.web.tv', 'budemstv', 'http://thumbs.cdn.web.tv/kq/fr/kqfrqybitjk_140x79.jpg'),
         ('http://tokatsupertv.web.tv', 'tokatsupertv', 'http://thumbs.cdn.web.tv/ih/lr/ihlrjtttkum_140x79.jpg'),
         ('http://trthaber.web.tv', 'trthaber', 'http://thumbs.cdn.web.tv/2l/ma/2lmafglppjg_140x79.jpg'),
         ('http://euronews.web.tv', 'euronews', 'http://thumbs.cdn.web.tv/o4/11/o411i4rn70w_140x79.jpg'),
         ('http://buluttv.web.tv', 'BulutTv', 'http://thumbs.cdn.web.tv/6j/4q/6j4qzxtocym_140x79.jpg'),
         ('http://dengetv.web.tv', 'DengeTV', 'http://thumbs.cdn.web.tv/uu/ws/uuwskxx45ic_140x79.jpg'),
         ('http://imctv.web.tv', 'imctv', 'http://thumbs.cdn.web.tv/zs/cy/zscysgpo8hi_140x79.jpg'),
         ('http://durutv.web.tv', 'durutv', 'http://thumbs.cdn.web.tv/y3/un/y3un5cwenwc_140x79.jpg'),
         ('http://kanala.web.tv', 'KANALA', 'http://static.cdn.web.tv/images/default_1k_140x79.jpg'),
         ('http://genctv.web.tv', 'GencTV', 'http://thumbs.cdn.web.tv/cu/za/cuzaoodaisk_140x79.jpg'),
         ('http://aljazeera.web.tv', 'aljazeera', 'http://thumbs.cdn.web.tv/te/ri/terigdxqdjw_140x79.jpg'),
         ('http://24tv.web.tv', '24tv', 'http://thumbs.cdn.web.tv/k6/zm/k6zmhncyhkc_140x79.jpg'),
         ('http://ruhatv.web.tv', 'ruhatv', 'http://thumbs.cdn.web.tv/in/7n/in7ntppkrwa_140x79.jpg'),
         ('http://beykenttv.web.tv', 'beykenttv', 'http://thumbs.cdn.web.tv/ra/cm/racmq1tswck_140x79.jpg'),
         ('http://brt1.web.tv', 'brt1', 'http://thumbs.cdn.web.tv/2t/h9/2th9vasloou_140x79.jpg'),
         ('http://24saattv.web.tv', '24saattv', 'http://thumbs.cdn.web.tv/si/ya/siyajrnhmle_140x79.jpg'),
         ('http://nhkworldtv.web.tv', 'nhkworldtv', 'http://thumbs.cdn.web.tv/ii/ny/iiny91ktgjs_140x79.jpg'),
         ('http://aljazeerainternational.web.tv', 'aljazeerainternational', 'http://thumbs.cdn.web.tv/mb/sj/mbsjx20l3hy_140x79.jpg'),
         ('http://rainews.web.tv', 'rainews', 'http://thumbs.cdn.web.tv/to/ri/toriv8pii72_140x79.jpg'),
         ('http://cctvnews.web.tv', 'cctvnews', 'http://thumbs.cdn.web.tv/dm/2r/dm2rtmyzy9d_140x79.jpg'),
         ('http://rossiya24.web.tv', 'rossiya24', 'http://thumbs.cdn.web.tv/fh/zf/fhzfldusn5w_140x79.jpg'),
         ('http://bloombergtv.web.tv', 'bloombergtv', 'http://thumbs.cdn.web.tv/bq/wu/bqwutshz9kc_140x79.jpg'),
         ('http://bbcworldnews.web.tv', 'bbcworldnews', 'http://thumbs.cdn.web.tv/xb/zg/xbzg0khpieo_140x79.jpg'),
         ('http://kanal25.web.tv', 'kanal25', 'http://thumbs.cdn.web.tv/1q/7r/1q7rpaealmu_140x79.jpg'),
         ('http://trtspor.web.tv', 'trtspor', 'http://thumbs.cdn.web.tv/fm/xm/fmxmvzz1uau_140x79.jpg'),
         ('http://sportstv.web.tv', 'Sportstv', 'http://thumbs.cdn.web.tv/qq/my/qqmygobnfho_140x79.jpg'),
         ('http://asportv.web.tv', 'asportv', 'http://thumbs.cdn.web.tv/ga/vh/gavhzfuc7rq_140x79.jpg'),
         ('http://dubaisports.web.tv', 'dubaisports', 'http://thumbs.cdn.web.tv/pg/oy/pgoyloxyghq_140x79.jpg'),
         ('http://abudhabisports.web.tv', 'abudhabisports', 'http://thumbs.cdn.web.tv/tp/sf/tpsfcnjklwo_140x79.jpg'),
         ('http://abudhabisports1.web.tv', 'abudhabisports1', 'http://thumbs.cdn.web.tv/sr/nj/srnjxjzdxpa_140x79.jpg'),
         ('http://raisport2.web.tv', 'raisport2', 'http://thumbs.cdn.web.tv/tq/1l/tq1lsddazf6_140x79.jpg'),
         ('http://raisport1.web.tv', 'raisport1', 'http://thumbs.cdn.web.tv/lx/xd/lxxdmcpkj26_140x79.jpg'),
         ('http://trtcocuk.web.tv', 'TRTCocuk', 'http://thumbs.cdn.web.tv/44/tc/44tcyvf9r4m_140x79.jpg'),
         ('http://cartoonnetwork.web.tv', 'Cartoonnetwork', 'http://thumbs.cdn.web.tv/hm/6x/hm6x4vzx79m_140x79.jpg'),
         ('http://trtturk.web.tv', 'TRTTurk', 'http://thumbs.cdn.web.tv/2g/wt/2gwt7zw5nqa_140x79.jpg'),
         ('http://kardelentv.web.tv', 'kardelentv', 'http://thumbs.cdn.web.tv/n0/6a/n06akkpf5aj_140x79.jpg'),
         ('http://a9tv.web.tv', 'a9tv', 'http://thumbs.cdn.web.tv/8m/wf/8mwfw6hnfcw_140x79.jpg'),
         ('http://zeynotv.web.tv', 'zeynotv', 'http://static.cdn.web.tv/images/default_1k_140x79.jpg'),
         ('http://yurdumtv.web.tv', 'yurdumtv', 'http://thumbs.cdn.web.tv/5i/th/5ithwlzydkg_140x79.jpg'),
         ('http://dominotv.web.tv', 'dominotv', 'http://thumbs.cdn.web.tv/95/jm/95jmjgyd6f__140x79.jpg'),
         ('http://markafoni.web.tv', 'markafoni', 'http://thumbs.cdn.web.tv/nj/3j/nj3jbng0gum_140x79.jpg'),
         ('http://viptv.web.tv', 'viptv', 'http://thumbs.cdn.web.tv/ka/vq/kavq_jbz2ww_140x79.jpg'),
         ('http://tarimturktv.web.tv', 'tarimturktv', 'http://thumbs.cdn.web.tv/he/cl/hecl1smtvcu_140x79.jpg'),
         ('http://karisiktv.web.tv', 'karisiktv', 'http://thumbs.cdn.web.tv/ip/2z/ip2zg8j6afa_140x79.jpg'),
         ('http://angoratv.web.tv', 'angoratv', 'http://static.cdn.web.tv/images/default_6k_140x79.jpg'),
         ('http://berekethayvanciliktv.web.tv', 'berekethayvanciliktv', 'http://thumbs.cdn.web.tv/ks/hg/kshgzktsshe_140x79.jpg'),
         ('http://diamondtv.web.tv', 'diamondtv', 'http://thumbs.cdn.web.tv/1m/rn/1mrnf8e8oiu_140x79.jpg'),
         ('http://muhabbettv.web.tv', 'muhabbettv', 'http://thumbs.cdn.web.tv/2q/mv/2qmvrwywfha_140x79.jpg'),
         ('http://munzurtv.web.tv', 'munzurtv', 'http://thumbs.cdn.web.tv/nz/gd/nzgdjcbajyx_140x79.jpg'),
         ('http://raistoria.web.tv', 'raistoria', 'http://thumbs.cdn.web.tv/s7/kn/s7knchmslhw_140x79.jpg'),
         ('http://trtmuzik.web.tv', 'TRTMuzik', 'http://thumbs.cdn.web.tv/gj/ma/gjmatfcixgs_140x79.jpg'),
         ('http://powerturktv.web.tv', 'powerturktv', 'http://thumbs.cdn.web.tv/tw/kh/twkhex6nwf6_140x79.jpg'),
         ('http://radyoviva.web.tv', 'radyoviva', 'http://thumbs.cdn.web.tv/br/hy/brhyfmrlxak_140x79.jpg'),
         ('http://baristv.web.tv', 'baristv', 'http://thumbs.cdn.web.tv/mh/sv/mhsvt1dlzwu_140x79.jpg'),
         ('http://turkutv.web.tv', 'turkutv', 'http://thumbs.cdn.web.tv/l4/f6/l4f62by0hje_140x79.jpg'),
         ('http://besttv.web.tv', 'besttv', 'http://thumbs.cdn.web.tv/dv/qk/dvqkt5qhhtk_140x79.jpg'),
         ('http://dreamtv.web.tv', 'DREAMtv', 'http://thumbs.cdn.web.tv/ll/kh/llkhbobywxc_140x79.jpg'),
         ('http://bestofarabesk.web.tv', 'bestofarabesk', 'http://thumbs.cdn.web.tv/9m/tn/9mtnh8lacbc_140x79.jpg'),
         ('http://voicetv.web.tv', 'voicetv', 'http://thumbs.cdn.web.tv/ln/v5/lnv576uzdau_140x79.jpg'),
         ('http://tmbtv.web.tv', 'tmbtv', 'http://thumbs.cdn.web.tv/ll/hv/llhvwyutmnq_140x79.jpg'),
         ('http://vivatv.web.tv', 'vivatv', 'http://thumbs.cdn.web.tv/a7/uw/a7uwndgykgi_140x79.jpg'),
         ('http://number1turk.web.tv', 'number1turk', 'http://thumbs.cdn.web.tv/8o/dy/8ody8jrjepo_140x79.jpg'),
         ('http://megamuzik.web.tv', 'megamuzik', 'http://thumbs.cdn.web.tv/0e/7h/0e7htufbqh6_140x79.jpg'),
         ('http://shansontv.web.tv', 'shansontv', 'http://thumbs.cdn.web.tv/tm/ya/tmya3jzalqs_140x79.jpg'),
         ('http://showradyo.web.tv', 'showradyo', 'http://thumbs.cdn.web.tv/ua/rc/uarcl1amvw__140x79.jpg'),
         ('http://radyodeniz.web.tv', 'radyodeniz', 'http://thumbs.cdn.web.tv/hc/wk/hcwkc9ggcnu_140x79.jpg'),
         ('http://kenttv.web.tv', 'kenttv', 'http://thumbs.cdn.web.tv/b6/67/b667e9me_ke_140x79.jpg'),
         ('http://ahitv.web.tv', 'ahitv', 'http://thumbs.cdn.web.tv/we/iu/weiuvee_3ls_140x79.jpg'),
         ('http://dosttv.web.tv', 'dosttv', 'http://thumbs.cdn.web.tv/7e/9v/7e9vv_pjpag_140x79.jpg'),
         ('http://tv52.web.tv', 'tv52', 'http://thumbs.cdn.web.tv/ue/ni/uenipwjncse_140x79.jpg'),
         ('http://tva.web.tv', 'tva', 'http://thumbs.cdn.web.tv/wy/hh/wyhhkfc5obo_140x79.jpg'),
         ('http://kanalt.web.tv', 'kanalt', 'http://thumbs.cdn.web.tv/_c/vc/_cvcngqqhzc_140x79.jpg'),
         ('http://pikseltv.web.tv', 'pikseltv', 'http://thumbs.cdn.web.tv/f2/1l/f21lwuxkmi2_140x79.jpg'),
         ('http://planetturk.web.tv', 'planetturk', 'http://thumbs.cdn.web.tv/cb/t0/cbt0lhp01hw_140x79.jpg'),
         ('http://dolutv.web.tv', 'dolutv', 'http://thumbs.cdn.web.tv/fv/nt/fvnt5rur1h2_140x79.jpg'),
         ('http://planetpembe.web.tv', 'planetpembe', 'http://thumbs.cdn.web.tv/ac/aa/acaadysxp6u_140x79.jpg'),
         ('http://anadoluyurdum.web.tv', 'anadoluyurdum', 'http://thumbs.cdn.web.tv/ri/lb/rilbxonxymy_140x79.jpg'),
         ('http://akillitv.web.tv', 'akillitv', 'http://thumbs.cdn.web.tv/tr/cx/trcxdp6jmnu_140x79.jpg'),
         ('http://mpltv.web.tv', 'mpltv', 'http://thumbs.cdn.web.tv/1j/yi/1jyij3tlxoq_140x79.jpg'),
         ('http://kabetv.web.tv', 'kabetv', 'http://thumbs.cdn.web.tv/6g/l7/6gl7iat6hh6_140x79.jpg'),
         ('http://lalegul.web.tv', 'lalegul', 'http://thumbs.cdn.web.tv/tj/2d/tj2dx43gkg6_140x79.jpg'),
         ('http://cemtv.web.tv', 'cemtv', 'http://thumbs.cdn.web.tv/hc/3n/hc3nzty5qts_140x79.jpg'),
         ('http://baltv.web.tv', 'baltv', 'http://thumbs.cdn.web.tv/gf/en/gfentyik58o_140x79.jpg'),
         ('http://semerkandtv.web.tv', 'semerkandtv', 'http://thumbs.cdn.web.tv/fm/ul/fmuldle4wfo_140x79.jpg'),
         ('http://nisatv.web.tv', 'nisatv', 'http://thumbs.cdn.web.tv/c9/0d/c90dwjzlsgy_140x79.jpg'),
         ('http://bedirtv.web.tv', 'bedirtv', 'http://thumbs.cdn.web.tv/tw/eo/tweoihqztia_140x79.jpg'),
         ('http://trtdiyanettv.web.tv', 'TRTDiyanettv', 'http://thumbs.cdn.web.tv/hl/bp/hlbpqjdpjqc_140x79.jpg'),
         ('http://kanaltek.web.tv', 'kanaltek', 'http://thumbs.cdn.web.tv/md/sk/mdsko9axxoo_140x79.jpg'),
         ('http://tv2000.web.tv', 'tv2000', 'http://thumbs.cdn.web.tv/9l/px/9lpxw4qrbyy_140x79.jpg'),
         ('http://dolunaytv.web.tv', 'dolunaytv', 'http://thumbs.cdn.web.tv/pz/bx/pzbxnasbw2u_140x79.jpg'),
         ('http://nurtv.web.tv', 'nurtv', 'http://thumbs.cdn.web.tv/zr/di/zrdi1zvvybo_140x79.jpg'),
         ('http://yasintv.web.tv', 'yasintv', 'http://thumbs.cdn.web.tv/sg/eu/sgeuwovl9tu_140x79.jpg'),
         ('http://kevsertv.web.tv', 'kevsertv', 'http://thumbs.cdn.web.tv/er/vh/ervh9cnlvxs_140x79.jpg'),
         ('http://uzaytv.web.tv', 'uzaytv', 'http://thumbs.cdn.web.tv/cf/ew/cfew0xzqlqo_140x79.jpg'),
         ('http://kanalvip.web.tv', 'kanalvip', 'http://static.cdn.web.tv/images/default_2k_140x79.jpg'),
         ('http://berekettv.web.tv', 'berekettv', 'http://thumbs.cdn.web.tv/c3/mb/c3mbuag0jcs_140x79.jpg'),
         ('http://yabantv.web.tv', 'yabantv', 'http://thumbs.cdn.web.tv/a_/uf/a_ufxkruzvg_140x79.jpg'),
         ('http://mavibelgesel.web.tv', 'mavibelgesel', 'http://thumbs.cdn.web.tv/yk/7d/yk7d0x7cd1q_140x79.jpg'),
         ('http://hevi.web.tv', 'hevi', 'http://thumbs.cdn.web.tv/9u/ey/9uey6eomp6c_140x79.jpg'),
         ('http://1antv.web.tv', '1antv', 'http://thumbs.cdn.web.tv/vk/e9/vke9wrphjla_140x79.jpg'),
         ('http://mezopotamyatv.web.tv', 'mezopotamyatv', 'http://thumbs.cdn.web.tv/2p/9o/2p9ow5bcgrc_140x79.jpg'),
         ('http://planetmutfak.web.tv', 'planetmutfak', 'http://thumbs.cdn.web.tv/hf/st/hfstrh3lcqs_140x79.jpg'),
         ('http://anctv.web.tv', 'anctv', 'http://thumbs.cdn.web.tv/wa/5n/wa5nu5rsjyu_140x79.jpg'),
         ('http://hmtv.web.tv', 'hmtv', 'http://thumbs.cdn.web.tv/fx/bn/fxbn6jsi37e_140x79.jpg'),
         ('http://worldtravelchannel.web.tv', 'worldtravelchannel', 'http://thumbs.cdn.web.tv/wd/25/wd251ygdkoo_140x79.jpg'),
         ('http://megazin.web.tv', 'megazin', 'http://thumbs.cdn.web.tv/d3/aj/d3ajfvnoese_140x79.jpg'),
         ('http://tgrtbelgesel.web.tv', 'tgrtbelgesel', 'http://thumbs.cdn.web.tv/iu/oh/iuohc6lxt8u_140x79.jpg'),
         ('http://kanal27.web.tv', 'Kanal27', 'http://thumbs.cdn.web.tv/mg/fj/mgfjy4eziby_140x79.jpg'),
         ('http://kanal48.web.tv', 'Kanal48', 'http://static.cdn.web.tv/images/default_7k_140x79.jpg')]
        for url, title, img in webtv_list:
            self.cat_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def ok(self):
        if self.index == 'cat':
            url = self['menulist'].getCurrent()[0][1]
            getPage(url, timeout=8, method='GET', cookies=cj, headers={'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36'}).addCallback(self.get_hls)

    def get_hls(self, data):
        print data
        file = re.findall('"mediaUrl":"(.*?)",', data)
        if file:
            data = file[0].replace('\\', '')
            self.play_that_shit(data)
        else:
            file = re.findall('"sources":.*?"src":"(.*?)"', data)
            if file:
                data = file[0].replace('\\', '')
                self.play_that_shit(data)

    def play_that_shit(self, data):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        if self.index == 'cat':
            self.close()
        elif self.index == 'channels':
            self.index = 'cat'
            self['menulist'].l.setList(self.cat_list)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/Albatros/poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/shahidSeries/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print 'logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print 'no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/Albatros/'):
            os.system('mkdir /tmp/Albatros/')
        else:
            print '/tmp/Albatros/ allready present'