 # -*- coding: utf-8 -*-
from setup import *
from imports import *
import requests,re

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res
	
def cat_(name,link):	
    res = [(name, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res

class mhdtvlive(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('Mhdtvlive')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.abc)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        if self.index=='cat':
            self[self.currentList].up()
        elif self.index=='channels':
            self[self.currentList].up()		
            self.load_poster()

    def down(self):
        if self.index=='cat':
            self[self.currentList].down()
        elif self.index=='channels':
            self[self.currentList].down()
            self.load_poster()

    def left(self):
        if self.index=='cat':
            self[self.currentList].pageUp()
        elif self.index=='channels':
            self[self.currentList].pageUp()
            self.load_poster()

    def right(self):
        if self.index=='cat':	
            self[self.currentList].pageDown()
        elif self.index=='channels':
            self[self.currentList].pageDown()
            self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'


    def abc(self):
        self.index='cat'
        self.loading_ok = False
        self.check = 'abc'
        self.ch_list = []
        self.currentList = 'menulist'
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        sportstv_list=[]
        cat_list=[("http://mhdtvlive.com/malayalam_channels","Malayalam"),
        ("http://mhdtvlive.com/tamil_channels","Tamil"),
        ("http://mhdtvlive.com/telugu_channels","Telugu"),
        ("http://mhdtvlive.com/kannada_channels","Kannada"),
        ("http://mhdtvlive.com/hindi_channels","Hindi"),
        ("http://mhdtvlive.com/english_channels","English"),
        ("http://mhdtvlive.com/sport","Sports"),]
        for (url,title) in cat_list:
            self.ch_list.append(cat_(title,url))
        self['menulist'].l.setList(self.ch_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
			
			  
    def get_channels(self,url):
        self.index='channels'
        self.ch_l=[]
        data=requests.get(url).text		
        ch=re.findall('<a title="(.*?)" href="(.*?)"><img width="134" height="101" src="(.*?)"',data)
        for (title,url,img) in ch:
            self.ch_l.append(show_(str(title),str(url),str(img)))
        self['menulist'].l.setList(self.ch_l)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def get_iframe(self,url):
        data=requests.get(url).text
        frame=re.findall('<iframe.*?src="(.*?)" name="iframe_a"',data)
        if frame:
            data=requests.get(frame[0]).text
            stream=re.findall('var stream = "(.*?)";',data)
            if stream:
                self.play_that_shit(str(stream[0]))
				
    def ok(self):
        if self.index=='cat':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            self.get_channels(uri)
        elif self.index=='channels':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            self.get_iframe(uri)           
           

    def play_that_shit(self, data):
        name = self['menulist'].l.getCurrentSelection()[0][0]	
        sref = eServiceReference(4097, 0, data)
        sref.setName(name)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        if self.index=='cat':
            self.close()          
        elif self.index=='channels':
            self.abc()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(jpg_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later on'), MessageBox.TYPE_INFO, timeout=3)

    def errorload2(self, error):
        print '[teledunet] error %s' % error
        count_movies = len(self.letter_movielist)
        self.loading_ok = True
        self.loading = 0
        self.count = 0

    def errorload(self, error):
        print error

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'