# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/hoofoot.py
from setup import *
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show3_(name, link, img, id):
    res = [(name,
      link,
      img,
      id)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class hoofoot(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('hoofoot.com')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.cat)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def cat(self):
        self.currentList = 'menulist'
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.index = 'cat'
        self.hoofoot_list = []
        self.cat_list = [('England', '1', 'http://flaglane.com/download/english-flag/english-flag-graphic.png'),
         ('Spain', '1', 'https://upload.wikimedia.org/wikipedia/en/thumb/9/9a/Flag_of_Spain.svg/750px-Flag_of_Spain.svg.png'),
         ('Italy', '1', 'http://flaglane.com/download/italian-flag/italian-flag-graphic.png'),
         ('Germany', '1', 'http://flaglane.com/download/german-flag/german-flag-graphic.png'),
         ('France', '1', 'http://flaglane.com/download/french-flag/french-flag-graphic.png'),
         ('Netherland', '1', 'https://upload.wikimedia.org/wikipedia/commons/thumb/b/b2/Flag_of_the_Netherlands.png/800px-Flag_of_the_Netherlands.png'),
         ('Europe', '1', 'http://vignette2.wikia.nocookie.net/gtawiki/images/b/b1/Flag_of_the_European_Union.png/revision/latest/scale-to-width-down/640?cb=20100228152929'),
         ('International', '1', 'http://gallery.yopriceville.com/var/resizes/Free-Clipart-Pictures/Sport-PNG/Football_with_Flags_Transparent_PNG_Clipart_Picture.png?m=1399672800'),
         ('Extras', '1', 'http://gallery.yopriceville.com/var/resizes/Free-Clipart-Pictures/Sport-PNG/Football_with_Flags_Transparent_PNG_Clipart_Picture.png?m=1399672800')]
        for title, url, img in self.cat_list:
            self.hoofoot_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.hoofoot_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def abc(self):
        self.loading_ok = False
        self.check = 'abc'
        self.currentList = 'menulist'
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.index = 'cat_country'
        self.sel_list = []
        self.s1_list = []
        self.sel = self['menulist'].l.getCurrentSelection()[0][0]
        if self.sel == 'England':
            self.sel_list.append(show_('Premier League', 'http://hoofoot.com/?idp=21', 'https://upload.wikimedia.org/wikipedia/de/thumb/e/ef/Logo_FA_Premier_League.svg/300px-Logo_FA_Premier_League.svg.png'))
            self.sel_list.append(show_('ChampionShip', 'http://hoofoot.com/?idp=29', 'http://t2.gstatic.com/images?q=tbn:ANd9GcTS-DGqilQo7DaylaV3Y-UP96GPUt-TUOy6RcMJ3wKkfReKyKeiI0On0A'))
            self.sel_list.append(show_('Capital One Cup', 'http://hoofoot.com/?idp=33', 'https://upload.wikimedia.org/wikipedia/en/a/a4/Capital_One_Cup_logo.png'))
            self.sel_list.append(show_('Carling Cup', 'http://hoofoot.com/?idp=13', 'http://vignette1.wikia.nocookie.net/the-football-database/images/5/5f/Carling_Cup_logo.png/revision/latest?cb=20150302153228'))
            self.sel_list.append(show_('Fa Cup', 'http://hoofoot.com/?idp=14', 'http://vignette1.wikia.nocookie.net/logopedia/images/8/80/The_FA_Cup_logo_%28Budweiser_sponsor%29.png/revision/latest?cb=20120430181029'))
        elif self.sel == 'Spain':
            self.sel_list.append(show_('La liga', 'http://hoofoot.com/?idp=19', 'http://usclubsoccer.org/wp-content/uploads/2015/08/LALIGA_LOGO_V_2015-01COLOR-BLANCO-cropped.png'))
            self.sel_list.append(show_('Copa Del Rey', 'http://hoofoot.com/?idp=12', 'https://upload.wikimedia.org/wikipedia/en/6/6c/Copa_del_Rey_logo_since_2012.png'))
        elif self.sel == 'Italy':
            self.sel_list.append(show_('Serie A', 'http://hoofoot.com/?idp=17', 'http://vignette4.wikia.nocookie.net/fifa14/images/1/13/Serie-A-logo.png/revision/latest?cb=20130525052432'))
            self.sel_list.append(show_('Coppa Italia', 'http://hoofoot.com/?idp=22', 'https://upload.wikimedia.org/wikipedia/it/thumb/6/62/Logo_Tim_Cup_%28Coppa_Italia%29_dal_2016.png/167px-Logo_Tim_Cup_%28Coppa_Italia%29_dal_2016.png'))
        elif self.sel == 'Germany':
            self.sel_list.append(show_('BundesLiga', 'http://hoofoot.com/?idp=5', 'http://vignette2.wikia.nocookie.net/fifa/images/7/73/Bundesliga_Logo.png/revision/latest%3Fcb%3D20131215160434&imgrefurl=http://fifa.wikia.com/wiki/File:Bundesliga_Logo.png&h=441&w=500&tbnid=Pg4DfGa9SLoSdM:&tbnh=90&tbnw=102&docid=ZcyTt_TJ1HDXwM&usg=__6tY89wyPiRq4zcVGk8YC-5XQWzs=&sa=X&sqi=2&ved=0ahUKEwj_25Dnhr7LAhVGCpoKHflNA8UQ9QEIHjAA'))
            self.sel_list.append(show_('DFB Pokal', 'http://hoofoot.com/?idp=25', 'http://vignette3.wikia.nocookie.net/bundesliga/images/8/81/DFB-Pokal-Logo.png/revision/latest/scale-to-width-down/480?cb=20090505151537&path-prefix=de'))
        elif self.sel == 'France':
            self.sel_list.append(show_('Ligue 1', 'http://hoofoot.com/?idp=18', 'http://vignette1.wikia.nocookie.net/fifa14/images/f/f6/Ligue_1_Logo.png/revision/latest/scale-to-width-down/308?cb=20130603161315'))
            self.sel_list.append(show_('Coupe De France', 'http://hoofoot.com/?idp=4', 'https://upload.wikimedia.org/wikipedia/en/thumb/3/3a/Coupe_de_France_logo.svg/374px-Coupe_de_France_logo.svg.png'))
            self.sel_list.append(show_('Coupe De la Ligue', 'http://hoofoot.com/?idp=27', 'https://upload.wikimedia.org/wikipedia/en/thumb/e/e5/Logo_coupe_ligue.png/375px-Logo_coupe_ligue.png'))
        elif self.sel == 'Netherland':
            self.sel_list.append(show_('Eredivisie', 'http://hoofoot.com/?idp=23', 'http://t3.gstatic.com/images?q=tbn:ANd9GcSA0dDrDRYY2wiLrQCKWxkl9cLfivgATO3vD9PhxuyjIbnC_LKNNj8vSQ'))
        elif self.sel == 'Europe':
            self.sel_list.append(show_('Champions League', 'http://hoofoot.com/?idp=15', 'https://upload.wikimedia.org/wikipedia/en/thumb/b/bf/UEFA_Champions_League_logo_2.svg/200px-UEFA_Champions_League_logo_2.svg.png'))
            self.sel_list.append(show_('EURO 2016 Qualifying', 'http://hoofoot.com/?idp=101', 'https://upload.wikimedia.org/wikipedia/en/thumb/f/f1/UEFA_Euro_2016_Logo.svg/286px-UEFA_Euro_2016_Logo.svg.png'))
            self.sel_list.append(show_('Europa League', 'http://hoofoot.com/?idp=16', 'http://vignette4.wikia.nocookie.net/the-football-database/images/9/9d/UEFA_Europa_League_Logo.png/revision/latest?cb=20130807160412'))
            self.sel_list.append(show_('Super Cup', 'http://hoofoot.com/?idp=35', 'https://upload.wikimedia.org/wikipedia/en/8/8a/UEFA_Super_Cup.png'))
        elif self.sel == 'International':
            self.sel_list.append(show_('World Cup 2014', 'http://hoofoot.com/?idp=94', 'https://upload.wikimedia.org/wikipedia/en/thumb/e/e8/WC-2014-Brasil.svg/480px-WC-2014-Brasil.svg.png'))
            self.sel_list.append(show_('Confederations Cup', 'http://hoofoot.com/?idp=6', 'https://upload.wikimedia.org/wikipedia/en/c/cc/CAF_Confederation_Cup_logo.png'))
            self.sel_list.append(show_('Club World Cup', 'http://hoofoot.com/?idp=36', 'https://upload.wikimedia.org/wikipedia/commons/thumb/7/7a/FIFA_Club_World_Cup.svg/237px-FIFA_Club_World_Cup.svg.png'))
            self.sel_list.append(show_('Africa Cup of Nations', 'http://hoofoot.com/?idp=11', 'https://upload.wikimedia.org/wikipedia/en/4/4e/2015_Africa_Cup_of_Nations_logo.png'))
            self.sel_list.append(show_('World Cup Qualifiers', 'http://hoofoot.com/?idp=31', 'https://upload.wikimedia.org/wikipedia/en/thumb/c/c4/2018_FIFA_WC.svg/281px-2018_FIFA_WC.svg.png'))
            self.sel_list.append(show_('Friendly Match', 'http://hoofoot.com/?idp=24', 'http://3.bp.blogspot.com/_rvWQQMJ8Ij0/S_f9mHMZiRI/AAAAAAAAAww/TJ4mMbU8FoA/s1600/fifa_logo11.png'))
            self.sel_list.append(show_('London2012', 'http://hoofoot.com/?idp=32', 'https://upload.wikimedia.org/wikipedia/en/thumb/f/f4/2012_Summer_Olympics_logos.svg/591px-2012_Summer_Olympics_logos.svg.png'))
        elif self.sel == 'Extras':
            self.sel_list.append(show_('Russian Premier League', 'http://hoofoot.com/?idp=95', 'https://upload.wikimedia.org/wikipedia/en/thumb/8/8c/Ukrainian_Premier_League.png/150px-Ukrainian_Premier_League.png'))
            self.sel_list.append(show_('Major League Soccer', 'http://hoofoot.com/?idp=96', 'http://vignette1.wikia.nocookie.net/logopedia/images/1/15/Major_League_Soccer.png/revision/latest?cb=20100921052256'))
            self.sel_list.append(show_('Scottish Premiership', 'http://hoofoot.com/?idp=109', 'https://upload.wikimedia.org/wikipedia/en/thumb/3/33/Scottish_Professional_Football_League.svg/220px-Scottish_Professional_Football_League.svg.png'))
            self.sel_list.append(show_('Turkish Super Lig', 'http://hoofoot.com/?idp=99', 'https://upload.wikimedia.org/wikipedia/de/thumb/8/86/Spor_Toto_S%C3%BCper_Lig_logo.png/150px-Spor_Toto_S%C3%BCper_Lig_logo.png'))
            self.sel_list.append(show_('Liga Sagres', 'http://hoofoot.com/?idp=92', 'http://vignette4.wikia.nocookie.net/logopedia/images/0/03/Liga_ZON_Sagres_logo.png/revision/latest/scale-to-width-down/504?cb=20130413154704'))
            self.sel_list.append(show_('Amazing Goals', 'http://hoofoot.com/?idp=26', 'https://upload.wikimedia.org/wikipedia/commons/thumb/3/3a/GOALS_logo.png/800px-GOALS_logo.png'))
            self.sel_list.append(show_('A-league', 'http://hoofoot.com/?idp=110', 'https://upload.wikimedia.org/wikipedia/en/thumb/2/22/Hyundai_A-League_logo.svg/405px-Hyundai_A-League_logo.svg.png'))
        print self.sel_list
        self['menulist'].l.setList(self.sel_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def load_data_channels(self, data):
        self.index = 'matches'
        self.letter_list = []
        channels = re.findall('<div id="gggg">\n.*?<a id="rut.*?" href="\\./(.*?)">\n<h2 id=".*?"><img src="./(.*?)" width="12" height="12" style="float:left;margin-bottom:-7px;margin-top:-3px;margin-left:5px;width:12px;height:12px;visibility:hidden;"/>(.*?)</h2>', data)
        print channels
        for url, img, title in channels:
            url = 'http://hoofoot.com/' + url
            img = 'http://hoofoot.com/' + img
            self.letter_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.letter_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def get_hls(self, url):
        getPage(url, timeout=8, method='GET', headers={'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
         'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
         'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.play_that_shit)

    def ok(self):
        if self.index == 'cat':
            self.abc()
        elif self.index == 'cat_country':
            url = self['menulist'].l.getCurrentSelection()[0][1]
            getPage(url, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.load_data_channels)
        elif self.index == 'matches':
            url = self['menulist'].l.getCurrentSelection()[0][1]
            self.get_hls(url)

    def play_that_shit(self, data):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        hls = re.findall('<iframe src="(.*?)" frameborder="0" allowfullscreen webkitallowfullscreen mozallowfullscreen scrolling="no"></iframe>', data)
        print hls
        if hls:
            print hls
            req = urllib2.Request(hls[0])
            req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
            req.add_header('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8')
            page = urllib2.urlopen(req)
            r = page.read()
            print r
            fin_uri = re.findall('<meta property="og\\:video\\:url" content="(https://.*?)">', r)
            if fin_uri:
                fin_uri = fin_uri[1]
                fin_uri = fin_uri.replace('amp;', '')
                print fin_uri
                vid = 'http://127.0.0.1:88/httpstream://' + fin_uri + ' headers={"Host":"d1wst0behutosd.cloudfront.net","User-Agent":"Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.87 Safari/537.36"}'
                sref = eServiceReference(4097, 0, vid)
                sref.setName(selectedName)
                self.session.open(MoviePlayer, sref)
        else:
            hls = re.findall('<iframe src="(http://vk.com.*?)" width="..." height="..." frameborder="0"></iframe>', data)
            print hls
            if hls:
                req = urllib2.Request(hls[0])
                req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
                req.add_header('Host', 'vk.com')
                page = urllib2.urlopen(req)
                r = page.read()
                print r
                fin_uri = re.findall('url720=(.*?)&amp', r)
                if fin_uri:
                    print fin_uri
                    fin_uri = fin_uri[0]
                else:
                    fin_uri = re.findall('url480=(.*?)&amp', r)
                    if fin_uri:
                        print fin_uri
                        fin_uri = fin_uri[0]
                fin_uri = fin_uri.replace('\\', '')
                print fin_uri
                sref = eServiceReference(4097, 0, fin_uri)
                sref.setName(selectedName)
                self.session.open(MoviePlayer, sref)
            else:
                hls = re.findall('<iframe src="(http://www.dailymotion.com/embed/video/.*?)" frameborder="0"></iframe>', data)
                print hls
                if hls:
                    req = urllib2.Request(hls[0])
                    req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
                    #req.add_header('Host', 'vk.com')
                    page = urllib2.urlopen(req)
                    r = page.read()
                    print r
                    fin_uri = re.findall('url720=(.*?)&amp', r)
                    if fin_uri:
                        print fin_uri
                        fin_uri = fin_uri[0]
                

    def exit(self):
        self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later on'), MessageBox.TYPE_INFO, timeout=3)

    def errorload2(self, error):
        print '[teledunet] error %s' % error
        count_movies = len(self.letter_movielist)
        self.loading_ok = True
        self.loading = 0
        self.count = 0

    def errorload(self, error):
        print error

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'