# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/hayyes.py
from imports import *
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class hayyes(Screen):

    def __init__(self, session):
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit,
         'blue': self.dnitnow}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label('Plugin Auswahl')
        self['poster'] = Pixmap()
        self['title'] = Label('hayyes.com')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.list_cat)

    def about(self):
        self.session.open(AboutScreen)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def list_cat(self):
        self.info = 'list_cat'
        self.cat_list = []
        cat = [('\xd9\x85\xd8\xb3\xd9\x84\xd8\xb3\xd9\x84\xd8\xa7\xd8\xaa \xd8\xaa\xd8\xb1\xd9\x83\xd9\x8a\xd8\xa9', 'http://www.hayyes.com/vod/mosalsalat/turkish/list?page=', 'http://www.uiraqi.com/up/uploads/uiraqi_1391673171041.jpg'),
         ('\xd9\x85\xd8\xb3\xd9\x84\xd8\xb3\xd9\x84\xd8\xa7\xd8\xaa \xd8\xb1\xd9\x85\xd8\xb6\xd8\xa7\xd9\x86', 'http://www.hayyes.com/vod/mosalsalat/ramadan/list?page=', 'http://onaeg.com/wp-content/uploads/2014/07/2362014-103147AM.jpg'),
         ('\xd9\x85\xd8\xb3\xd9\x84\xd8\xb3\xd9\x84\xd8\xa7\xd8\xaa \xd9\x85\xd8\xb5\xd8\xb1\xd9\x8a\xd8\xa9', 'http://www.hayyes.com/vod/mosalsalat/egyptian/list?page=', 'http://www10.0zz0.com/2013/06/11/09/398209032.jpg'),
         ('\xd9\x85\xd8\xb3\xd9\x84\xd8\xb3\xd9\x84\xd8\xa7\xd8\xaa \xd8\xb3\xd9\x88\xd8\xb1\xd9\x8a\xd8\xa9', 'http://www.hayyes.com/vod/mosalsalat/syrian/list?page=', 'http://all4syria.info/wp-content/uploads/2014/01/1490987_10151942142924315_825139288_n.jpg'),
         ('\xd9\x85\xd8\xb3\xd9\x84\xd8\xb3\xd9\x84\xd8\xa7\xd8\xaa \xd9\x85\xd8\xaf\xd8\xa8\xd9\x84\xd8\xac\xd8\xa9', 'http://www.hayyes.com/vod/mosalsalat/dubbed/list?page=', 'http://vignette1.wikia.nocookie.net/smurfs/images/9/95/SmurfsRestoredArabicTitle.jpg'),
         ('\xd9\x85\xd8\xb3\xd9\x84\xd8\xb3\xd9\x84\xd8\xa7\xd8\xaa \xd8\xae\xd9\x84\xd9\x8a\xd8\xac\xd9\x8a\xd8\xa9', 'http://www.hayyes.com/vod/mosalsalat/gulf/list?page=', 'http://www.wataan.com/uploads/552015-030719AM.jpg'),
         ('\xd9\x85\xd9\x80\xd9\x80\xd8\xb3\xd8\xb1\xd8\xad\xd9\x80\xd9\x80\xd9\x8a\xd8\xa7\xd8\xaa', 'http://www.hayyes.com/vod/mosalsalat/play/list?page=', 'http://www.hayyes.com/sites/default/files/styles/200/public/tiatro_masr1.jpg'),
         ('\xd8\xa8\xd8\xb1\xd8\xa7\xd9\x85\xd8\xac \xd8\xaa\xd9\x84\xd9\x81\xd8\xb2\xd9\x8a\xd9\x88\xd9\x86', 'hhttp://www.hayyes.com/vod/mosalsalat/tv-shows/list?page=', 'http://trendingdig.com/beta-wordpress/wp-content/uploads/2013/05/Talent-shows-logos.jpg')]
        for each in cat:
            category, link, thumb = each
            self.cat_list.append(show_(category, link, thumb))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def list_shows(self, link):
        self.info = 'list_shows'
        self.show_list = []
        i = 0
        for i in range(0, 8):
            uri = link + str(i)
            print uri
            getPage(uri, timeout=8, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_it, link)
            i += 1

    def list_it(self, data, link):
        movies = re.findall('<img typeof="foaf:Image" src="(http://www.hayyes.com/sites/default/files/styles/200/public/.*?)" width="200" height="110" alt="" />.*?<a href="(.*?)">(.*?)</a>', data, re.DOTALL)
        for each in movies:
            thumb, path, name = each
            path = 'http://www.hayyes.com' + str(path)
            self.show_list.append(show_(name, path, thumb))
            print thumb

        self['menulist'].l.setList(self.show_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def list_episodes(self, path):
        self.info = 'list_episodes'
        self.episodes_list = []
        getPage(path, timeout=8, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_episodes1, path)

    def list_episodes1(self, data, path):
        episodes = re.findall('class="views-field views-field-view-node">.*?src="(http://www.hayyes.com/sites/default/files/styles/219/public/.*?)".*?<a href="(/vod/.*?)">(.*?)</a>.*?<div class="views-field views-field-field-episode-number">        <div class="field-content">(.*?)</div>', data, re.DOTALL)
        for each in episodes:
            thumb, path, name, info = each
            path = 'http://www.hayyes.com' + str(path)
            self.episodes_list.append(episodes_(name, path, thumb, info))

        self['menulist'].l.setList(self.episodes_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def get_play_link(self, data, path):
        print 'now we search the rtmp url'
        getPage(path, timeout=8, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.read_link, path)

    def read_link(self, data, path):
        link = re.findall('var streamfile = "rtmp://(.*?)";', data, re.DOTALL)
        print link
        playp = str(link[0]).replace('streaming.hayyes.com/vod/', '')
        if link:
            self.play_movie('rtmp://streaming.hayyes.com/vod' + ' app=vod/ playpath=' + playp + ' live=1 swfUrl=http://www.hayyes.com/sites/all/themes/hys/tpl/jw/jwplayer.flash.swf pageUrl=http://www.hayyes.com/')

    def play_movie(self, link):
        if link:
            sref = eServiceReference(4097, 0, link)
            sref.setName(self.filmname)
            self.session.open(MoviePlayer, sref)

    def ok(self):
        if self.info == 'list_cat':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            self.list_shows(url)
        elif self.info == 'list_shows':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            self.list_episodes(url)
        elif self.info == 'list_episodes':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            self.filmname = str(selectedName)
            self.get_play_link(self.filmname, url)

    def exit(self):
        print self.info
        if re.match('(list_cat)', self.info, re.S | re.I):
            if fileExists('/tmp/hayyes_poster.jpg'):
                os.system('rm -r /tmp/hayyes_poster.jpg')
            self.close(self.session, 'exit')
        elif self.info == 'list_shows':
            self.info = 'list_cat'
            self['blue'].hide()
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'list_episodes':
            self.info = 'list_shows'
            self['menulist'].l.setList(self.show_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'list_streams':
            self.info = 'list_episodes'
            self['blue'].hide()
            self['menulist'].l.setList(self.episodes_list)
            self['menulist'].l.setItemHeight(40)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/hayyes_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/hayyes/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[hayyes] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[hayyes] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/hayyes/'):
            os.system('mkdir /tmp/hayyes/')
        else:
            print '[hayyes] /tmp/hayyes/ allready present'


def main(session, **kwargs):
    session.open(hayyes)


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    return [PluginDescriptor(name='hayyes', description='hayyes Streamer', where=[PluginDescriptor.WHERE_PLUGINMENU], fnc=main, icon='plugin.png')]