# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/bangalian.py
from setup import *
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class bangalian(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['title'] = Label('bangalian.tv')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.abc)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        self[self.currentList].up()
        self.load_poster()

    def down(self):
        self[self.currentList].down()
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def abc(self):
        self.loading_ok = False
        self.check = 'abc'
        self.currentList = 'menulist'
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.genre_name = 'Al Cinema'
        self.load_data_channels()

    def load_data_channels(self):
        self.index = '1'
        self.letter_list = []
        bangalian_list = [('ATN NEWS', 'http://www.bangalian.com/atn-news/', 'http://www.bangalian.com/wp-content/uploads/2015/06/Atn-news-310x205.jpg'),
         ('BanglaVision', 'http://www.bangalian.com/banglavision/', 'http://www.bangalian.com/wp-content/uploads/2015/06/banglavission-310x205.jpg'),
         ('Channel I', 'http://www.bangalian.com/channel-i/', 'http://www.bangalian.com/wp-content/uploads/2015/06/chaneli_banglawatch-310x205.jpg'),
         ('Ekattor TV', 'http://www.bangalian.com/ekattor-tv/', 'http://www.bangalian.com/wp-content/uploads/2015/06/71-tv-310x205.jpg'),
         ('Ekushey TV', 'http://www.bangalian.com/ekushey-tv/', 'http://www.bangalian.com/wp-content/uploads/2015/06/etv-310x205.jpg'),
         ('Gaan Bangla', 'http://www.bangalian.com/gaan-bangla/', 'http://www.bangalian.com/wp-content/uploads/2015/06/gaan-bangla-310x205.jpg'),
         ('Independent TV', 'http://www.bangalian.com/independent-tv/', 'http://www.bangalian.com/wp-content/uploads/2015/06/independant-310x205.jpg'),
         ('Jamuna TV', 'http://www.bangalian.com/jamuna-tv/', 'http://www.bangalian.com/wp-content/uploads/2015/06/jamuna-310x205.jpg'),
         ('Ntv Bangladesh', 'http://www.bangalian.com/ntv-bangladesh/', 'http://www.bangalian.com/wp-content/uploads/2015/06/ntv_bangladesh-310x205.jpg'),
         ('SA TV', 'http://www.bangalian.com/sa-tv/', 'http://www.bangalian.com/wp-content/uploads/2015/06/sa-tv-1-110x75.jpg'),
         ('Somoy TV', 'http://www.bangalian.com/somoy-tv/', 'http://www.bangalian.com/wp-content/uploads/2015/06/somoy-310x205.png')]
        for each in bangalian_list:
            playpath, url, img = each
            self.letter_list.append(show_(playpath, url, img))

        self['menulist'].l.setList(self.letter_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()

    def ok(self):
        rest = ' flashVer=WIN%2015,0,0,189 app=live/ swfUrl=http://p.jwpcdn.com/6/6/jwplayer.flash.swf pageUrl=http://yoolive.com live=1 timeout=15'
        from cookielib import CookieJar, DefaultCookiePolicy
        policy = DefaultCookiePolicy(rfc2965=True, strict_ns_domain=DefaultCookiePolicy.DomainStrict, blocked_domains=['ads.net', '.ads.net'])
        cj = CookieJar(policy)
        opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
        if self.check == 'abc':
            cj = cookielib.CookieJar()
            opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            self.loading_ok = False
            req = urllib2.Request(selectedEntry)
            req.add_header('Referer', 'http://www.bangalian.com/category/bangla-tv/')
            req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
            page = opener.open(selectedEntry)
            response = page.read()
            page.close()
            iframe = re.findall('<iframe id="tvframe" src="(.*?)"', response)
            print iframe[0]
            page = opener.open(iframe[0])
            response = page.read()
            print response
            page.close()
            rtmp_link = re.findall("file:'(.*?)'", response, re.DOTALL)
            print rtmp_link
            final_url = rtmp_link[1] + ' swfUrl=http://www.bangalian.com/jwplayer/jwplayer.flash.swf pageurl=http://www.bangalian.com/player.php?q=eyJmaWxlIjoicnRtcDpcL1wvbGl2ZS5iYW5nYWxpYW4uY29tXC9saXZlX25vdHJhbnNjb2RlXC9zYXR2MSIsImltYWdlIjoiaHR0cDpcL1wvd3d3LmJhbmdhbGlhbi5jb21cL3dwLWNvbnRlbnRcL3VwbG9hZHNcLzIwMTVcLzA2XC9zYS10di0xLmpwZyIsImZpbGUyIjpudWxsLCJmaWxlMyI6InJ0bXA6XC9cL2xpdmUuYmFuZ2FsaWFuLmNvbVwvbGl2ZV9ub3RyYW5zY29kZVwvc2F0djIiLCJmaWxlNCI6Imh0dHA6XC9cLzEwMy4yNTQuMTUzLjEzMDoxOTM1XC9saXZlX25vdHJhbnNjb2RlXC9zYXR2MVwvcGxheWxpc3QubTN1OCJ9'
            self.play_that_shit(final_url)

    def play_that_shit(self, data):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later on'), MessageBox.TYPE_INFO, timeout=3)

    def errorload2(self, error):
        print '[teledunet] error %s' % error
        count_movies = len(self.letter_movielist)
        self.loading_ok = True
        self.loading = 0
        self.count = 0

    def errorload(self, error):
        print error

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'