# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/arconaitv.py
from setup import *
from imports import *
cj = {}

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show3_(name, link, img, id):
    res = [(name,
      link,
      img,
      id)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class arconaitv(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('arconaitv.me')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.abc)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        self[self.currentList].up()
        self.load_poster()

    def down(self):
        self[self.currentList].down()
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def abc(self):
        self.loading_ok = False
        self.check = 'abc'
        self.index = '0'
        self.currentList = 'menulist'
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.genre_name = 'Al Cinema'
        self.sel_list = [('Channels', '1', 'https://arconaitv.me/wp-content/uploads/2015/06/svs.png'), ('CableTV', '2', 'https://arconaitv.me/wp-content/uploads/2015/06/svs.png'), ('Movies', '3', 'https://arconaitv.me/wp-content/uploads/2015/06/svs.png')]
        for title, url, img in self.sel_list:
            self.letter_movielist.append(show_(title, url, img))

        self['menulist'].l.setList(self.letter_movielist)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()

    def load_data_channels(self):
        self.index = '1'
        self.letter_list = []
        self.selected = self['menulist'].l.getCurrentSelection()[0][1]
        if self.selected == '1':
            self.ch_list = [('Adult Swim', 'https://www.arconaitv.me/as/', 'http://www.arconaitv.me/wp-content/uploads/2015/06/ad.png'),
             ('Adventure Time', 'https://www.arconaitv.me/at/', 'http://www.arconaitv.me/wp-content/uploads/2015/06/tumblr_nmixkmD0tk1r7oy5so2_500.jpg'),
             ('Its always sunny in Philadelphia', 'https://www.arconaitv.me/asip/', 'http://www.arconaitv.me/wp-content/uploads/2015/06/10.png'),
             ('American Dad', 'https://www.arconaitv.me/amerro/', 'http://www.arconaitv.me/wp-content/uploads/2015/06/3.png'),
             ('Archer', 'https://www.arconaitv.me/arc/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/4.png '),
             ('Futurama', 'https://www.arconaitv.me/future/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/9.png'),
             ('Bobs Burgers', 'https://www.arconaitv.me/bb/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/6.png'),
             ('Community', 'https://www.arconaitv.me/com/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/7.png'),
             ('Family Guy', 'https://www.arconaitv.me/fg/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/8.png'),
             ('Movie Channel', 'https://www.arconaitv.me/moovaye/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/16.png'),
             ('Invader Zim', 'https://www.arconaitv.me/iz/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/12.png'),
             ('King of the Hill', 'https://www.arconaitv.me/koth/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/13.png'),
             ('Bugs Bunny', 'https://www.arconaitv.me/ct/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/14.png'),
             ('Seinfeld', 'https://www.arconaitv.me/sf/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/20.png'),
             ('Regular Show', 'https://www.arconaitv.me/rs/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/17.jpg'),
             ('Rick and Marty', 'https://www.arconaitv.me/rm/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/18.png'),
             ('Samuraj Jack', 'https://www.arconaitv.me/sj/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/19.jpg '),
             ('Workaholics', 'https://www.arconaitv.me/workers/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/24.png'),
             ('The Simpsons', 'https://www.arconaitv.me/s/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/22.png'),
             ('South Park', 'https://www.arconaitv.me/sp/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/23.png'),
             ('FlapJack', 'https://www.arconaitv.me/flapjack/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/5.jpg'),
             ('The Office', 'https://www.arconaitv.me/to/', 'https://www.arconaitv.me/wp-content/uploads/2015/07/the-office.jpg'),
             ('Better Call Saul', 'https://www.arconaitv.me/bcs/', 'https://www.arconaitv.me/wp-content/uploads/2015/06/5.png'),
             ('Anime Channel', 'https://arconaitv.me/animes', 'https://www.arconaitv.me/wp-content/uploads/2015/09/anime-cover-page.png'),
             ('DragonBall Z', 'https://arconaitv.me/dbz', 'https://www.arconaitv.me/wp-content/uploads/2015/11/dragonballz.jpg'),
             ('I Love Lucy', 'https://arconaitv.me/ill', 'https://www.arconaitv.me/wp-content/uploads/2015/11/I-love-lucy.jpg'),
             ('Game of Thrones', 'https://arconaitv.me/got', 'https://www.arconaitv.me/wp-content/uploads/2015/11/game-off-thrones.jpg'),
             ('The Big Bang Theory', 'https://arconaitv.me/tbbt', 'https://www.arconaitv.me/wp-content/uploads/2015/11/the-big-bang-theory.jpg'),
             ('Celebrity Deathmatch', 'https://arconaitv.me/cdm', 'https://www.arconaitv.me/wp-content/uploads/2015/11/celebrity.jpg'),
             ('The Fresh Prince', 'https://www.arconaitv.me/fpb/', 'https://www.arconaitv.me/wp-content/uploads/2015/11/fresh-prince-2.jpg'),
             ('Curb your Enthusiasm', 'https://arconaitv.me/cye', 'https://www.arconaitv.me/wp-content/uploads/2015/11/curb-your.jpg'),
             ('Ren and Stimpy', 'https://arconaitv.me/renstimp', 'https://www.arconaitv.me/wp-content/uploads/2015/11/Ren-and-Stimpy.jpg'),
             ('Whose Line is it anyway ?', 'https://arconaitv.me/whoseline', 'https://www.arconaitv.me/wp-content/uploads/2015/12/whose-line.jpg'),
             ('That 70s Show', 'https://arconaitv.me/70s', 'https://www.arconaitv.me/wp-content/uploads/2015/12/70s-show.jpg'),
             ('Scrubs', 'https://www.arconaitv.me/scroobs', 'https://www.arconaitv.me/wp-content/uploads/2015/12/scrubs.jpg'),
             ('Shark Tank', 'https://arconaitv.me/st', 'https://www.arconaitv.me/wp-content/uploads/2015/12/shark-tank.jpg'),
             ('Trailer Park Boys', 'https://arconaitv.me/trailergeeks', 'https://www.arconaitv.me/wp-content/uploads/2015/11/Trailer-Park-Boys.jpg'),
             ('The Sopranos', 'https://arconaitv.me/soapnos', 'https://www.arconaitv.me/wp-content/uploads/2016/02/The_sopranos.jpg'),
             ('Friends', 'https://arconaitv.me/friendship', 'https://www.arconaitv.me/wp-content/uploads/2016/03/Friends-ShowcardVertical1.jpg')]
        elif self.selected == '2':
            self.ch_list = [('ABC', 'https://www.arconaitv.me/abcde/', 'http://mc.ustvnow.com/images/WHTM.png'),
             ('A&E', 'https://www.arconaitv.me/ae/', 'http://mc.ustvnow.com/images/AETV.png'),
             ('AMC', 'https://www.arconaitv.me/am/', 'http://www.lyngsat-logo.com/logo/tv/aa/amc_us.png'),
             ('Animal Planet', 'https://www.arconaitv.me/ap/', 'http://vignette1.wikia.nocookie.net/logopedia/images/e/e8/Animal_Planet_HD_2007.png/revision/latest/scale-to-width-down/200?cb=20091126085356'),
             ('Cartoon Network', 'https://www.arconaitv.me/cn/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/1/1c/Cartoon_Network_logo.svg/220px-Cartoon_Network_logo.svg.png'),
             ('Comedy Central', 'https://www.arconaitv.me/cc/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/c/c6/Comedy_Central_2011_Logo.svg/200px-Comedy_Central_2011_Logo.svg.png'),
             ('Discovery Channel', 'https://www.arconaitv.me/disco/', 'https://upload.wikimedia.org/wikipedia/de/thumb/4/46/Discovery_Channel_International.svg/250px-Discovery_Channel_International.svg.png'),
             ('ESPN', 'https://www.arconaitv.me/sports/', 'http://tvbtn.files.wordpress.com/2012/09/espn-logo-001.jpg?w=196&h=118'),
             ('Fox', 'https://www.arconaitv.me/foxxy/', 'http://mc.ustvnow.com/images/WPMT.png'),
             ('Fox News', 'https://www.arconaitv.me/fn/', 'https://upload.wikimedia.org/wikipedia/de/thumb/a/ae/Fox_News_Channel.svg/200px-Fox_News_Channel.svg.png'),
             ('FX', 'https://www.arconaitv.me/fx/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/e/e3/FX_2008_logo.svg/183px-FX_2008_logo.svg.png'),
             ('History Channel', 'https://www.arconaitv.me/hc/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/f/f5/History_Logo.svg/180px-History_Logo.svg.png'),
             ('Lifetime', 'https://www.arconaitv.me/lt/', 'http://vignette1.wikia.nocookie.net/logopedia/images/1/1e/Lifetime_2013.png/revision/latest/scale-to-width-down/200?cb=20150531221814&format=webp'),
             ('National Geographic', 'https://www.arconaitv.me/ng/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/6/6a/National-Geographic-Logo.svg/220px-National-Geographic-Logo.svg.png'),
             ('Nickelodeon', 'https://www.arconaitv.me/nickie/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Nickelodeon_logo_new.svg/200px-Nickelodeon_logo_new.svg.png'),
             ('SpikeTV', 'https://www.arconaitv.me/pointytv/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/c/ca/Spike_logo_2015.svg/220px-Spike_logo_2015.svg.png'),
             ('Syfy', 'https://www.arconaitv.me/sify/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/3/34/Syfy.svg/200px-Syfy.svg.png'),
             ('The CW', 'https://www.arconaitv.me/tcw/', 'http://mc.ustvnow.com/images/WLYH.png'),
             ('TBS', 'https://www.arconaitv.me/teabees/', 'http://vignette3.wikia.nocookie.net/logopedia/images/d/df/TBS_logo_2005.svg/revision/latest/scale-to-width-down/150?cb=20091116073610'),
             ('USA Network', 'https://www.arconaitv.me/usan/', 'https://upload.wikimedia.org/wikipedia/commons/thumb/0/0e/USA_Network_logo_%282006%29.svg/220px-USA_Network_logo_%282006%29.svg.png')]
        elif self.selected == '3':
            self.ch_list = [('Action Movies', 'https://www.arconaitv.me/action/', 'https://arconaitv.me/wp-content/uploads/2015/06/svs.png'), ('Random Movies', 'https://www.arconaitv.me/moovaye/', 'https://arconaitv.me/wp-content/uploads/2015/06/svs.png'), ('Horror Movies', 'https://www.arconaitv.me/horror/', 'https://arconaitv.me/wp-content/uploads/2015/06/svs.png')]
        for each in self.ch_list:
            title, url, img = each
            self.letter_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.letter_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()

    def get_hls(self, url):
        print url
        header = [('User-Agent', '')]
        page = getUrl(url, headers=header, jsonpost=False)
        self.play_that_shit(page)

    def ok(self):
        if self.index == '0':
            self.load_data_channels()
        elif self.index == '1':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            self.get_hls(uri)

    def play_that_shit(self, data):
        print data
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        hls_link = re.findall('src="(.*?)" type="application/x-mpegurl"/>', data)
        print hls_link
        if hls_link:
            sref = eServiceReference(4097, 0, hls_link[0])
            sref.setName(selectedName)
            self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'


def getUrl(url, cookieJar = None, post = None, timeout = 20, headers = None, returnResponse = False, noredirect = False, jsonpost = False):
    cookie_handler = urllib2.HTTPCookieProcessor(cookieJar)
    opener = urllib2.build_opener(cookie_handler, urllib2.HTTPBasicAuthHandler(), urllib2.HTTPHandler())
    req = urllib2.Request(url)
    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.154 Safari/537.36')
    if jsonpost:
        req.add_header('Content-Type', 'application/json')
    if headers:
        for h, hv in headers:
            req.add_header(h, hv)

    response = opener.open(req, post, timeout=timeout)
    if returnResponse:
        return response
    link = response.read()
    response.close()
    return link