# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/skysport_schedule.py
from imports import *
from Tools.Directories import fileExists, pathExists

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 26), font=4, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class sky_sports(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit}, -1)
        self['menulist'] = m2list([])
        self['title'] = Label('SkySports - Schedule')
        self['text'] = Label('')
        self['poster'] = Pixmap()
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label(' ')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.content_list = []
        self.onLayoutFinish.append(self.sky_sports_schedule)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        self[self.currentList].up()

    def down(self):
        self[self.currentList].down()

    def left(self):
        self[self.currentList].pageUp()

    def right(self):
        self[self.currentList].pageDown()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def exit(self):
        self.close()

    def sky_sports_schedule(self):
        self.schedule_list = []
        url = 'http://www1.skysports.com/watch/tv-guide'
        req = urllib2.Request(url)
        page = urllib2.urlopen(req)
        response = page.read()
        page.close()
         #('Sky Sports 1', 'http://www.liveonlinetv247.info/embed/skysports1.php'),
         #('Sky Sports 2', 'http://www.liveonlinetv247.info/embed/skysports2.php'),
         #('Sky Sports 3', 'http://www.liveonlinetv247.info/embed/skysports3.php'),
         #('Sky Sports 4', 'http://www.liveonlinetv247.info/embed/skysports4.php'),
         #('Sky Sports 5', 'http://www.liveonlinetv247.info/embed/skysports5.php'),
         #('Sky Sports News', 'http://www.liveonlinetv247.info/embed/skysportsnews.php'),
         #('Sky Sports F1', 'http://www.liveonlinetv247.info/embed/skysportsf1.php'),
        matches = re.findall('<a class="-a-block tvg-det callfn" href="/watch/prog/(.*?)/.*?" data-fn="overlay-widget" data-lite="true" data-lite="true">.*?<h4 class="-title -ellipsis">\n                                                (.*?)                                            </h4>\n.*?<p class="-time">\n(.*?)\n.*?</p>', response, re.DOTALL)
        for each in matches:
            channel, title, time = each
            print channel
            if channel == '1314':
                info = time.replace('                                                ', '') + ' : SkySports News ' + title.replace('                                                 ', ' ')
                uri = 'http://www.liveonlinetv247.info/embed/skysportsnews.php'
                self.schedule_list.append(cat_(info, uri))
            elif channel == '1301':
                info = time.replace('                                                ', '') + ' : SkySports 1 ' + title.replace('                                                 ', ' ')
                uri = 'http://www.liveonlinetv247.info/embed/skysports1.php'
                self.schedule_list.append(cat_(info, uri))
            elif channel == '1302':
                info = time.replace('                                                ', '') + ' : SkySports 2 ' + title.replace('                                                 ', ' ')
                uri = 'http://www.liveonlinetv247.info/embed/skysports2.php'
                self.schedule_list.append(cat_(info, uri))
            elif channel == '1333':
                info = time.replace('                                                ', '') + ' : SkySports 3 ' + title.replace('                                                 ', ' ')
                uri = 'http://www.liveonlinetv247.info/embed/skysports3.php'
                self.schedule_list.append(cat_(info, uri))
            elif channel == '1322':
                info = time.replace('                                                ', '') + ' : SkySports 4 ' + title.replace('                                                 ', ' ')
                uri = 'http://www.liveonlinetv247.info/embed/skysports4.php'
                self.schedule_list.append(cat_(info, uri))
            elif channel == '1303':
                info = time.replace('                                                ', '') + ' : SkySports 5 ' + title.replace('                                                 ', ' ')
                uri = 'http://www.liveonlinetv247.info/embed/skysports5.php'
                self.schedule_list.append(cat_(info, uri))
            elif channel == '1306':
                info = time.replace('                                                ', '') + ' : SkySports F1 ' + title.replace('                                                 ', ' ')
                uri = 'http://www.liveonlinetv247.info/embed/skysportsf1.php'
                self.schedule_list.append(cat_(info, uri))
            self.schedule_list.sort()

        self['menulist'].l.setList(self.schedule_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def play_that_shit(self, data):
        hls = re.findall('<source type="application/x-mpegurl" src="(.*?)"', data)
        if hls:
            print hls
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            sref = eServiceReference(4097, 0, hls[0])
            sref.setName(selectedName)
            self.session.open(MoviePlayer, sref)
        else:
            hls = re.findall('<a href="(http://live1.greenlie.org.*?)">', data)
            if hls:
                selectedName = self['menulist'].l.getCurrentSelection()[0][0]
                sref = eServiceReference(4097, 0, hls[0])
                sref.setName(selectedName)
                self.session.open(MoviePlayer, sref)

    def ok(self):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        uri = selectedEntry
        getPage(uri, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded',
        'UserAgent': 'Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.13 (KHTML, like Gecko) Chrome/24.0.1290.1 Safari/537.13'}).addCallback(self.play_that_shit)



def main(session, **kwargs):
    session.open(sky_sports)


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    return [PluginDescriptor(name='SkySports', description='SkySports Streamer', where=[PluginDescriptor.WHERE_PLUGINMENU], fnc=main, icon='plugin.png')]