# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/scandinavian.py
from setup import *
from about import *
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(name, link):
    res = [(name, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class scandinavian(Screen):

    def __init__(self, session):
        global old_ref
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('Scandianvian Ch')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_('About'))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.dir()
        self.index = 'nothing'
        old_ref = self.session.nav.getCurrentlyPlayingServiceReference()
        self.onLayoutFinish.append(self.get_channels)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self.cur_idx = int(self['menulist'].getSelectedIndex())
        comp = int(len(self.channels))
        print 'list : ' + str(comp)
        print self.cur_idx
        if self.cur_idx == 0:
            print 'moving to last idx'
            self['menulist'].moveToIndex(comp - 1)
        else:
            self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def down(self):
        self.cur_idx = int(self['menulist'].getSelectedIndex())
        comp = int(len(self.channels))
        if self.cur_idx == comp - 1:
            self['menulist'].moveToIndex(0)
        else:
            self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def get_first_page(self):
        url = 'http://livestream2.fynskemedier.dk/loadbalancer'
        getPage(url, headers={'X-Forwarded-For': '93.166.121.107',
         'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
         'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_channels)

    def get_channels(self):
        self.index = 'channels'
        #print data
        #print data
        self.channels = []
        self.channels.append(show_('DR 1', 'http://dr01-lh.akamaihd.net/i/dr01_0@147054/master.m3u8?b=300-2000hdcore=3%2E5%2E0', 'http://www.lyngsat-logo.com/logo/tv/dd/dr_1.png'))
        self.channels.append(show_('DR 2', 'http://dr02-lh.akamaihd.net/i/dr02_0@147055/master.m3u8?b=300-2000hdcore=3%2E5%2E0', 'http://www.lyngsat-logo.com/logo/tv/dd/dr_2.png'))
        self.channels.append(show_('DR 3', 'http://dr03-lh.akamaihd.net/i/dr03_0@147056/master.m3u8?b=300-2000hdcore=3%2E5%2E0', 'http://www.lyngsat-logo.com/logo/tv/dd/dr_3.png'))
        self.channels.append(show_('DR K', 'http://dr04-lh.akamaihd.net/i/dr04_0@147057/master.m3u8?b=300-2000hdcore=3%2E5%2E0', 'http://www.lyngsat-logo.com/logo/tv/dd/dr_k.png'))
        self.channels.append(show_('DR Ramasjang', 'http://dr05-lh.akamaihd.net/i/dr05_0@147058/master.m3u8?b=300-2000hdcore=3%2E5%2E0', 'http://www.lyngsat-logo.com/logo/tv/dd/dr_ramasjang.png'))
        self.channels.append(show_('DR Ultra', 'http://dr06-lh.akamaihd.net/i/dr06_0@147059/master.m3u8?b=300-2000hdcore=3%2E5%2E0', 'http://www.lyngsat-logo.com/logo/tv/dd/dr_ultra_dk.png'))
        self.channels.append(show_('TV 4 sverige', 'http://tv4live-i.akamaihd.net/hls/live/200284/akamaihls2/wifi1500_akamaihls2.m3u8', 'http://www.lyngsat-logo.com/logo/tv/tt/tv4.png'))
        self.channels.append(show_('TV 10 Sweden', 'rtmp://cdn-kanal10.crossnet.net/kanal10//mpegts.stream', 'http://www.lyngsat-logo.com/logo/tv/tt/tv_10_se.png'))
        self.channels.append(show_('TV2 OJ', 'rtmp://54.195.141.50:80/live/_definst_/tv2oj-plus_1000 swfUrl=http://www.tv2oj.dk/themes/tv2oj2015_theme/flowplayer/flowplayer.commercial.swf pageUrl=http://www.tv2oj.dk/livestream?stream=tv2oj-plus', 'http://www.lyngsat-logo.com/logo/tv/tt/tv2_ostjylland.png'))
        self.channels.append(show_('TV2 Bornholm', 'http://live.tv2bornholm.dk/stream/live/chunklist.m3u8', 'http://www.lyngsat-logo.com/logo/tv/tt/tv_bornholm_dk.png'))
        self.channels.append(show_('N4', 'http://playlist.oz.com/live/n4/2500/playlist.m3u8', 'http://www.n4.is/static/themes/2013/images/logo.png'))
        self.channels.append(show_('InnTV', 'rtmp://79.171.99.70:1935/webtv/innwebtv.stream', 'http://www.inntv.is/thumb/200/0/images/sent/50c74e20a820d.png&cut=0p%3A0p'))
        self.channels.append(show_('TV2 Lorry', 'http://cdn-lt-live.tv2lorry.dk/dc-1/m/ny-live-publish1/kLive/smil:0_j7s6gxkh_all.smil/chunklist_b2144000.m3u8', 'http://www.lyngsat-logo.com/logo/tv/tt/tv2_lorry_dk.png'))
        self.channels.append(show_('TV7', 'http://vod.tv7.fi:1935/tv7-fi/smil:tv7-fi.smil/chunklist_w381276298_b1596000_slfi.m3u8', 'http://www.tv7.fi/wp-content/themes/tv7-theme-fi/assets/img/logo.png'))
        self.channels.append(show_('LivestyleTV', 'rtmp://stream1.lifestyletv.se/live//livestream3', 'http://lifestyletv.se/wp-content/themes/lstv2014/images/LifeStyleTV_logo.png'))
        self.channels.append(show_('Kanal10TV', 'rtmp://cdn-kanal10.crossnet.net/kanal10/mpegts.stream', 'http://kanal10.se/App_Themes/Normal/Global/img/kanal10.png'))
        self.channels.append(show_('OmegaTV', 'http://sip-live.hds.adaptive.level3.net/hls-live/omega-omega/_definst_/live/stream3.m3u8', 'http://www.omega.is/Omega/Images/admin_logo1.png'))
        self['menulist'].l.setList(self.channels)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def ok(self):
        url = self['menulist'].l.getCurrentSelection()[0][1]
        print url
        if 'dr0' in url:
            url = 'http://127.0.0.1:88/hlsvariant://' + url + ' headers={"X-Forwarded-For":"93.166.121.107"}'
        elif 'tv4live' in url:
            url = url
        elif 'rtmp' in url:
            url = url
        self.play_channel(url)

    def play_channel(self, data):
        self.index = 'player'
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.nav.playService(sref)
        self.hide()

    def exit(self):
        if self.index == 'player':
            self.show()
            self.session.nav.playService(old_ref)
            self.get_channels()
        else:
            self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print 'Error: no data'

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ exists'