# -*- coding: utf-8 -*-
from setup import *
from imports import *
import requests,re

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class livesport(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('Livesport.pw')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.index = ''
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.show_channels)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        self[self.currentList].up()
        self.load_poster()

    def down(self):
        self[self.currentList].down()
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def show_channels(self):
        self.index='channels'
        self.s_l=[]
        sp_list=[('ViasatSportBaltic','http://livesport.pw/ViasatSportBaltic.html','http://'),
        ('ViasatFootball','http://livesport.pw/ViasatFootball.html','http://'),
        ('ViasatHockey','http://livesport.pw/ViasatHockey.html','http://'),
        ('Eurosport','http://livesport.pw//Eurosport.html','http://'),
        ('Eurosport2','http://livesport.pw//Eurosport2.html','http://'),
        ('KHLHD','http://livesport.pw/KHLHD.html','http://'),
        ('KHL','http://livesport.pw//KHL.html','http://'),
        ('Setanta','http://livesport.pw//Setanta.html','http://'),
        ('Setanta Plus','http://livesport.pw/SETPLUS.html','http://'),
        ('Kazsport','http://livesport.pw//Kazsport.html','http://'),
        ('BEL5','http://livesport.pw//BEL5.html','http://'),
        ('SkySports1','http://livesport.pw//SkySports1.html','http://'),
        ('SkySports2','http://livesport.pw//SkySports2.html','http://'),
        ('SkySports3','http://livesport.pw//SkySports3.html','http://'),
        ('SkySports4','http://livesport.pw/SkySports4.html','http://'),
        ('SkySports5','http://livesport.pw//SkySports5.html','http://'),
        ('BTSport1','http://livesport.pw/BTSport1.html','http://'),
        ('BTSport2','http://livesport.pw/BTSport2.html','http://'),
        ('BTSport3','http://livesport.pw/BTSport3.html','http://'),
        ('BTSport ESPN','http://livesport.pw/btsportespn.html','http://'),
        ('Sport1PT','http://livesport.pw//Sport1PT.html','http://'),
        ('Sport2PT','http://livesport.pw/Sport2PT.html','http://'),
        ('Sport3PT','http://livesport.pw/Sport3PT.html','http://'),
        ('Sport4PT','http://livesport.pw/Sport4PT.html','http://'),
        ('Sport5PT','http://livesport.pw/Sport5PT.html','http://'),
        ('SportKlub1','http://livesport.pw//SportKlub1.html','http://'),
        ('SportKlub2','http://livesport.pw//SportKlub2.html','http://'),
        ('SportKlub3','http://livesport.pw//SportKlub3.html','http://'),
        ('SportKlub4','http://livesport.pw/SportKlub4.html','http://'),
        ('SportKlub5','http://livesport.pw/SportKlub5.html','http://'),
        ('SportKlub6','http://livesport.pw/SportKlub6.html','http://'),
        ('arenaSport1','http://livesport.pw/arenaSport1.html','http://'),
        ('arenaSport2','http://livesport.pw/arenaSport2.html','http://'),
        ('arenaSport3','http://livesport.pw/arenaSport3.html','http://'),
        ('arenaSport4','http://livesport.pw/arenaSport4.html','http://'),
        ('arenaSport5','http://livesport.pw/arenaSport5.html','http://'),
        ('SuperSport 1','http://livesport.pw/ss1.html','http://'),
        ('SuperSport 2','http://livesport.pw/ss2.html','http://'),
        ('SuperSport 3','http://livesport.pw/ss3.html','http://'),
        ('SuperSport 4','http://livesport.pw/ss4.html','http://'),
        ('DigiSport1','http://livesport.pw/DigiSport1.html','http://'),
        ('DigiSport2','http://livesport.pw/DigiSport2.html','http://'),
        ('Sport1 DE','http://livesport.pw/sport1-de.html','http://'),
        ('NHLN','http://livesport.pw//NHLN.html','http://'),
        ('NBA','http://livesport.pw/NBA.html','http://'),
        ('TSN5','http://livesport.pw/TSN5.html','http://'),
        ('NTV SPOR','http://livesport.pw/ntvSPOR.html','http://'),
        ('aSPOR','http://livesport.pw/aSPOR.html','http://'),
        ('Supertennis','http://livesport.pw/supertennis.html','http://'),
        ('NBCSN','http://livesport.pw/NBCSN.html','http://'),
        ('MatchTV','http://livesport.pw//MatchTV.html','http://'),
        ('MatchArena','http://livesport.pw//MatchArena.html','http://'),
        ('MatchIgra','http://livesport.pw//MatchIgra.html','http://'),
        ('MatchNashSport','http://livesport.pw/MatchNashSport.html','http://'),
        ('MatchPlaneta','http://livesport.pw//MatchPlaneta.html','http://'),
        ('MatchFutbol1','http://livesport.pw//MatchFutbol1.html','http://'),
        ('MatchFutbol2','http://livesport.pw//MatchFutbol2.html','http://'),
        ('MatchFutbol3','http://livesport.pw//MatchFutbol3.html','http://'),
        ('NashFutbol','http://livesport.pw//NashFutbol.html','http://')]
        for (title,url,img) in sp_list:
            self.s_l.append(show_(title,url,img))
        self['menulist'].l.setList(self.s_l)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()

    def get_lnk(self,url):
        print url
        session = requests.Session()
        r = session.get(url)
        r1=r.text
        lnk=re.findall('var videoLink = \'(.*?)\';',r1)
        h = r.headers['set-cookie']
        if lnk:
            r1 = session.get(lnk[0])
            r2=r1.text
            headers = r.headers['set-cookie']
            print headers
            vars=re.findall('SportUserID=(.*?);.*?SportRndID=(.*?);',headers)
            lnk='http://127.0.0.1:88/hls://'+lnk[0]+' http-headers={"User-Agent":"Mozilla/5.0 (X11; Linux i686; rv:45.0) Gecko/20100101 Firefox/45.0","Cookie":"SportUserID='+vars[0][0]+'; SportRndID='+vars[0][1]+'"}'#,"Cookie":"'+headers+'"
            self.play_that_shit(lnk)
        else:
            self.stream_not_found()

    def ok(self):
        if self.index=='channels':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            self.get_lnk(uri)

    def play_that_shit(self, data):
        print data
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, str(data))
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        if self.index=='channels':
            self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(jpg_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[livesport] no cover.. error'
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later on'), MessageBox.TYPE_INFO, timeout=3)

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'

