# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/laola1tv.py
from setup import *
from imports import *
from enigma import eTimer
cj = {}

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img, info):
    res = [(name,
      link,
      img,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(name, link, url):
    res = [(name, link, url)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show3_(name, link, img, id):
    res = [(name,
      link,
      img,
      id)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class laola1tv(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('laola1.tv')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label(_(' '))
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.letter_list = []
        self.dir()
        self.onLayoutFinish.append(self.abc)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        info = self['menulist'].getCurrent()[0][3]
        self['name'].setText(auswahl)
        self['text'].setText(info)

    def down(self):
        self[self.currentList].down()
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        info = self['menulist'].getCurrent()[0][3]
        self['name'].setText(auswahl)
        self['text'].setText(info)

    def left(self):
        self[self.currentList].pageUp()
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def abc(self):
        self.currentList = 'menulist'
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        uri = 'http://www.laola1.tv/feed/app_video.feed.php?targetID=17&order=asc&partner=22&records=100&format=xml'
        getPage(uri, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30'}).addCallback(self.load_data_channels)

    def load_data_channels(self, data):
        self.index = 'load_data_channels'
        print data
        live = re.findall('<video id="(.*?)".*?scheduled_start="(.*?)" scheduled_end="(.*?)">.*?<titleDE>(.*?)</titleDE>.*?<liga>(.*?)</liga>.*?<image>(.*?)</image>', data, re.DOTALL)
        print live
        if live:
            for id, start, end, title, liga, img in live:
                title = str(start) + ' - ' + title
                title = title.replace('&#228;', '\xc3\xa4').replace('&#252;', '\xc3\xbc').replace('&#223;', '\xc3\x9f').replace('&#8242;', "'").replace('&#214;', '\xc3\x96').replace('&#246;', '\xc3\xb6').replace('&#237;', '\xc3\xad').replace('&#243;', '\xc3\xb3')
                liga = liga.replace('&#228;', '\xc3\xa4').replace('&#252;', '\xc3\xbc').replace('&#223;', '\xc3\x9f').replace('&#8242;', "'").replace('&#214;', '\xc3\x96').replace('&#246;', '\xc3\xb6').replace('&#237;', '\xc3\xad').replace('&#243;', '\xc3\xb3')
                url = 'http://www.laola1.tv/server/hd_video.php?play=' + id + '&partner=1&portal=de-int&v5ident=&lang=de&v=2&device=stv'
                if 'Deutsche Bundesliga' not in liga:
                    self.letter_list.append(show_(title, url, img, liga))

        print self.letter_list
        self['menulist'].l.setList(self.letter_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def get_time(self):
        self.index = 'load_data_channels'
        url = 'http://www.laola1.tv/feed/time/current.php'
        req = urllib2.Request(url)
        req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
        page = urllib2.urlopen(req)
        r = page.read()
        return str(r)

    def getxmlurl(self, data):
        self.index = 'load_data_channels'
        url = self['menulist'].l.getCurrentSelection()[0][1]
        id = re.findall('play=(.*?)&partner', url)[0]
        t = self.get_time()
        xmlurl = re.findall('<url>(http.*?)</url>', data)
        if xmlurl:
            import hashlib
            xfor = ''
            xmlurl = xmlurl[0].replace('amp;', '')
            k = 'E9QbEcFg'
            p = '1'
            s = '%s%s%s%s' % (id,
             p,
             t,
             k)
            m = hashlib.md5()
            m.update(s)
            auth = m.hexdigest()
            new_url = xmlurl + '&timestamp=%s&auth=%s&format=iphone' % (t, auth)
            req = urllib2.Request(new_url)
            req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
            sel = self['menulist'].l.getCurrentSelection()[0][3]
            if sel == 'Deutsche Bundesliga' and xfor is not '':
                req.add_header('X-Forwarded-For', xfor)
            elif sel == 'Men\xe2\x80\xb2s EHF EURO' and xfor is not '':
                req.add_header('X-Forwarded-For', xfor)
            page = urllib2.urlopen(req)
            r = page.read()
            link = re.findall('url="(.*?)"', r)
            token = re.findall('token auth="(.*?)"', r)
            if link and token:
                if link[0] == 'restricted':
                    self.stream_not_found()
                else:
                    live = 'http://127.0.0.1:88/hlsvariant://' + link[0] + '?hdnea=' + token[0]
                    self.play_that_shit(live)

    def ok(self):
        if self.index == 'load_data_channels':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            getPage(uri, timeout=8, method='GET', cookies=cj, headers={'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.getxmlurl)

    def play_that_shit(self, data):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        if self.index == 'load_data_channels':
            self.close()
        else:
            self.index = 'load_data_channels'
            self['menulist'].l.setList(self.letter_list)
            self['menulist'].l.setItemHeight(40)
            self.load_poster()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print 'loaded'

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(jpg_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not available in your country'), MessageBox.TYPE_INFO, timeout=3)

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'