# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/cinemalive.py
from imports import *
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show_all_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class cinemalive(Screen):

    def __init__(self, session):
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit,
         'blue': self.dnitnow}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label('')
        self['poster'] = Pixmap()
        self['title'] = Label('cinemalive')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.list_cat)

    def about(self):
        self.session.open(AboutScreen)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
                self.load_poster()
            except:
                self['text'].setText('')

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
                self.load_poster()
            except:
                self['text'].setText('')

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
                self.load_poster()
            except:
                self['text'].setText('')

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
                self.load_poster()
            except:
                self['text'].setText('')

    def list_cat(self):
        self.info = 'list_cat'
        self.cat_list = []
        self.load_list = [('Animation', 'http://cinemalive.tv/moviesenglish/animation'),
         ('Action', 'http://cinemalive.tv/moviesenglish/action'),
         ('Biography', 'http://cinemalive.tv/moviesenglish/biography'),
         ('Documentary', 'http://cinemalive.tv/moviesenglish/documentary'),
         ('Drama', 'http://cinemalive.tv/moviesenglish/drama'),
         ('Fantasy', 'http://cinemalive.tv/moviesenglish/fantasy'),
         ('Family', 'http://cinemalive.tv/moviesenglish/family'),
         ('Comedy', 'http://cinemalive.tv/moviesenglish/comedy'),
         ('Musical', 'http://cinemalive.tv/moviesenglish/musical'),
         ('Adventure', 'http://cinemalive.tv/moviesenglish/adventure'),
         ('Romance', 'http://cinemalive.tv/moviesenglish/romance'),
         ('Horror', 'http://cinemalive.tv/moviesenglish/horror'),
         ('History', 'http://cinemalive.tv/moviesenglish/history'),
         ('Thriller', 'http://cinemalive.tv/moviesenglish/thriller'),
         ('Sci-Fi', 'http://cinemalive.tv/moviesenglish/scifi'),
         ('Sport', 'http://cinemalive.tv/moviesenglish/sport'),
         ('War', 'http://cinemalive.tv/moviesenglish/war'),
         ('Western', 'http://cinemalive.tv/moviesenglish/western')]
        for each in self.load_list:
            title, url = each
            self.cat_list.append(show_(title, url, None))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        return

    def list_shows(self, data):
        self.info = 'list_shows'
        self.show_list = []
        movies = re.findall('<a href="(.*?)">\n.*?<div class="view view-tenth">\n.*?<img class="img-thumbnail" src="(.*?)" alt=".*?" />\n.*?<div class="mask">\n.*?<h2>(.*?)</h2>\n.*?<p>(.*?)</p>', data, re.DOTALL)
        for each in movies:
            url, img, title, info = each
            if url is not '/':
                img = 'http://eng.cinemalive.tv' + img
                print url
                self.show_list.append(show_all_(title, url, img, info))

        self['menulist'].l.setList(self.show_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        auswahl = self['menulist'].getCurrent()[0][3]
        self['text'].setText(auswahl)

    def get_play_link(self, url):
        getPage(url, timeout=8, method='GET', headers={'Host': 'cinemalive.tv',
         'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
         'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.read_link, url)

    def read_link(self, data, url):
        print data
        shit = re.findall("id:'src_en',filename:'(.*?)',player_type:'html5',hostel:'https://cn3.cloudsuzy.com/", data)
        print shit[0]
        import random
        final = 'https://cn3.cloudsuzy.com/' + shit[0] + '.mp4?r=' + str(long(167114101234L) * 2 * 55 + int(0 + random.random() * 5))
        print final
        self.play_movie(final)

    def play_movie(self, link):
        print link
        sref = eServiceReference(4097, 0, link)
        self.session.open(MoviePlayer, sref)

    def ok(self):
        if self.info == 'list_cat':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            getPage(url, timeout=8, method='GET', headers={'Host': 'cinemalive.tv',
             'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_shows)
        elif self.info == 'list_shows':
            selectedEntry = self['menulist'].getCurrent()[0][1]
            selectedName = self['menulist'].getCurrent()[0][0]
            url = selectedEntry
            self.filmname = str(selectedName)
            self.get_play_link(url)

    def exit(self):
        print self.info
        if re.match('(list_cat)', self.info, re.S | re.I):
            if fileExists('/tmp/shahidSeries_poster.jpg'):
                os.system('rm -r /tmp/shahidSeries_poster.jpg')
            self.close(self.session, 'exit')
        elif self.info == 'list_shows':
            self.info = 'list_cat'
            self['blue'].hide()
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/shahidSeries_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/shahidSeries/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[shahidSeries] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[shahidSeries] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/shahidSeries/'):
            os.system('mkdir /tmp/shahidSeries/')
        else:
            print '[shahidSeries] /tmp/shahidSeries/ allready present'