# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/ArabicEntertainment/arabichannels.py
from Components.ActionMap import *
from Components.Label import Label
from Components.ScrollLabel import ScrollLabel
from Components.MenuList import MenuList
from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmap, MultiContentEntryPixmapAlphaTest
from Components.config import config
from Components.GUIComponent import GUIComponent
from enigma import ePicLoad
from Tools.LoadPixmap import LoadPixmap
from Components.Pixmap import Pixmap
from Components.AVSwitch import AVSwitch
from Screens.InfoBar import MoviePlayer
from Components.PluginComponent import plugins
from Components.Button import Button
from Screens.Screen import Screen
from Plugins.Plugin import PluginDescriptor
from twisted.web.client import getPage
from twisted.web.client import downloadPage
from Components.ServicePosition import ServicePositionGauge
from Tools.NumericalTextInput import NumericalTextInput
from Components.ConfigList import *
from Components.config import *
from Components.ConfigList import ConfigList, ConfigListScreen
from Components.config import config, ConfigSubsection, ConfigText, getConfigListEntry, ConfigSelection
from Screens.HelpMenu import HelpableScreen
from Screens.InputBox import InputBox
from Screens.ChoiceBox import ChoiceBox
from Screens.Screen import Screen
from Screens.MessageBox import MessageBox
from enigma import eListboxPythonMultiContent, eListbox, gFont, RT_HALIGN_LEFT, RT_HALIGN_RIGHT, RT_HALIGN_CENTER, loadPNG, RT_WRAP, eServiceReference, getDesktop, loadJPG, eTPM
from Tools.Directories import pathExists, fileExists, SCOPE_SKIN_IMAGE, resolveFilename
import sys, os, base64, re, time
from datetime import datetime
from twisted.web import client, error as weberror
from twisted.internet import reactor
from twisted.internet import defer
from urllib import quote, urlencode
from urllib2 import Request, build_opener, HTTPCookieProcessor, HTTPHandler
from time import strptime, mktime
import cookielib, urllib2, urllib, shutil
from random import randint
import xml.dom.minidom
from shahid import *
if fileExists('/usr/lib/enigma2/python/Plugins/Extensions/JobManager/plugin.pyo'):
    from Plugins.Extensions.JobManager.plugin import *
    JobManagerInstalled = True
else:
    JobManagerInstalled = False
UserAgent = 'Mozilla/5.0 (X11; U; Linux x86_64; de; rv:1.9.0.15) Gecko/2009102815 Ubuntu/9.04 (jaunty) Firefox/3.'
cj = {}

class myTVlist(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 17))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 20))


class arabichannels(Screen, ConfigListScreen):
    skin = '\n\t\t\t<screen position="35,55" size="1210,640" title=" ">\n\t\t\t<widget name="info" position="25,10" size="450,24" zPosition="0" font="Regular;22" transparent="1" foregroundColor="white" />\n\t\t\t<widget name="logo2" position="0,0" size="1200,630" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ArabicEntertainment/images/logo2.png" zPosition="0" alphatest="on" />\t\n\t\t\t\t<widget source="session.VideoPicture" render="Pig"  position="750,120" size="340,228" zPosition="3" backgroundColor="transparent"/>\t\t\n\t\t\t<widget name="poster" position="10,100" size="185,263" zPosition="4" alphatest="on" />\n\t\t\t<widget name="myTVmenulist" position="200,120" size="500,450" transparent="1" scrollbarMode="showOnDemand" />\n\t\t\t<widget name="ButtonRed" position="28,596" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ArabicEntertainment/images/red.png" zPosition="10" size="150,30" transparent="1" alphatest="on" />\n\t\t\t<widget name="TextRed" position="28,600" size="140,24" valign="center" halign="center" zPosition="11" font="Regular;18" transparent="1" />\n\t\t\t<widget name="ButtonGreen" position="196,596" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ArabicEntertainment/images/green.png" zPosition="10" size="150,30" transparent="1" alphatest="on" />\n\t\t\t<widget name="TextGreen" position="196,600" size="140,24" valign="center" halign="center" zPosition="11" font="Regular;18" transparent="1" />\t\t\t\n\t\t\t<widget name="ButtonBlue" position="532,596" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ArabicEntertainment/images/blue.png" zPosition="10" size="150,30" transparent="1" alphatest="on" />\n\t\t\t<widget name="TextBlue" position="532,600" size="140,24" valign="center" halign="center" zPosition="11" font="Regular;18" transparent="1" />\n\t\t\t<widget name="ButtonYellow" position="364,596" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ArabicEntertainment/images/yellow.png" zPosition="10" size="150,30" transparent="1" alphatest="on" />\n\t\t\t<widget name="TextYellow" position="364,600" size="140,24" valign="center" halign="center" zPosition="11" font="Regular;18" transparent="1" />\n\t\t\t<widget name="plugin_logo" position="750,330" size="390,260" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/ArabicEntertainment/images/logo_arabic.png" zPosition="1" alphatest="on" />\n\t\t</screen>'

    def __init__(self, session):
        Screen.__init__(self, session)
        self.skin = arabichannels.skin
        self.session = session
        self['info'] = Label('')
        self['poster'] = Pixmap()
        self['logo2'] = Pixmap()
        self['plugin_logo'] = Pixmap()
        self['ButtonRed'] = Pixmap()
        self['TextRed'] = Label('Exit')
        self['ButtonGreen'] = Pixmap()
        self['TextGreen'] = Label('')
        self['ButtonYellow'] = Pixmap()
        self['TextYellow'] = Label('About')
        self['ButtonBlue'] = Pixmap()
        self['TextBlue'] = Label('Download')
        self['TextBlue'].hide()
        self['myTVmenulist'] = myTVlist([])
        self.ok_info = 'mbc1'
        self.wsection = 'mbc1'
        self.dnfile = False
        self.onLayoutFinish.append(self.channels)
        self['shortcuts'] = NumberActionMap(['ShortcutActions',
         'WizardActions',
         'NumberActions',
         'InputActions',
         'InputAsciiActions',
         'KeyboardInputActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right}, -1)
        self['OkCancelActions'] = HelpableActionMap(self, 'OkCancelActions', {'cancel': self.exit,
         'ok': self.ok}, -1)
        self['ColorActions'] = HelpableActionMap(self, 'ColorActions', {'red': self.exit1,
         'green': self.exit1,
         'yellow': self.about,
         'blue': self.dnitnow}, -1)
        self['InfobarActions'] = HelpableActionMap(self, 'InfobarActions', {'showMovies': self.jobix}, -1)
        self['EPGSelectActions'] = HelpableActionMap(self, 'EPGSelectActions', {'nextBouquet': self.b_up,
         'prevBouquet': self.b_down}, -1)

    def about(self):
        self.session.open(ShahidAboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def up(self):
        self['myTVmenulist'].up()

    def down(self):
        self['myTVmenulist'].down()

    def left(self):
        self['myTVmenulist'].pageUp()

    def right(self):
        self['myTVmenulist'].pageDown()

    def b_up(self):
        if self.ok_info == 'streams':
            self['handlung'].pageUp()

    def b_down(self):
        if self.ok_info == 'streams':
            self['handlung'].pageDown()

    def getCookies(self, url):
        cj = cookielib.CookieJar()
        opener = build_opener(HTTPCookieProcessor(cj), HTTPHandler())
        req = Request(url)
        req.add_header('Host', 'www.hdarabic.com/')
        req.add_header('Cache-Control', 'max-age=0')
        req.add_header('Accept', ' text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8')
        req.add_header('User-Agent', ' Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.69 Safari/537.36')
        req.add_header('Accept-Encoding', 'gzip,deflate,sdch')
        req.add_header('Referer', 'http://www.hdarabic.com/')
        req.add_header('Accept-Language', 'sv,en-US;q=0.8,en;q=0.6,en-GB;q=0.4')
        f = opener.open(req)
        print cj
        cj = str(cj).split('tzLogins=')[1]
        cj = str(cj).split(' ')[0].strip()
        return cj

    def channels(self):
        self.ok_info = 'channels'
        self.wsection = 'channels'
        self.channelliste = []
        self['TextBlue'].hide()
        url = 'http://www.hdarabic.com/index.php'
        getPage(url, timeout=5, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.channels_data).addErrback(self.errorload_timeout)

    def channels_data(self, data):
        self.ok_info = 'channels'
        channels = re.findall('<div class="(.+?)"><a href="#" onclick="document.getElementById(.+?)><span class="nume"(.+?)</span><img src="(.+?)"/></a></div>', data, re.S)
        for items in channels:
            path = str(items[1]).split("src='")
            path = path[1]
            path = 'http://www.hdarabic.com/' + str(path).replace(';"', '').replace("'", '').strip()
            name = str(items[2]).replace('>', '').strip()
            image = str(items[3]).strip()
            image = str(image).replace('./', '')
            image = 'http://www.arabichannels.com/' + image
            if 'iptv.php' not in str(path):
                self.channelliste.append(self.show_mbc1(self.umlaute(name), path, None))
            self['myTVmenulist'].l.setList(self.channelliste)
            self['myTVmenulist'].l.setItemHeight(30)
            self['myTVmenulist'].moveToIndex(0)
            self.countmovies = len(self.channelliste)

        return

    def mbc1(self):
        self.ok_info = 'mbc1'
        self.wsection = 'mbc1'
        self.filmeliste = []
        self['TextBlue'].hide()
        url = self['myTVmenulist'].getCurrent()[0][1]
        getPage(url, timeout=5, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.mbc1_data).addErrback(self.errorload_timeout)

    def mbc1_data(self, data):
        mbc1 = re.findall("<item><title>(.*?)</title><link>rss://(.*?)</link><media:thumbnail url='(.*?)' />", data, re.S)
        if mbc1:
            for each in mbc1:
                title, url, jpg_link = each
                url = 'http://' + url
                self.filmeliste.append(self.show_mbc1(self.umlaute(title), url, jpg_link))

            self['myTVmenulist'].l.setList(self.filmeliste)
            self['myTVmenulist'].l.setItemHeight(30)
            self['myTVmenulist'].moveToIndex(0)
            self.countmovies = len(self.filmeliste)
            self['info'].setText('Section: %s - found: %s movies.' % (self.wsection, self.countmovies))
        else:
            self['info'].setText('Section: %s....Error - shahid.mbc.net down ?' % self.wsection)

    def show_mbc1(self, title, url, jpg_link):
        res = [(title, url, jpg_link)]
        res.append(MultiContentEntryText(pos=(0, 0), size=(550, 25), font=4, text=title, flags=RT_HALIGN_CENTER, color=16777215, color_sel=16451625))
        return res

    def load_poster_mbc1(self):
        jp_link = self['myTVmenulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/shahidmbc_poster.jpg'
        downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image).addErrback(self.errorload)

    def show_video(self, title, url, jpg_link, imdb, quali, handlung):
        res = [(title,
          url,
          jpg_link,
          imdb,
          quali,
          handlung)]
        res.append(MultiContentEntryText(pos=(0, 0), size=(550, 25), font=4, text=title, flags=RT_HALIGN_CENTER, color=16777215, color_sel=16451625))
        return res

    def show_handlung(self):
        count_index = self['myTVmenulist'].getCurrent()
        if not count_index == None:
            handlung = self['myTVmenulist'].getCurrent()[0][3]
            self['handlung'].setText(self.umlaute(handlung))
        return

    def downloadPic(self, data, jpg_store):
        self.poster_resize(jpg_store)

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
        return

    def errorload_timeout(self, error):
        self['info'].setText('mbc.net is unreachable. try again later!')

    def errorload(self, error):
        print '[mbc.net]:', error

    def ok(self):
        print self.ok_info
        if re.match('(channels)', self.ok_info, re.S | re.I):
            count_index = self['myTVmenulist'].getCurrent()
            self.lastpoint = self['myTVmenulist'].getSelectedIndex()
            self.filmname = self['myTVmenulist'].getCurrent()[0][0]
            url = self['myTVmenulist'].getCurrent()[0][1]
            self.playChannel(url)
        elif self.ok_info == 'streams':
            count_index = self['myTVmenulist'].getCurrent()
            self.lastpoint = self['myTVmenulist'].getSelectedIndex()
            self.filmname = self['myTVmenulist'].getCurrent()[0][0]
            url = self['myTVmenulist'].getCurrent()[0][1]
            print 'oki - streams ' + url
            getPage(url, timeout=5, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_streamlink).addErrback(self.errorload_timeout)

    def streamer_data(self, data):
        url = self['myTVmenulist'].getCurrent()[0][1]
        self.ok_info = 'streams'
        self['info'].setText('Loading..')
        self.stream_list = []
        hoster_data = re.findall('<item><title>(.*?)</title><link>(.*?)</link>', data, re.S)
        if hoster_data:
            for hoster in hoster_data:
                title, playlink = hoster
                self.stream_list.append(self.show_streams(title, playlink))

            if len(self.stream_list) > 0:
                self['myTVmenulist'].l.setList(self.stream_list)
                self['myTVmenulist'].l.setItemHeight(30)
                self['myTVmenulist'].moveToIndex(0)
                self['info'].setText('Show streams %s:' % self.filmname)
                self.ok_info = 'streams'
                if JobManagerInstalled:
                    self['TextBlue'].show()
            else:
                self['myTVmenulist'].l.setList(self.stream_list)
                self['myTVmenulist'].l.setItemHeight(30)
                self['info'].setText('Error - no streams found.')
        else:
            self['myTVmenulist'].l.setList(self.stream_list)
            self['myTVmenulist'].l.setItemHeight(30)
            self['info'].setText('Error - webpage changed.')

    def show_streams(self, hostername, url):
        res = [(hostername, url)]
        res.append(MultiContentEntryText(pos=(0, 0), size=(150, 25), font=4, text=hostername, flags=RT_HALIGN_CENTER, color=16777215, color_sel=16451625))
        return res

    def get_streamlink(self, data):
        print data
        link = re.findall('<title>.*?</title><link>rtmpe://(.*?)</link></item>', data, re.S)
        if link:
            link = 'rtmpe://' + str(link[0]).replace('"', '')
            self.play_movie(link)

    def got_link(self, stream_url):
        if stream_url == None:
            message = self.session.open(MessageBox, _('Stream not found, try again later.'), MessageBox.TYPE_INFO, timeout=3)
        else:
            self.play_movie(stream_url)
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later.'), MessageBox.TYPE_INFO, timeout=3)

    def dnitnow(self):
        if JobManagerInstalled and self.ok_info == 'streams':
            self.dnfile = True
            count_index = self['myTVmenulist'].getCurrent()
            if not count_index == None:
                url = self['myTVmenulist'].getCurrent()[0][1]
                if url:
                    getPage(url, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_streamlink).addErrback(self.errorload)
        elif JobManagerInstalled and self.ok_info == 'hd':
            self.dnfile = True
            count_index = self['myTVmenulist'].getCurrent()
            if not count_index == None:
                self.filmname = self['myTVmenulist'].getCurrent()[0][0]
                url = self['myTVmenulist'].getCurrent()[0][1]
                getPage(url, timeout=15, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.streamer_data2).addErrback(self.errorload_timeout)
        return

    def playChannel(self, url):
        print url
        if '.php' in str(url):
            req = urllib2.Request(url)
            req.add_header('Host', 'www.hdarabic.com/')
            req.add_header('Cache-Control', 'max-age=0')
            req.add_header('Accept', ' text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8')
            req.add_header('User-Agent', ' Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.69 Safari/537.36')
            req.add_header('Accept-Encoding', 'gzip,deflate,sdch')
            req.add_header('Referer', 'http://www.hdarabic.com/')
            req.add_header('Accept-Language', 'sv,en-US;q=0.8,en;q=0.6,en-GB;q=0.4')
            req.add_header('Cookie', '  tzLogin=' + str(self.getCookies('http://www.hdarabic.com/')))
            response = urllib2.urlopen(req)
            link = response.read()
            streamer = re.compile("'streamer':(.+?)',").findall(link)
            swf = re.compile("{type: 'flash', src: '(.+?)'},").findall(link)
            swf = str(swf).replace("['", '').replace("']", '').strip()
            streamer = str(streamer).replace('[', '').replace('"]', '').strip()
            streamer = str(streamer).replace("'", '').replace('"', '').strip().replace(']/', '').strip()
            fileLoc = re.compile("'file':(.+?)',").findall(link)
            if fileLoc:
                fileLoc = str(fileLoc[0]).replace("'", '').strip()
                fileLoc = str(fileLoc).replace("'", '').replace('"', '').strip()
                mynr1 = randint(10, 20)
                mynr2 = randint(0, 10)
                mynr3 = randint(100, 900)
                mynr = randint(10000, 500000)
                response = urllib2.urlopen(req)
                link = response.read()
                if 'arabichannels.com' in streamer:
                    complete = streamer + '/' + fileLoc + ' swfUrl=http://www.arabichannels.com' + swf + ' playpath=' + fileLoc + ' flashVer=' + str(mynr1) + '.' + str(mynr2) + '.' + str(mynr3) + ' live=1 swfVfy=true pageUrl=' + str(url)
                    print complete
                    self.play_movie(complete)
                else:
                    complete = streamer + fileLoc
                    self.play_movie(complete)
            else:
                message = self.session.open(MessageBox, _('Sorry - this is premium stream'), MessageBox.TYPE_INFO, timeout=5)
        elif '.html' in str(url):
            myfinalpath = ' '
            req = urllib2.Request(url)
            req.add_header('Host', 'www.hdarabic.com/')
            req.add_header('Cache-Control', 'max-age=0')
            req.add_header('Accept', ' text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8')
            req.add_header('User-Agent', ' Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.69 Safari/537.36')
            req.add_header('Accept-Encoding', 'gzip,deflate,sdch')
            req.add_header('Referer', 'http://www.hdarabic.com/')
            req.add_header('Accept-Language', 'sv,en-US;q=0.8,en;q=0.6,en-GB;q=0.4')
            req.add_header('Cookie', '  tzLogin=' + str(getCookies('http://www.hdarabic.com/')))
            response = urllib2.urlopen(req)
            link = response.read()
            mypath = re.compile("file: '(.+?)',").findall(link)
            for item in mypath:
                if 'smil' in str(item):
                    mydest = 'http://www.hdarabic.com/' + str(item).strip()
                    req2 = urllib2.Request(mydest)
                    req2.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3')
                    response2 = urllib2.urlopen(req2)
                    link2 = response2.read()
                    videosource = re.compile('<video src="(.+?)" system-bitrate="400000"').findall(link2)
                    myfinalpath = re.compile(' <meta base="(.+?)"/>').findall(link2)
                    myfinalpath = str(myfinalpath).replace("['", '').replace("']", '').strip()
                    videosource = str(videosource).replace("['", '').replace("']", '').replace("'", '').strip()
                    myfinalpath = myfinalpath + ' playpath=' + videosource + ' swfUrl=http://www.arabichannels.com/player4/jwplayer.flash.swf live=1 buffer=300000 timeout=15 swfVfy=1 pageUrl=http://www.arabichannels.com'
                    print myfinalpath

    def play_movie(self, link):
        if not self.dnfile:
            sref = eServiceReference(4097, 0, link)
            sref.setName(self.filmname)
            self.session.open(MoviePlayer, sref)
        else:
            self.dnfile = False
            self.currentDownload = ''
            self.currentDownload = jm.addJobToList(link, self.filmname)
            jm.startDownload(self.currentDownload)
            message = self.session.open(MessageBox, _('Download has been started. Please check progress in JobManager with PVR Button.'), MessageBox.TYPE_INFO, timeout=5)

    def umlaute(self, text):
        text = text.replace('&auml;', 'ae').replace('&Auml;', 'Ae').replace('&ouml;', 'oe').replace('&ouml;', 'Oe').replace('&uuml;', 'ue')
        text = text.replace('&Uuml;', 'Ue').replace('&szlig;', 'ss').replace('&amp;', '&').replace('&quot;', '"').replace('&gt;', "'")
        text = text.replace('&#8230;', '...').replace('&#8211;', '-')
        return text

    def exit(self):
        print self.ok_info
        if re.match('(films|search)', self.ok_info, re.S | re.I):
            if fileExists('/tmp/shahidmbc_poster.jpg'):
                os.system('rm -r /tmp/shahidmbc_poster.jpg')
            del self.picload
            self.close(self.session, 'exit')
        elif self.ok_info == 'streams':
            self.ok_info = self.wsection
            self['TextBlue'].hide()
            self['handlung'].show()
            self['info'].setText('Section: %s - found: %s films.' % (self.wsection, self.countmovies))
            self['myTVmenulist'].l.setList(self.filmeliste)
            self['myTVmenulist'].l.setItemHeight(30)
            self['myTVmenulist'].moveToIndex(int(self.lastpoint))
        elif self.ok_info == 'channels':
            self.ok_info = self.wsection
            self.close(self.session, 'exit')
        elif self.ok_info == 'mbc1':
            self.ok_info = 'channels'
            self['TextBlue'].hide()
            self['handlung'].show()
            self['info'].setText('Section: %s - found: %s films.' % (self.wsection, self.countmovies))
            self['myTVmenulist'].l.setList(self.channelliste)
            self['myTVmenulist'].l.setItemHeight(30)
            self['myTVmenulist'].moveToIndex(int(self.lastpoint))

    def exit1(self):
        if fileExists('/tmp/shahidmbc_poster.jpg'):
            os.system('rm -r /tmp/shahidmbc_poster.jpg')
        self.close(self.session, 'exit')


def main(session, **kwargs):
    session.openWithCallback(closen, arabichannels, plugin_path)


def closen(session, result):
    if result == 'restart':
        session.openWithCallback(closen, arabichannels, plugin_path)
    elif result == 'exit':
        pass


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    return [PluginDescriptor(name='arabichannels', description='Stream your favourite arabic movies', where=[PluginDescriptor.WHERE_EXTENSIONSMENU], fnc=main), PluginDescriptor(name='arabichannels', description='Stream your favourite arabic movies', where=[PluginDescriptor.WHERE_PLUGINMENU], fnc=main, icon='plugin.png')]