# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/alarab.py
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show1_(name, link, image, id):
    res = [(name,
      link,
      image,
      id)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class alarab(Screen):

    def __init__(self, session):
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit,
         'blue': self.dnitnow}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self['title'] = Label('Alarab')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.show_cat)

    def about(self):
        self.session.open(AboutScreen)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.index == '1':
            self.load_poster()

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.index == '1':
            self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.index == '1':
            self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.index == '1':
            self.load_poster()

    def show_cat(self):
        self.index = '0'
        self.cat_list = []
        self.cat_list.append(show1_('AFLAM ARAB', 'http://tv1.alarab.net/view-1_%D8%A7%D9%81%D9%84%D8%A7%D9%85-%D8%B9%D8%B1%D8%A8%D9%8A%D8%A9_1', 'http://wadeni.com/images/icons/0alarab-net.jpg', '1'))
        self.cat_list.append(show1_('SERIE ARAB', 'http://tv1.alarab.net/view-1_%D9%85%D8%B3%D9%84%D8%B3%D9%84%D8%A7%D8%AA-%D8%B9%D8%B1%D8%A8%D9%8A%D8%A9_8', 'http://wadeni.com/images/icons/0alarab-net.jpg', '2'))
        self.cat_list.append(show1_('SERIE AJNABI', 'http://tv1.alarab.net/view-1_%D9%85%D8%B3%D9%84%D8%B3%D9%84%D8%A7%D8%AA-%D8%A7%D8%AC%D9%86%D8%A8%D9%8A%D8%A9_1951', 'http://wadeni.com/images/icons/0alarab-net.jpg', '2'))
        self.cat_list.append(show1_('SERIE TURKI', 'http://tv1.alarab.net/view-1_%D9%85%D8%B3%D9%84%D8%B3%D9%84%D8%A7%D8%AA-%D8%AA%D8%B1%D9%83%D9%8A%D8%A9_299', 'http://wadeni.com/images/icons/0alarab-net.jpg', '2'))
        self.cat_list.append(show1_('AFLAM AJNABI', 'http://tv1.alarab.net/view-5553/%D8%A7%D9%81%D9%84%D8%A7%D9%85-%D8%A7%D8%AC%D9%86%D8%A8%D9%8A%D8%A9', 'http://wadeni.com/images/icons/0alarab-net.jpg', '1'))
        self.cat_list.append(show1_('THEATER', 'http://tv1.alarab.net/view-313/%D9%85%D8%B3%D8%B1%D8%AD%D9%8A%D8%A7%D8%AA', 'http://wadeni.com/images/icons/0alarab-net.jpg', '1'))
        self.cat_list.append(show1_('TV PROGRAM', 'http://tv1.alarab.net/view-311/%D8%A8%D8%B1%D8%A7%D9%85%D8%AC-%D8%AA%D9%84%D9%81%D8%B2%D9%8A%D9%88%D9%86', 'http://wadeni.com/images/icons/0alarab-net.jpg', '2'))
        self.cat_list.append(show1_('TV CHANNEL', 'http://tv1.alarab.net/view-5807/%D8%AA%D9%84%D9%81%D8%B2%D9%8A%D9%88%D9%86-%D8%A7%D9%84%D8%B9%D8%B1%D8%A8', 'http://wadeni.com/images/icons/0alarab-net.jpg', '2'))
        self.cat_list.append(show1_('VIDEO CLIP', 'http://tv1.alarab.net/view-10/%D9%81%D9%8A%D8%AF%D9%8A%D9%88-%D9%83%D9%84%D9%8A%D8%A8', 'http://wadeni.com/images/icons/0alarab-net.jpg', '1'))
        self.cat_list.append(show1_('CARTOON', 'http://tv1.alarab.net/view-4/%D9%85%D8%B3%D9%84%D8%B3%D9%84%D8%A7%D8%AA-%D9%83%D8%B1%D8%AA%D9%88%D9%86', 'http://wadeni.com/images/icons/0alarab-net.jpg', '2'))
        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def abc(self):
        self.loading_ok = False
        self.check = 'abc'
        self.currentList = 'menulist'
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.genre_name = 'Al Cinema'
        url = 'http://tv1.alarab.net/'
        getPage(url, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded',
         'UserAgent': 'Mozilla/5.0 (Linux; U; Android 2.3; en-us; DROID RAZR 4G Build/6.5.1-73_DHD-11_M1-29) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1'}).addCallback(self.load_data_channels)

    def load_data_channels(self, data):
        self.index = '1'
        self.content_list = []
        print data
        shows = re.findall('<div class="video-box">\n<a href="(.*?)">\n<img src="(.*?)" alt="(.*?)" />', data, re.DOTALL)
        if shows:
            for each in shows:
                url, img, title = each
                url = 'http://tv1.alarab.net' + url
                self.content_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.content_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()

    def get_episodes(self, data):
        print data
        self.index = '2'
        self.episodes_list = []
        episodes = re.findall('<div class="video-box">\n<a href="/v(.*?)-_.*?">\n<img src="(.*?)" alt="(.*?)" />', data, re.DOTALL)
        print episodes
        if episodes:
            for each in episodes:
                videoid, img, title = each
                url = 'http://alarabplayers.alarab.net/?vid=' + videoid + '&height=457&autoplay=true&title=%D8%AD%D8%B1%D8%A7%D9%85%20%D8%A7%D9%84%D8%AC%D8%B3%D8%AF&noad=1&autoplay=false'
                print url, title
                self.episodes_list.append(show_(title, url, img))

            self['menulist'].l.setList(self.episodes_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
            self.load_poster()
        else:
            link = re.findall('<iframe style="background.*?src="(http://alarabplayers.alarab.com/.*?autoplay=true).*?itemprop="video"', data, re.DOTALL)
            print link
            getPage(link[0], method='GET', headers={'Referer': 'http://tv1.alarab.net',
             'Content-Type': 'application/x-www-form-urlencoded',
             'User-Agent': 'iphone'}).addCallback(self.get_link)

    def get_link(self, data):
        self.index = '3'
        print data#http://flv2.alarab.com:8080/new/flv/108355.flv
        base_url = 'http://flv.alarab.net:8080/iphone/'
        file = re.findall("file:.*?(http://flv.*?)['\"],", data)
        #link = base_url + file[0] + '.mp4'
        print file
        if file:
            self.play_that_shit(file[0])

    def ok(self):
        print self.index
        if self.index == '0':
            url = self['menulist'].l.getCurrentSelection()[0][1]
            title = self['menulist'].l.getCurrentSelection()[0][0]
            print 'Mainmenu url= ' + url
            getPage(url, method='GET', headers={'Referer': 'http://tv1.alarab.net',
             'Content-Type': 'application/x-www-form-urlencoded',
             'UserAgent': 'Mozilla/5.0 (Linux; U; Android 2.3; en-us; DROID RAZR 4G Build/6.5.1-73_DHD-11_M1-29) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1'}).addCallback(self.load_data_channels)
        elif self.index == '1':
            url = self['menulist'].l.getCurrentSelection()[0][1]
            title = self['menulist'].l.getCurrentSelection()[0][0]
            print 'Url parsed to get_episodes = ' + url
            getPage(url, method='GET', headers={'Referer': 'http://tv1.alarab.net',
             'Content-Type': 'application/x-www-form-urlencoded',
             'UserAgent': 'Mozilla/5.0 (Linux; U; Android 2.3; en-us; DROID RAZR 4G Build/6.5.1-73_DHD-11_M1-29) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1'}).addCallback(self.get_episodes)
        elif self.index == '2':
            url = self['menulist'].l.getCurrentSelection()[0][1]
            title = self['menulist'].l.getCurrentSelection()[0][0]
            print 'Url parsed to get_link = ' + url
            getPage(url, method='GET', headers={'Referer': 'http://tv1.alarab.net',
             'Content-Type': 'application/x-www-form-urlencoded',
             'UserAgent': 'Mozilla/5.0 (Linux; U; Android 2.3; en-us; DROID RAZR 4G Build/6.5.1-73_DHD-11_M1-29) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1'}).addCallback(self.get_link)
        elif self.index == '3':
            url = self['menulist'].l.getCurrentSelection()[0][1]
            title = self['menulist'].l.getCurrentSelection()[0][0]
            print url
            getPage(url, method='GET', headers={'Referer': 'http://tv1.alarab.net',
             'Content-Type': 'application/x-www-form-urlencoded',
             'UserAgent': 'Mozilla/5.0 (Linux; U; Android 2.3; en-us; DROID RAZR 4G Build/6.5.1-73_DHD-11_M1-29) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1'}).addCallback(self.get_episodes)

    def exit(self):
        print self.index
        if self.index == '0':
            self.close()
        elif self.index == '1':
            self.index = '0'
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
        elif self.index == '2':
            self.index = '1'
            self['menulist'].l.setList(self.content_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
        elif self.index == '3':
            self.index = '1'
            self['menulist'].l.setList(self.content_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)

    def play_that_shit(self, data):
        sref = eServiceReference(4097, 0, data)
        self.session.open(MoviePlayer, sref)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/Albatros/poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/shahidSeries/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print 'logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print 'no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/Albatros/'):
            os.system('mkdir /tmp/Albatros/')
        else:
            print '/tmp/Albatros/ allready present'