# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/wwech.py
from imports import *
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show_all_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class wwech(Screen):

    def __init__(self, session):
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit,
         'blue': self.dnitnow}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label('')
        self['poster'] = Pixmap()
        self['title'] = Label('Watchwrestling')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.list_cat)

    def about(self):
        self.session.open(AboutScreen)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                self.load_poster()
            except:
                self['text'].setText('')

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                self.load_poster()
            except:
                self['text'].setText('')

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                self.load_poster()
            except:
                self['text'].setText('')

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                self.load_poster()
            except:
                self['text'].setText('')

    def list_cat(self):
        self.info = 'list_cat'
        self.cat_list = []
        self.load_list = [('WWE PPVs', 'http://watchwrestling.to/category/wwe/ppv/'),
         ('RAW', 'http://watchwrestling.tc/videos/category/wwe/raw/?q=/category/wwe/raw/'),
         ('SmackDown', 'http://watchwrestling.to/category/wwe/smackdown/'),
         ('Main Event', 'http://watchwrestling.to/category/wwe/main-event/'),
         ('NXT', 'http://watchwrestling.to/category/wwe/nxt/'),
         ('Saturday Morning Slam', 'http://watchwrestling.to/category/wwe/saturday-morning-slam/'),
         ('Superstars', 'http://watchwrestling.to/category/wwe/superstars/'),
         ('Total Divas', 'http://watchwrestling.to/category/wwe/totaldivas/'),
         ('WrestlingMania Collection', 'http://watchwrestling.to/category/wrestlemania/'),
         ('Attitude Era', 'http://watchwrestling.to/category/attitude-era/')]
        for each in self.load_list:
            title, url = each
            self.cat_list.append(show_(title, url, None))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        return

    def list_shows(self, data, url):
        self.info = 'list_shows'
        print data
        self.show_list = []
        max_page_nr = re.findall("<span class='pages'>Page 1 of (.*?)</span><span class=", data)
        if max_page_nr:
            max_page_nr = max_page_nr[0]
            max_nr = int(max_page_nr)
            print max_nr
            i = 1
            for i in range(1, max_nr):
                url = url + 'page/' + str(i) + '/'
                print url
                getPage(url, timeout=8, method='GET', headers={'Host': 'watchwrestling.to',
                 'Referer': 'http://watchwrestling.to/?q=/category/wwe/raw/',
                 'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36'}).addCallback(self.list_shows1)
                i += 1
                url = self['menulist'].getCurrent()[0][1]

        else:
            getPage(url, timeout=8, method='GET', headers={'Host': 'watchwrestling.to',
             'Referer': 'http://watchwrestling.to/?q=/category/wwe/raw/',
             'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_shows1)

    def list_shows1(self, data):
        movies = re.findall('<a class="clip-link" data-id=".*?" title="(.*?)" href="(.*?)">.*?<span class="clip">.*?<img src="(.*?)"', data, re.DOTALL)
        print movies
        for each in movies:
            title, url, img = each
            img = 'http:' + img
            title = str(title).replace('Watch WWE ', '')
            self.show_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.show_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def get_play_link(self, url):
        print url
        self.info = 'get_play_link'
        getPage(url, timeout=8, method='GET', headers={'Host': 'watchwrestling.to',
         'Referer': 'http://watchwrestling.to/category/wwe/ppv/',
         'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
         'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.read_link, url)

    def read_link(self, data, url):
        self.link_list = []
        print data
        crypted_links_block = re.findall('(DAILYMOTION VIDEO.*?\\(HD.*?QUALITY\\).*?</a></p>)', data, re.DOTALL)
        if crypted_links_block:
            crypted_links = re.findall('href="(.*?)".*?target="_blank">(.*?)</a>', crypted_links_block[0])
            print crypted_links
            for each in crypted_links:
                url, title = each
                title = title + ' - Dailymotion'
                self.link_list.append(cat_(title, url))

        self['menulist'].l.setList(self.link_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def get_dailymotion_link(self, url):
        print 'this is url parsed to daily function : %s' % url
        req = urllib2.Request(url)
        if 'http://wrestlingreviews.net/' in url:
            req.add_header('Host', 'wrestlingreviews.net')
        elif 'pwtalk.net' in url:
            req.add_header('Host', 'pwtalk.net')
        req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
        req.add_header('Accept', 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8')
        req.add_header('Referer', 'http://watchwrestling.to/video/watch-wwe-royal-rumble-2016/')
        req.add_header('Accept-Language', 'de-DE,de;q=0.8,en-US;q=0.6,en;q=0.4')
        req.add_header('Connection', 'keep-alive')
        page = urllib2.urlopen(req)
        data = page.read()
        print data
        daily_link = re.findall('<iframe frameborder="0" width="..." height="..." src="(.*?)\\?syndication', data)
        print daily_link
        if daily_link:
            req = urllib2.Request(daily_link[0])
            req.add_header('User-Agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.14) Gecko/20080404 Firefox/2.0.0.14')
            req.add_header('Referer', 'http://watchwrestling.to/home/')
            page = urllib2.urlopen(req)
            response = page.read()
            print response
            if '"title":"Inhalt abgelehnt."' in response:
                self.session.open(MessageBox, _('Video wurde geloescht'), MessageBox.TYPE_INFO, timeout=3)
            else:
                stream720 = re.findall('"720":\[\{"type":".*?","url":"(.*?)"\},', response)
                stream480 = re.findall('"480":\[\{"type":".*?","url":"(.*?)"\},', response)
                stream380 = re.findall('"380":\[\{"type":".*?","url":"(.*?)"\},', response)
                stream240 = re.findall('"240":\[\{"type":".*?","url":"(.*?)"\},', response)
                if stream720:
                    final_url = str(stream720[0]).replace('\\', '')
                    self.play_that_shit(final_url)

    def play_that_shit(self, data):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def ok(self):
        if self.info == 'list_cat':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            getPage(url, timeout=8, method='GET', headers={'Host': 'watchwrestling.to',
             'Referer': 'http://watchwrestling.to/',
             'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_shows, url)
        elif self.info == 'list_shows':
            selectedEntry = self['menulist'].getCurrent()[0][1]
            selectedName = self['menulist'].getCurrent()[0][0]
            url = selectedEntry
            self.filmname = str(selectedName)
            self.get_play_link(url)
        elif self.info == 'get_play_link':
            selectedEntry = self['menulist'].getCurrent()[0][1]
            self.get_dailymotion_link(selectedEntry)

    def exit(self):
        print self.info
        if re.match('(list_cat)', self.info, re.S | re.I):
            if fileExists('/tmp/shahidSeries_poster.jpg'):
                os.system('rm -r /tmp/shahidSeries_poster.jpg')
            self.close(self.session, 'exit')
        elif self.info == 'list_shows':
            self.info = 'list_cat'
            self['blue'].hide()
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'get_play_link':
            self.info = 'list_shows'
            self['blue'].hide()
            self['menulist'].l.setList(self.show_list)
            self['menulist'].l.setItemHeight(40)
            self.load_poster()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/shahidSeries_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/shahidSeries/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[shahidSeries] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[shahidSeries] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/shahidSeries/'):
            os.system('mkdir /tmp/shahidSeries/')
        else:
            print '[shahidSeries] /tmp/shahidSeries/ allready present'