# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/persian.py
from imports import *
from about import *
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'
cj = {}

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image, index):
    res = [(name,
      link,
      image,
      index)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class persian(Screen):

    def __init__(self, session):
        global old_ref
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_('About'))
        self['blue'] = Label('')
        self['Menu'] = Label('')
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self['title'] = Label('Persian LiveTV')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.dir()
        self.info = ''
        self.video_list = []
        old_ref = self.session.nav.getCurrentlyPlayingServiceReference()
        self.onLayoutFinish.append(self.show_cat)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def show_cat(self):
        self.info = 'cat'
        self.cat = []
        self.cat_list = [('http://iran-livetv.com/tv/stream/?stream=mbc2', 'MBC 2'),
         ('http://iran-livetv.com/tv/stream/?stream=mbc4', 'MBC 4'),
         ('http://iran-livetv.com/tv/stream/?stream=mbcaction', 'MBC Action'),
         ('http://iran-livetv.com/tv/stream/?stream=mbcmax', 'MBC MAX'),
         ('http://iran-livetv.com/tv/stream/?stream=mbcbollywood', 'MBC BOLLYWOOD'),
         ('http://iran-livetv.com/tv/stream/?stream=tv', 'GEM TV'),
         ('http://iran-livetv.com/tv/stream/?stream=usa', 'GEM TV USA'),
         ('http://iran-livetv.com/tv/stream/?stream=River', 'GEM TV RIVER'),
         ('http://iran-livetv.com/tv/stream/?stream=BOLLYWOOD', 'GEM BOLLYWOOD'),
         ('http://iran-livetv.com/tv/stream/?stream=TRAVEL', 'GEM TV TRAVEL'),
         ('http://iran-livetv.com/tv/stream/?stream=JUNIOR', 'GEM TV JUNIOR'),
         ('http://iran-livetv.com/tv/stream/?stream=KURD', 'GEM TV KURD'),
         ('http://iran-livetv.com/tv/stream/?stream=ONYX', 'GEM TV ONYX'),
         ('http://iran-livetv.com/tv/stream/?stream=RUBIX', 'GEM TV RUBIX'),
         ('http://iran-livetv.com/tv/stream/?stream=LIFE', 'GEM TV LIFE'),
         ('http://iran-livetv.com/tv/stream/?stream=MIFA', 'GEM TV MIFA'),
         ('http://iran-livetv.com/tv/stream/?stream=asre-emrooz', 'Asre Emrooz'),
         ('http://iran-livetv.com/tv/stream/?stream=farsi1', 'Farsi1'),
         ('http://iran-livetv.com/tv/stream/?stream=aaa-music', 'AAA Music'),
         ('http://iran-livetv.com/tv/stream/?stream=aaa-family', 'AAA family'),
         ('http://iran-livetv.com/tv/sztream/?stream=tapesh', 'Tapesh'),
         ('http://iran-livetv.com/tv/stream/?stream=pmc', 'PMC'),
         ('http://iran-livetv.com/tv/stream/?stream=tvpersia', 'TV Persia'),
         ('http://iran-livetv.com/tv/stream/?stream=nex1', 'Nex1'),
         ('http://iran-livetv.com/tv/stream/?stream=persian-movie', 'Persia Movie'),
         ('http://iran-livetv.com/tv/stream/?stream=persian-music', 'Persia music'),
         ('http://iran-livetv.com/tv/stream/?stream=persianstar1', 'PERSIAN STAR 1'),
         ('http://iran-livetv.com/tv/stream/?stream=persianstar2', 'PERSIAN STAR 2'),
         ('http://iran-livetv.com/tv/stream/?stream=tintv', 'TIN TV'),
         ('http://iran-livetv.com/tv/stream/?stream=mtc', 'MTC'),
         ('http://iran-livetv.com/tv/stream/?stream=itc', 'ITC'),
         ('http://iran-livetv.com/tv/stream/?stream=ten-tv', 'Ten Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=time-tv', 'Time Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=access-tv', 'Access Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=ganje-hozour', 'Ganje hozour'),
         ('http://iran-livetv.com/tv/stream/?stream=mercitv', 'MERCI TV'),
         ('http://iran-livetv.com/tv/stream/?stream=iran-tv', 'ITN'),
         ('http://iran-livetv.com/tv/stream/?stream=didar', 'Didar'),
         ('http://iran-livetv.com/tv/stream/?stream=face2', 'FACE2'),
         ('http://iran-livetv.com/tv/stream/?stream=kliksat', 'Kliksat'),
         ('http://iran-livetv.com/tv/stream/?stream=4ukartoon', '4U Kartoon Live Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=mitv', 'MI TV Live Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=tiktv', 'TIK TV'),
         ('http://iran-livetv.com/tv/stream/?stream=tmtv', 'TM TV'),
         ('http://iran-livetv.com/tv/stream/?stream=mihan', 'Mihan'),
         ('http://iran-livetv.com/tv/stream/?stream=iranearyayee', 'Iran Aryaee'),
         ('http://iran-livetv.com/tv/stream/?stream=zagros/', 'Zagros tv'),
         ('http://iran-livetv.com/tv/stream/?stream=kurdistantv/', 'KURDISTAN TV'),
         ('http://iran-livetv.com/tv/stream/?stream=iranplus/', 'IRAN PLUS'),
         ('http://iran-livetv.com/tv/stream/?stream=icc/', 'ICC'),
         ('http://iran-livetv.com/tv/stream/?stream=mohabbat/', 'Mohabbat'),
         ('http://iran-livetv.com/tv/stream/?stream=nejat-tv/', 'Nejat-tv'),
         ('http://iran-livetv.com/tv/stream/?stream=haft/', 'Shabakeh Haft'),
         ('http://iran-livetv.com/tv/stream/?stream=tamasha/', 'Tamasha Live Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=ashena/', 'Ashena Live Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=assyria/', 'Assyria Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=newroz/', 'NewRoz'),
         ('http://iran-livetv.com/tv/stream/?stream=komola/', 'Komala'),
         ('http://iran-livetv.com/tv/stream/?stream=hakha-tv/', 'Hakha Tv Live Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=persian-film/', 'Persian Film'),
         ('http://iran-livetv.com/tv/stream/?stream=saraabbasi/', 'Sara TV'),
         ('http://iran-livetv.com/tv/stream/?stream=golpa/', 'Golpa TV'),
         ('http://iran-livetv.com/tv/stream/?stream=aljazeera/', 'Aljazeera'),
         ('http://iran-livetv.com/tv/stream/?stream=navid-tv/', 'Navid Tv'),
         ('http://iran-livetv.com/tv/stream/?stream=blackdiamond/', 'Black Diamond'),
         ('http://iran-livetv.com/tv/stream/?stream=bbc-arabic/', 'BBC Arabic'),
         ('http://iran-livetv.com/tv/stream/?stream=sky/', 'SKY News'),
         ('http://iran-livetv.com/tv/stream/?stream=int-news/', 'INT News'),
         ('http://iran-livetv.com/tv/stream/?stream=ifilm/', 'iFilm Arabic'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=irib1', 'I.R.I.B 1'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=irib2', 'I.R.I.B 2'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=irib3', 'I.R.I.B 3'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=irib4', 'I.R.I.B 4'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=irib5', 'I.R.I.B 5'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=khabar', 'Khabar'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=baran', 'Baran'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=press-tv', 'Press-TV'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=salamat', 'Salamat'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=nasim', 'Nasim'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=ofogh', 'Ofogh'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=alalam/', 'Alalam'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=jame-jam1', 'Jame-Jam1'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=varzesh', 'varzesh'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=mostanad', 'Mostanad'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=shoma', 'Shoma'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=amoozesh', 'Amoozesh'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=namayesh', 'Namayesh'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=bazar', 'bazar'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=ifilm', 'iFilm'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=pouya', 'Pouya'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=velayat', 'Velayat'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=ghoran', 'Ghoran'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=alkosar/', 'Alkawthar'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=esfehan/', 'Esfehan'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=sahand/', 'Sahand'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=kurdestan/', 'Kordestan'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=semnan/', 'Semnan'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=aftab/', 'Aftab'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=aflak/', 'Aflak'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=fars/', 'Fars'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=khuzestan/', 'Khuzestan'),
         ('http://iran-livetv.com/tv-irib/baran/?stream=baran', 'Baran'),
         ('http://iran-livetv.com/tv-irib/stream/?stream=persiangulf', 'Persian Gulf')]
        for url, title in self.cat_list:
            self.cat.append(cat_(title, url))

        self['menulist'].l.setList(self.cat)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def get_videos(self, data):
        self.video_list = []
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        self.info = 'videos'
        url = str(selectedEntry)
        print url
        getPage(url, timeout=8, cookies=cj, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
         'Host': 'iran-livetv.com',
         'Referer': 'http://iran-livetv.com/tv/'}).addCallback(self.get_videos1)

    def get_videos1(self, data):
        print data
        videosrc = re.findall('videosrc="(.*?)" title', data)
        print videosrc
        if videosrc:
            videosrc = videosrc[0]
            self.play_vid(videosrc)

    def play_vid(self, data):
        self.info = 'player'
        if data:
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            sref = eServiceReference(4097, 0, data)
            sref.setName(selectedName)
            self.session.open(MoviePlayer, sref)

    def ok(self):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        if self.info == 'cat':
            url = str(selectedEntry)
            getPage(url, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Referer': 'http://flash-moviez.ucoz.org/publ/alle_moviez/action/3'}).addCallback(self.get_videos)

    def exit(self):
        print self.info
        if self.info == 'cat':
            self.close()
        elif self.info == 'videos':
            self.info = 'cat'
            self['menulist'].l.setList(self.cat)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'player':
            self.show()
            self.session.nav.playService(old_ref)
            self.info = 'videos'
            self['menulist'].l.setList(self.video_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/hayyes_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/hayyes/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[hayyes] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[hayyes] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/hayyes/'):
            os.system('mkdir /tmp/hayyes/')
        else:
            print '[hayyes] /tmp/hayyes/ allready present'