# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/frenshtv.py
from setup import *
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show3_(name, link, img, id):
    res = [(name,
      link,
      img,
      id)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class frenshtv(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('French-TV')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.load_data_channels)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def down(self):
        self[self.currentList].down()
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def left(self):
        self[self.currentList].pageUp()
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def right(self):
        self[self.currentList].pageDown()
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def load_data_channels(self):
        self.index = '1'
        self.letter_list = []
        frensh_list = [('Cine FX', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=cinefx&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/FX.png'),
         ('Action', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=action&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/ACTION.png'),
         ('Polar', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=polar&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/POLAR.png'),
         ('RTL 9', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=rtl9&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/rtl9.png'),
         ('Toute l Histoire', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=toutelhistoire&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/TLH.png'),
         ('AB 1', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=ab1&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/AB1.png'),
         ('Chasse & Peche', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=chasseetpeche&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/CP.png'),
         ('AB Moteurs', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=abmoteurs&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/ABMOTEURS.png'),
         ('Mangas', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=mangas&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/MANGAS.png'),
         ('Animaux', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=animaux&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/ANIMAUX.png'),
         ('Trek', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=trek&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/TREK.png'),
         ('BFM', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=bfmtv&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/BFMTV.png'),
         ('Lucky Jack', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=luckyjack&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/LJ.png'),
         ('Clubbing', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=clubbingtv&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/CLUBBINGTV.png'),
         ('Golf', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=golfchannel&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/GC.png'),
         ('Euronews', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=euronews&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/EURONEWS.png'),
         ('XXL', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=xxl&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/XXL.png'),
         ('Dorcel', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=dorceltv&type=.m3u8', 'http://www.abweb.com/images/bistvonline/chaines/DORCELTV.png'),
         ('France 2', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=france2&type=.m3u8', 'http://www.lyngsat-logo.com/hires/ff/france2.png'),
         ('France 3', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=france3&type=.m3u8', 'http://www.lyngsat-logo.com/hires/ff/france3.png'),
         ('France 4', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=france4&type=.m3u8', 'http://www.lyngsat-logo.com/hires/ff/france4.png'),
         ('France 5', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=france5&type=.m3u8', 'http://www.lyngsat-logo.com/hires/ff/france5.png'),
         ('France O', 'http://www.abweb.com/bis-tv-online/getmanifest.aspx?chn=franceo&type=.m3u8', 'http://www.lyngsat-logo.com/hires/ff/france_o.png')]
        for title, url, img in frensh_list:
            self.letter_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.letter_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def ok(self):
        final_uri = self['menulist'].l.getCurrentSelection()[0][1]
        self.play_that_shit(final_uri)

    def play_that_shit(self, data):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        fin_uri = data
        sref = eServiceReference(4097, 0, fin_uri)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[frenshtv] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[frenshtv] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[frenshtv] /tmp/teledunet/ allready present'