# -*- coding: utf-8 -*-
from setup import *
from imports import *
import urllib2

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res
	
def cat_(name, link):
    res = [(name, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class crimazlive(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('crimazlive')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.index=''
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.cat)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        try:
            self.load_poster()
        except:
            pass

    def down(self):
        self[self.currentList].down()
        try:
            self.load_poster()
        except:
            pass

    def left(self):
        self[self.currentList].pageUp()
        try:
            self.load_poster()
        except:
            pass

    def right(self):
        self[self.currentList].pageDown()
        try:
            self.load_poster()
        except:
            pass

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def cat(self):
        self.index='cat'
        self.cat_list=[]
        self.c_list=[("http://crimaz.me/all-wrestling/wwe-2/","WWE"),
        ("http://crimaz.me/wwe-raw/","RAW"),
        ("http://crimaz.me/wwe-smackdown/","Smackdown"),
        #("http://crimaz.me/wwe-tough-enough/","WWE Tough Enough"),
        ("http://crimaz.me/wwe-main-event/","WWE Main Event"),
        ("http://crimaz.me/total-divas/","Total Divas"),
        ("http://crimaz.me/wwe-superstars/","WWE Superstars"),
        #("http://crimaz.me/wwe-nxt/","WWE NXT"),
        #("http://crimaz.me/pay-per-views/wwe-pay-per-view/","WWE Pay Per Views"),
        #("http://crimaz.me/wwenetwork/","WWE Network"),
        #("http://crimaz.me/all-wrestling/tna-2/","TNA"),
        #("http://crimaz.me/tna-impact-wrestling/","Impact Wrestling"),
        #("http://crimaz.me/tna-xplosion/","TNA Xplosion"),
        #("http://crimaz.me/pay-per-views/tna-pay-per-view/","Pay Per Views"),
        #("http://crimaz.me/ufc/","UFC"),
        #("http://crimaz.me/roh/","ROH"),
        #("http://crimaz.me/lucha-underground/","Lucha Underground"),
        #("http://crimaz.me/wwe-archive/","Archive"),
        ]
        for (url,title) in self.c_list:
            self.cat_list.append(cat_(title,url))
        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
			
    def get_shows(self,data):
        print data
        self.index='shows'
        self.v_list=[]
        videos=re.findall('<img width="..." height="..." src="(.*?)".*?<div class="cb-meta"><h2 class="h4"><a href="(.*?)">Watch (.*?)</a>',data)
        for (img,url,title)in videos:
            self.v_list.append(show_(title,url,img))
        self['menulist'].l.setList(self.v_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def get_parts(self,data):
        self.index='parts'
        self.m_list=[]	
        match = re.compile('href="http://crimazlive.com/videos/dailymotion.php\?id=(.+?)"><span style="">(.+?)</span></a>').findall(data)
        for (url,part) in match:
            url = 'http://dailymotion.com/video/'+url
            self.m_list.append(cat_('DAILYMOTION :'+part,url))
        self['menulist'].l.setList(self.m_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
				
    def get_daily_q_links(self,data):
        self.index='daily'
        self.q_list=[]
        q_links=re.findall('"480":\[\{"type":".*?","url":"(.*?)"\}\]',data)
        print q_links
        for (url) in q_links:
            self.q_list.append(cat_('480P',url))
        q_links1=re.findall('"720":\[\{"type":".*?","url":"(.*?)"',data)
        for (url) in q_links1:
            url=url.replace('\\','')
            self.q_list.append(cat_('720P',url))
        self['menulist'].l.setList(self.q_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
		
    def ok(self):
        if self.index=='cat':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            print uri
            req = urllib2.Request(uri)
            req.add_header('Host','crimaz.me')
            req.add_header('Upgrade-Insecure-Requests','1')
            req.add_header('User-Agent','Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36')
            try:
                response = urllib2.urlopen(req)
                ans = response.read()
            except:
                ans='Page changed again'
            print ans
            self.get_shows(ans)
        elif self.index=='shows':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            req = urllib2.Request(uri)
            req.add_header('Host','crimaz.me')
            req.add_header('Upgrade-Insecure-Requests','1')
            req.add_header('User-Agent','Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36')
            print uri
            try:
                response = urllib2.urlopen(req)
                ans = response.read()
            except:
                ans='Page changed again'
            print ans
            self.get_parts(ans)
        elif self.index=='parts':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            req = urllib2.Request(uri)
            req.add_header('Upgrade-Insecure-Requests','1')
            req.add_header('User-Agent','Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36')
            print uri
            try:
                response = urllib2.urlopen(req)
                ans = response.read()
            except:
                ans='Page changed again'
            print ans
            self.get_daily_q_links(ans)
        elif self.index=='daily':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            self.play_that_shit(uri)           
           

    def play_that_shit(self, data):
        print data
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        if self.index=='shows':
            self.cat() 
        elif self.index=='parts':
            self.index='shows'
            self['menulist'].l.setList(self.v_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
        elif self.index=='daily':
            self.index='parts'
            self['menulist'].l.setList(self.m_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)		
        elif self.index=='cat':
            self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(jpg_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return


    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'
