# -*- coding: utf-8 -*-
from setup import *
from imports import *
import jscrypto, re, requests

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def cat_(name, link):
    res = [(name, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class ustreamix(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('ustreamix')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.onLayoutFinish.append(self.get_m)
		
    def up(self):
        self[self.currentList].up()

    def down(self):
        self[self.currentList].down()

    def left(self):
        self[self.currentList].pageUp()

    def right(self):
        self[self.currentList].pageDown()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'
			
    def get_m(self):
        self.index='channels'
        self.m_list=[]
        url='https://ustreamix.com'
        try:
            data=requests.get(url).text
        except:
            data=''
        channels=re.findall('<p><a href="(.*?)" target="_blank">(.*?)<span class="status_live">(.*?)</span>  </a></p>',data)
        if channels:
            for (lnk,title,guide) in channels:
                title=str(title)+' : '+str(guide)
                print title
                self.m_list.append(cat_(title,lnk))
        else:
            self.m_list.append(cat_('No channels found','http://'))
        self.m_list.sort()
        self['menulist'].l.setList(self.m_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)        


    def get_lnk(self,url):
        print url#stream.php?id=1tv-russia
        if 'https' in url:
            url=url
        else:
            url='https://beta.ustreamix.com/'+url
        headers={"Referer":"https://beta.ustreamix.com/"}
        try:
            data=requests.get(url,headers=headers).text
        except:
            data=''#var stream = JSON.parse(CryptoJS.AES.decrypt(e1253, p2152, {format: CryptoJSAesJson}).toString(CryptoJS.enc.Utf8));
        print data
        lnk=str(url).replace('https://beta.ustreamix.com/stream.php?id=','')
        first_ip = re.findall("x_first_ip.+?'(.*?)'", data)[0]
        first_c = re.findall("x_first_c.+?'(.*?)';",data)[0]
        ket2= re.findall("ket2.+?'(.*?)';",data)[0]
        preurl = 'http://tmg.ustreamix.com/'   # here is the server url which changed most of time
        url1 = preurl + 'stats.php?p=' + first_ip+'&C='+first_c+'&Ket='+ket2
        source = requests.get(url1, headers = {'Referer': url, 'User-Agent': 'Mozilla/5.0 (X11; Linux i686; rv:44.0) Gecko/20100101 Firefox/44.0 Iceweasel/44.0', 'Accept': '*/*'}).text
        print source
        tok = re.findall('var jdtk="(.*?)"', source)[0]
        self.play_l( str(preurl) + 'tmg.m3u8?' + str(lnk) + '&token=' + str(tok))
        #vars = re.findall(r'var stream = JSON.parse.Cr.*?\((.*?), (.*?),',data)[1] 
        #print vars
        #ct = re.findall(r'var %s.*?ct":"(.*?)"'%vars[0],data)[0] 
        #salt = re.findall(r'var %s.*?s":"(.*?)"'%vars[0],data)[0]
        #passphrase = re.findall(r"var %s.*?'(.*?)'"%vars[1],data)[0]
        #url= (jscrypto.decode(ct,passphrase,salt.decode('hex'))).replace('\\/','/').replace('"','')
        #self.play_l(url)
		
    def play_l(self,data):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)
		
    def exit(self):
        if self.index=='channels':
            self.close()
			
    def ok(self):
        if self.index=='channels':
            url = self['menulist'].l.getCurrentSelection()[0][1]
            self.get_lnk(url)
	

