# -*- coding: utf-8 -*-
from imports import *
import requests
from Tools.Directories import fileExists, pathExists
from StringIO import StringIO
import gzip

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))

#"index.php?chn=VEYx&country=Germany","http://opus.cf/logos2/VEYx.png","TF1"
def cat_(url, img, title):
    res = [(title,url, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 26), font=4, text=title, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class alltvfr(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit}, -1)
        self['menulist'] = m2list([])
        self['title'] = Label('AllTVFR')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.abc)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def up(self):
        self[self.currentList].up()
        self.load_poster_teledunet()

    def down(self):
        self[self.currentList].down()
        self.load_poster_teledunet()

    def left(self):
        self[self.currentList].pageUp()
        self.load_poster_teledunet()

    def right(self):
        self[self.currentList].pageDown()
        self.load_poster_teledunet()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def abc(self):
        self.loading_ok = False
        self.check = 'abc'
        self.currentList = 'menulist'
        self.letter_list = []
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.genre_name = 'sports'
        self.load_data_channels()

    def load_data_channels(self):
        print 'got data - now processing channel_list'
        self.chanlist = []
        self.chanlist.append(cat_("index.php?chn=VEYx&country=Germany","http://static1.purepeople.com/articles/0/31/84/0/@/219205-logo-tf1-950x0-1.jpg","TF1")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDI=&country=Germany","http://static.francetv.fr/arches/france2/default/img/og-image.jpg?20160824","France 2")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDM=&country=Germany","http://static.francetv.fr/arches/france3/default/img/og-image.jpg?20160824","France 3")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgKw==&country=Germany","http://www.creads.fr/blog/wp-content/uploads/2014/08/google_avatar_canalplus.jpg","Canal +")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDU=&country=Germany","http://static.francetv.fr/arches/france5/default/img/og-image.jpg?20160824","France 5")),
        self.chanlist.append(cat_("index.php?chn=TTY=&country=Germany","http://img.clubic.com/03597896-photo-m6-application-iphone-logo-mikeklo.jpg","M6")),
        self.chanlist.append(cat_("index.php?chn=QXJ0ZQ==&country=Germany","http://slug-news.com/wp-content/uploads/2016/04/arte_logo1.jpg","Arte")),
        self.chanlist.append(cat_("index.php?chn=Qzg=&country=Germany","http://i.imgur.com/J30PQOP.png","C8")),
        self.chanlist.append(cat_("index.php?chn=Vzk=&country=Germany","http://droidsoft.fr/wordpress/wp-content/uploads/2013/04/com-W9.png","W9")),
        self.chanlist.append(cat_("index.php?chn=VE1D&country=Germany","http://i.imgur.com/1Nq8rTR.jpg","TMC")),
        self.chanlist.append(cat_("index.php?chn=TlQx&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/8/83/NT1_2012.svg/128px-NT1_2012.svg.png","NT1")),
        self.chanlist.append(cat_("index.php?chn=TlJKIDEy&country=Germany","http://images.programme.tv/2007/08/d23cc0b1aee7b0cf62aba638946b462b.jpg","NRJ 12")),
        self.chanlist.append(cat_("index.php?chn=TENQIFB1YmxpYyBTw6luYXQ=&country=Germany","http://unisda.org/IMG/arton506.png","LCP Public Sénat")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDQ=&country=Germany","http://static.francetv.fr/arches/france4/default/img/og-image.jpg?20160824","France 4")),
        self.chanlist.append(cat_("index.php?chn=QkZNIFRW&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/8/8a/BFM_TV_logo_%282016%29.png/170px-BFM_TV_logo_%282016%29.png","BFM TV")),
        self.chanlist.append(cat_("index.php?chn=aT5Uw6lsw6k=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/9/9b/Logo_i_TELE_2013.svg/langfr-150px-Logo_i_TELE_2013.svg.png","i>Télé")),
        self.chanlist.append(cat_("index.php?chn=Q1N0YXI=&country=Germany","http://i.imgur.com/sSNnVvX.png","CStar")),
        self.chanlist.append(cat_("index.php?chn=R3VsbGk=&country=Germany","http://www.megazap.fr/photo/art/grande/9773909-15777229.jpg?v=1467313291","Gulli")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIMOU&country=Germany","http://static.francetv.fr/arches/franceo/default/img/og-image.jpg?20160824","France Ô")),
        self.chanlist.append(cat_("index.php?chn=SEQx&country=Germany","http://i.imgur.com/AzbyfpM.png","HD1")),
        self.chanlist.append(cat_("index.php?chn=TCdFcXVpcGU=&country=Germany","https://static.playmedia-cdn.net/img/tv_channels/626_mini.png","L'Equipe")),
        self.chanlist.append(cat_("index.php?chn=NnRlcg==&country=Germany","http://i.imgur.com/0KLslG3.png","6ter")),
        self.chanlist.append(cat_("index.php?chn=TnVtw6lybyAyMw==&country=Germany","http://leblogdekat.com/wp-content/uploads/2012/12/N23_LOGO.jpg","Numéro 23")),
        self.chanlist.append(cat_("index.php?chn=Uk1DIETDqWNvdXZlcnRl&country=Germany","https://www.tv-direct.fr/logo-tv/logo-rmcdecouverte.jpg","RMC Découverte")),
        self.chanlist.append(cat_("index.php?chn=Q2jDqXJpZSAyNQ==&country=Germany","https://shop.m-budget.migros.ch/media/catalog/product/cache/17/image/265x/9df78eab33525d08d6e5fb8d27136e95/c/h/cherie_25_hd_fr_116x62_wg.png","Chérie 25")),
        self.chanlist.append(cat_("index.php?chn=TENJ&country=Germany","https://www.pagesjaunesdoc.fr/images/lci_cf01d523f655a5dfb0a2ff17767b1c95.png","LCI")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIEluZm8=&country=Germany","http://img.20mn.fr/0Gkk_u0qS22pBMK_ysg7kQ/648x415_logo-chaine-france-info.jpg","France Info")),
        self.chanlist.append(cat_("index.php?chn=UGFyaXMgUHJlbWnDqHJl&country=Germany","http://static1.purepeople.com/articles/6/26/16/@/6131-logo-paris-premiere-114x114-1.jpg","Paris Première")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgKyBTcG9ydA==&country=Germany","http://seeklogo.com/images/C/Canal_Plus-logo-91C9B22306-seeklogo.com.gif","Canal + Sport")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgKyBDaW7DqW1h&country=Germany","http://passion-xbmc.org/MGalleryItem.php?id=296254","Canal + Cinéma")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwrIEZhbWlseQ==&country=Germany","https://encrypted-tbn2.gstatic.com/images?q=tbn:ANd9GcQzRI_WOg8pek_o3VBTcqHxp_vT1RixDXy_Rsscl6D41pnJq0hRXQ","Canal+ Family")),
        self.chanlist.append(cat_("index.php?chn=RXVyb3Nwb3J0&country=Germany","http://deltafonts.com/wp-content/uploads/Eurosport-Logo.jpg","Eurosport")),
        self.chanlist.append(cat_("index.php?chn=RXVyb3Nwb3J0IDI=&country=Germany","http://seeklogo.com/images/E/eurosport-2-logo-F4F0EE6E45-seeklogo.com.gif","Eurosport 2")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgKyBEw6ljYWzDqQ==&country=Germany","http://media-passion.fr/MGalleryItem.php?id=296263","Canal + Décalé")),
        self.chanlist.append(cat_("index.php?chn=R2FtZSBPbmU=&country=Germany","http://image.cellulaire.fr/channel/game-one-chaine-guide-tv.png","Game One")),
        self.chanlist.append(cat_("index.php?chn=VmlyZ2luIFJhZGlvIFRW&country=Germany","https://upload.wikimedia.org/wikipedia/fr/4/4d/Logo_-_Virgin_Radio_TV_        self.chanlist.append(cat_(2014)).png","Virgin Radio TV")),
        self.chanlist.append(cat_("index.php?chn=QkZNIFNwb3J0&country=Germany","http://www.offremedia.com/sites/default/files/styles/270x170_echelle/public/vignette/article/nl1387-logo-bfmsport.jpg?itok=fajBjCZo","BFM Sport")),
        self.chanlist.append(cat_("index.php?chn=QkZNIEJ1c2luZXNz&country=Germany","http://www.paris-newyork.tv/wp-content/upload/2013/02/Logo-BFM-Business.jpg","BFM Business")),
        self.chanlist.append(cat_("index.php?chn=QkZNIFBhcmlz&country=Germany","http://opus.cf/logos2/QkZNIFBhcmlz.png","BFM Paris")),
        self.chanlist.append(cat_("index.php?chn=UlRTIFVu&country=Germany","http://i.imgur.com/dVkikAF.png","RTS Un")),
        self.chanlist.append(cat_("index.php?chn=UlRTIERldXg=&country=Germany","http://i.imgur.com/bVgMR4f.png","RTS Deux")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQnJldGFnbmU=&country=Germany","http://i.imgur.com/OZXHQlt.png","France 3 Bretagne")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgTGFuZ3VlZG9jIFJvdXNpbGxvbg==&country=Germany","http://i.imgur.com/vDK2YkZ.jpg","France 3 Languedoc Rousillon")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgUHJvdmVuY2UtQWxwZXM=&country=Germany","http://i.imgur.com/xve1tOe.png","France 3 Provence-Alpes")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQWxwZXM=&country=Germany","http://i.imgur.com/1zlRlwZ.png","France 3 Alpes")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQ8O0dGUgZCdBenVy&country=Germany","http://i.imgur.com/IBusWOR.png","France 3 Côte d'Azur")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQmFzc2UgTm9ybWFuZGll&country=Germany","http://i.imgur.com/8tSGDme.png","France 3 Basse Normandie")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgSGF1dGUgTm9ybWFuZGll&country=Germany","http://i.imgur.com/6UHF8xm.png","France 3 Haute Normandie")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgUGF5cyBkZSBsYSBMb2lyZQ==&country=Germany","http://i.imgur.com/GvNYHb4.png","France 3 Pays de la Loire")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgUGljYXJkaWU=&country=Germany","http://i.imgur.com/Iq9wQEZ.png","France 3 Picardie")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgTm9yZCBQYXMgZGUgQ2FsYWlz&country=Germany","http://i.imgur.com/Lh7iCj2.png","France 3 Nord Pas de Calais")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQ2hhbXBhZ25lIEFyZGVubmVz&country=Germany","http://i.imgur.com/OR7bNub.png","France 3 Champagne Ardennes")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgTG9ycmFpbmU=&country=Germany","http://i.imgur.com/O69dxDB.png","France 3 Lorraine")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQWxzYWNl&country=Germany","http://i.imgur.com/NC0Vg1X.png","France 3 Alsace")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgRnJhbmNoZSBDb210w6k=&country=Germany","http://i.imgur.com/ZTVkWlJ.png","France 3 Franche Comté")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQm91cmdvZ25l&country=Germany","http://i.imgur.com/kjsBu6M.png","France 3 Bourgogne")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQ2VudHJlIFZhbCBkZSBMb2lyZQ==&country=Germany","http://i.imgur.com/PbFTS94.png","France 3 Centre Val de Loire")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgUG9pdG91IENoYXJlbnRlcw==&country=Germany","http://i.imgur.com/KxrmNyj.png","France 3 Poitou Charentes")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgTGltb3VzaW4=&country=Germany","http://i.imgur.com/29sNZfG.png","France 3 Limousin")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQXV2ZXJnbmU=&country=Germany","http://i.imgur.com/UYcB2DW.png","France 3 Auvergne")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgUmjDtG5lLUFscGVz&country=Germany","http://i.imgur.com/CP8N68D.png","France 3 Rhône-Alpes")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQXF1aXRhaW5l&country=Germany","http://i.imgur.com/dkO3bJq.png","France 3 Aquitaine")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgTWlkaS1QeXLDqW7DqWVz&country=Germany","http://i.imgur.com/IYpVhP3.png","France 3 Midi-Pyrénées")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgUGFyaXMgSWxlIGRlIEZyYW5jZQ==&country=Germany","https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcRK-I6psLfasxhzjYoRJ2V0ZKVXhx0g3ZcJIPv7ha1jXpSsG8h6FaeyGL-E","France 3 Paris Ile de France")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDMgQ29yc2U=&country=Germany","http://i.imgur.com/58Oc8Yw.png","France 3 Corse")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgQWJpdGliaS1UZW1pc2NhbWluZ3Vl&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Abitibi-Temiscamingue")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgQWNhZGll&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Acadie")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgVGVycmUgTmV1dmUgZXQgTGFicmFkb3I=&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Terre Neuve et Labrador")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgQWxiZXJ0YQ==&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Alberta")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgUXXDqWJlYw==&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Québec")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgT3R0YXdhLUdhdGluZWF1&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Ottawa-Gatineau")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgVHJvaXMgUml2acOocmVz&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Trois Rivières")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgTm9yZCBkZSBsJ09udGFyaW8=&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Nord de l'Ontario")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgU2Fza2F0Y2hld2Fu&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Saskatchewan")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgQmFjIFNhaW50LUxhdXJlbnQ=&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Bac Saint-Laurent")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgRXN0cmll&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Estrie")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgU2FndWVuYXk=&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Saguenay")),
        self.chanlist.append(cat_("index.php?chn=SUNJIFJhZGlvLUNhbmFkYSBUw6lsw6kgU2hlcmJyb29rZQ==&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Ici_Tele_logo.png/150px-Ici_Tele_logo.png","ICI Radio-Canada Télé Sherbrooke")),
        self.chanlist.append(cat_("index.php?chn=UkRJ&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/8/89/RDI_logo.svg/217px-RDI_logo.svg.png","RDI")),
        self.chanlist.append(cat_("index.php?chn=UkRT&country=Germany","https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcRfM-exskimlttCCto2bnJuGC-BVrM-pSAd9it_nbhb7VPfRevd","RDS")),
        self.chanlist.append(cat_("index.php?chn=VFZB&country=Germany","http://chau.teleinterrives.com/img/logo-chau.png","TVA")),
        self.chanlist.append(cat_("index.php?chn=Q2FzYQ==&country=Germany","http://i.imgur.com/edWopwu.png","Casa")),
        self.chanlist.append(cat_("index.php?chn=VMOpbMOpIFF1w6liZWM=&country=Germany","https://www.infopressejobs.com/sites/default/files/imagecache/jobs_logo_fb/ipjobs/employeurs/logos/logo_tele-quebec.jpg","Télé Québec")),
        self.chanlist.append(cat_("index.php?chn=RGl4&country=Germany","http://i.imgur.com/ElseGs8.png","Dix")),
        self.chanlist.append(cat_("index.php?chn=Vg==&country=Germany","http://lazonev.ca/assets/static/normes/V_logo_jaune.jpg","V")),
        self.chanlist.append(cat_("index.php?chn=VMOpdmE=&country=Germany","https://static.playmedia-cdn.net/img/tv_channels/33_medium.png","Téva")),
        self.chanlist.append(cat_("index.php?chn=VFYgQnJlaXpo&country=Germany","http://img.over-blog-kiwi.com/1/18/06/31/2014/06/25/ob_f34f67_logo-tvbreizh.png","TV Breizh")),
        self.chanlist.append(cat_("index.php?chn=TUNN&country=Germany","https://www.tv-direct.fr/logo-tv/logo-mcm.jpg","MCM")),
        self.chanlist.append(cat_("index.php?chn=QUIx&country=Germany","https://www.tv-direct.fr/logo-tv/logo-ab1.jpg","AB1")),
        self.chanlist.append(cat_("index.php?chn=Q3JpbWUgRGlzdHJpY3Q=&country=Germany","http://rp-live.orange.fr/otv_logos/logo_webtv_livetv_CrimeDistrict.png","Crime District")),
        self.chanlist.append(cat_("index.php?chn=QUIz&country=Germany","http://opus.cf/logos2/QUIz.png","AB3")),
        self.chanlist.append(cat_("index.php?chn=VFBTIFN0YXI=&country=Germany","http://www.fan2tv.com/images/tpsstar_logo.jpg","TPS Star")),
        self.chanlist.append(cat_("index.php?chn=VEY2&country=Germany","http://i.imgur.com/IiOGK0c.png","TF6")),
        self.chanlist.append(cat_("index.php?chn=TW90b3JzIFRW&country=Germany","http://www.dvbxtreme.com/wp-content/uploads/2016/07/motors-tv-logo-300x300.png","Motors TV")),
        self.chanlist.append(cat_("index.php?chn=QUIgTW90ZXVycw==&country=Germany","http://lesalondelamoto.com/wp-content/uploads/2015/06/logo-abmoteurs-valide.png","AB Moteurs")),
        self.chanlist.append(cat_("index.php?chn=VHJlayBUVg==&country=Germany","http://www.hd-motion.com/wp-content/uploads/2015/02/Trek_logo_125.jpg","Trek TV")),
        self.chanlist.append(cat_("index.php?chn=TWFuZ2Fz&country=Germany","http://www.pictonale.net/2011/04/06/vgyflzb/mid-logo-chaine-tv-mangas.png","Mangas")),
        self.chanlist.append(cat_("index.php?chn=VG91dGUgbCdIaXN0b2lyZQ==&country=Germany","http://epg.canal-plus.com/mycanal/img/CHN43FB/PNG/288X218/CHN43FB_620.PNG","Toute l'Histoire")),
        self.chanlist.append(cat_("index.php?chn=U2NpZW5jZSAmIFZpZSBUVg==&country=Germany","https://pbs.twimg.com/profile_images/671686425822306304/kHrH6Jap.jpg","Science & Vie TV")),
        self.chanlist.append(cat_("index.php?chn=QW5pbWF1eA==&country=Germany","http://www.wiiz.tv/wp-content/uploads/2015/10/animaux.png","Animaux")),
        self.chanlist.append(cat_("index.php?chn=Q2hhc3NlICYgUMOqY2hl&country=Germany","https://pbs.twimg.com/profile_images/671688108585414657/hXyq8do_.jpg","Chasse & Pêche")),
        self.chanlist.append(cat_("index.php?chn=QWN0aW9u&country=Germany","https://alloforfait.fr/wp-content/uploads/2015/10/Action-logo-2015-267x200.jpg","Action")),
        self.chanlist.append(cat_("index.php?chn=Q2luw6kgRlg=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/0/07/Cin%C3%A9_FX_logo_2013.png","Ciné FX")),
        self.chanlist.append(cat_("index.php?chn=Q2luw6kgUG9sYXI=&country=Germany","http://www.cinepolar.com/upload/ressources/chaine-Polar/images/logo.png","Ciné Polar")),
        self.chanlist.append(cat_("index.php?chn=R29sZiBDaGFubmVs&country=Germany","http://pre04.deviantart.net/9a4b/th/pre/i/2013/320/9/5/golf_channel_logo_by_mr_logo-d6uf91i.png","Golf Channel")),
        self.chanlist.append(cat_("index.php?chn=THVja3kgSmFjayBUVg==&country=Germany","http://www.ariase.com/media/television/logo-132x99/lucky-jack-hd.jpg","Lucky Jack TV")),
        self.chanlist.append(cat_("index.php?chn=Q2x1YmJpbmcgVFY=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/3/39/Clubbing_TV.png","Clubbing TV")),
        self.chanlist.append(cat_("index.php?chn=UlRMOQ==&country=Germany","http://images.programme.tv/2010/09/e5d3bbaa70282d465e0d952b6a18447a2.jpg","RTL9")),
        self.chanlist.append(cat_("index.php?chn=Q2luw6kgKyBQcmVtaWVy&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/d/dc/Cine%2BCinema%2BPremier.svg/128px-Cine%2BCinema%2BPremier.svg.png","Ciné + Premier")),
        self.chanlist.append(cat_("index.php?chn=Q2luw6kgKyBDbGFzc2lj&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/c/c0/Cine_Cinema_Classic.svg/119px-Cine_Cinema_Classic.svg.png","Ciné + Classic")),
        self.chanlist.append(cat_("index.php?chn=Q2luw6kgKyBFbW90aW9u&country=Germany","http://www.gmkfreelogos.com/logos/C/img/Cine_Cinema_Emotion.gif","Ciné + Emotion")),
        self.chanlist.append(cat_("index.php?chn=Q2luw6kgKyBGYW1peg==&country=Germany","http://opus.cf/logos2/Q2luw6kgKyBGYW1peg==.png","Ciné + Famiz")),
        self.chanlist.append(cat_("index.php?chn=Q2luw6kgKyBGcmlzc29u&country=Germany","http://opus.cf/logos2/Q2luw6kgKyBGcmlzc29u.png","Ciné + Frisson")),
        self.chanlist.append(cat_("index.php?chn=U3lmeQ==&country=Germany","http://horrorworld.org/wp-content/uploads/2015/04/syfy-logo-484_0.jpg","Syfy")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgKyBTw6lyaWVz&country=Germany","http://www.canalplusgroupe.com/uploads/news/news_121.png","Canal + Séries")),
        self.chanlist.append(cat_("index.php?chn=T0NTIE1heA==&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/d/d0/OCS_Max.svg/128px-OCS_Max.svg.png","OCS Max")),
        self.chanlist.append(cat_("index.php?chn=T0NTIENob2M=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/d/d0/OCS_Choc.svg/128px-OCS_Choc.svg.png","OCS Choc")),
        self.chanlist.append(cat_("index.php?chn=T0NTIEfDqWFudHM=&country=Germany","https://www.vialis.tm.fr/sites/default/files/cable/ocs_geant.jpg","OCS Géants")),
        self.chanlist.append(cat_("index.php?chn=T0NTIENpdHk=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/6/6d/OCS_City.svg/128px-OCS_City.svg.png","OCS City")),
        self.chanlist.append(cat_("index.php?chn=RXF1aWRpYSBMaXZl&country=Germany","https://yt3.ggpht.com/-_wRaqrOunQA/AAAAAAAAAAI/AAAAAAAAAAA/nkVwBG7_29A/s128-c-k-no-mo-rj-c0xffffff/photo.jpg","Equidia Live")),
        self.chanlist.append(cat_("index.php?chn=RXF1aWRpYSBMaWZl&country=Germany","http://i.imgur.com/A7h36HF.png","Equidia Life")),
        self.chanlist.append(cat_("index.php?chn=TUNTIEJpZW4gw4p0cmU=&country=Germany","https://pbs.twimg.com/profile_images/524935940733538304/aFl_3ir9_200x200.png","MCS Bien Être")),
        self.chanlist.append(cat_("index.php?chn=U0ZSIFNwb3J0IDE=&country=Germany","http://atelier.leparisien.fr/widgets/mixitup/drahi/img/sfrsports.jpg","SFR Sport 1")),
        self.chanlist.append(cat_("index.php?chn=U0ZSIFNwb3J0IDI=&country=Germany","http://atelier.leparisien.fr/widgets/mixitup/drahi/img/sfrsports.jpg","SFR Sport 2")),
        self.chanlist.append(cat_("index.php?chn=Rm9vdCsgMjQvMjQ=&country=Germany","http://epg.canal-plus.com/mycanal/img/CHN43FB/PNG/288X218/CHN43FB_1033.PNG","Foot+ 24/24")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgMQ==&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports 1")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgMg==&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports 2")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgMw==&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports 3")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgTUFYIDQ=&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports MAX 4")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgTUFYIDU=&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports MAX 5")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgTUFYIDY=&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports MAX 6")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgTUFYIDc=&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports MAX 7")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgTUFYIDg=&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports MAX 8")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgTUFYIDk=&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports MAX 9")),
        self.chanlist.append(cat_("index.php?chn=YmVJbiBTcG9ydHMgTUFYIDEw&country=Germany","http://www.intervpn.com/imghelp/assets/img3/bein-sport-logo.png","beIn Sports MAX 10")),
        self.chanlist.append(cat_("index.php?chn=UlRCRiBMYSBVbmU=&country=Germany","http://seeklogo.com/images/R/rtbf-la-une-logo-FE2B74AABD-seeklogo.com.gif","RTBF La Une")),
        self.chanlist.append(cat_("index.php?chn=UlRCRiBMYSBEZXV4&country=Germany","https://upload.wikimedia.org/wikipedia/en/b/b8/La_Deux_Logo.png","RTBF La Deux")),
        self.chanlist.append(cat_("index.php?chn=UlRCRiBMYSBUcm9pcw==&country=Germany","http://vignette4.wikia.nocookie.net/logopedia/images/4/40/La-trois.png/revision/latest?cb=20130215053935","RTBF La Trois")),
        self.chanlist.append(cat_("index.php?chn=Q2x1YiBSVEw=&country=Germany","https://www.tv-direct.fr/logo-tv/logo-club-rtl.jpg","Club RTL")),
        self.chanlist.append(cat_("index.php?chn=UGx1ZyBSVEw=&country=Germany","https://www.tv-direct.fr/logo-tv/logo-plug-rtl.jpg","Plug RTL")),
        self.chanlist.append(cat_("index.php?chn=Q0NUViBGcg==&country=Germany","https://upload.wikimedia.org/wikipedia/commons/5/52/CCTV_logo.png","CCTV Fr")),
        self.chanlist.append(cat_("index.php?chn=SURGMQ==&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/1/19/Idf11_2010_logo.png/150px-Idf11_2010_logo.png","IDF1")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNlIDI0&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/2/24/Logos_FRANCE24_RVB_2013.svg/128px-Logos_FRANCE24_RVB_2013.svg.png","France 24")),
        self.chanlist.append(cat_("index.php?chn=QmV1ciBUVg==&country=Germany","https://upload.wikimedia.org/wikipedia/fr/e/e6/Beur_TV.png","Beur TV")),
        self.chanlist.append(cat_("index.php?chn=QmlwIFRW&country=Germany","https://upload.wikimedia.org/wikipedia/fr/b/b1/Bip_TV_logo.png","Bip TV")),
        self.chanlist.append(cat_("index.php?chn=RGVtYWluIFRW&country=Germany","https://upload.wikimedia.org/wikipedia/fr/b/b8/Demain.TV.png","Demain TV")),
        self.chanlist.append(cat_("index.php?chn=R29uZyBCYXNl&country=Germany","http://1.bp.blogspot.com/-W7ue1K2GxE8/UV2_yhWUbvI/AAAAAAAAAbU/uUXcTMTt7PY/s320/logo_GB_cube_gris.png","Gong Base")),
        self.chanlist.append(cat_("index.php?chn=RW5vcm1lIFRW&country=Germany","https://media.licdn.com/mpr/mpr/shrink_200_200/AAEAAQAAAAAAAAZTAAAAJGI3NjRmZmVmLWI3MGYtNGE2OS05ZWQ3LTllMjlhNjMwM2QyMw.png","Enorme TV")),
        self.chanlist.append(cat_("index.php?chn=RXVyb25ld3M=&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/3/39/Euronews._2016_alternative_logo.png/220px-Euronews._2016_alternative_logo.png","Euronews")),
        self.chanlist.append(cat_("index.php?chn=S1RP&country=Germany","http://zupimages.net/up/16/16/5j7g.jpg","KTO")),
        self.chanlist.append(cat_("index.php?chn=VMOpbMOpIFBhY2lmaWM=&country=Germany","http://i.imgur.com/NwlrKUR.png","Télé Pacific")),
        self.chanlist.append(cat_("index.php?chn=SW5kaWVzIExpdmU=&country=Germany","http://nasdy.website/indieslive/wp-content/uploads/sites/47/2016/08/logo_il-2.png","Indies Live")),
        self.chanlist.append(cat_("index.php?chn=TTYgTXVzaWM=&country=Germany","http://i.imgur.com/2yCNL3r.png","M6 Music")),
        self.chanlist.append(cat_("index.php?chn=TTYgQm91dGlxdWUgJiBDbw==&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/9/9f/M6_Boutique_logo_2016.png/150px-M6_Boutique_logo_2016.png","M6 Boutique & Co")),
        self.chanlist.append(cat_("index.php?chn=TUNF&country=Germany","https://www.tv-direct.fr/logo-tv/logo-mce.jpg","MCE")),
        self.chanlist.append(cat_("index.php?chn=VFYgRmFtaWxsZQ==&country=Germany","http://i.imgur.com/dpACg3C.png","TV Famille")),
        self.chanlist.append(cat_("index.php?chn=RnJhbmNvcGhvbmllIDI0&country=Germany","http://i.imgur.com/Z0ocYur.jpg","Francophonie 24")),
        self.chanlist.append(cat_("index.php?chn=VHJhY2UgVXJiYW4=&country=Germany","http://s2.dmcdn.net/DYmIM/240x240-ht6.jpg","Trace Urban")),
        self.chanlist.append(cat_("index.php?chn=VHJhY2UgVHJvcGljYWw=&country=Germany","https://pbs.twimg.com/profile_images/786942254619451392/J4Hf-9hu_400x400.jpg","Trace Tropical")),
        self.chanlist.append(cat_("index.php?chn=VHJhY2UgQWZyaWNh&country=Germany","http://s2.dmcdn.net/DYFI5/240x240-tYy.jpg","Trace Africa")),
        self.chanlist.append(cat_("index.php?chn=UlRTIDE=&country=Germany","https://pbs.twimg.com/profile_images/631871784044863488/Hm33JdjQ.jpg","RTS 1")),
        self.chanlist.append(cat_("index.php?chn=UlRTIDI=&country=Germany","http://yamatele.tv/assets/img/channel/rts2.png","RTS 2")),
        self.chanlist.append(cat_("index.php?chn=VFY1IE1vbmRlIEZyYW5jZSBCZWxnaXF1ZSBTdWlzc2U=&country=Germany","http://img.clubic.com/03611834-photo-tv5-monde-iphone-logo-mikeklo.jpg","TV5 Monde France Belgique Suisse")),
        self.chanlist.append(cat_("index.php?chn=VFY1IE1vbmRlIEFtw6lyaXF1ZSBMYXRpbmU=&country=Germany","http://img.clubic.com/03611834-photo-tv5-monde-iphone-logo-mikeklo.jpg","TV5 Monde Amérique Latine")),
        self.chanlist.append(cat_("index.php?chn=VFY1IE1vbmRlIEluZm8=&country=Germany","http://img.clubic.com/03611834-photo-tv5-monde-iphone-logo-mikeklo.jpg","TV5 Monde Info")),
        self.chanlist.append(cat_("index.php?chn=T3VhdGNoIFRW&country=Germany","https://www.tv-direct.fr/logo-tv/logo-ouatchtv.jpg","Ouatch TV")),
        self.chanlist.append(cat_("index.php?chn=Q2FydG9vbiBOZXR3b3Jr&country=Germany","http://seeklogo.com/images/C/Cartoon_Network-logo-20456E3678-seeklogo.com.gif","Cartoon Network")),
        self.chanlist.append(cat_("index.php?chn=RGlzbmV5IENoYW5uZWw=&country=Germany","https://www.seeklogo.net/wp-content/uploads/2014/07/new-disney-channel-logo.png","Disney Channel")),
        self.chanlist.append(cat_("index.php?chn=RGlzbmV5IENoYW5uZWwgKzE=&country=Germany","https://www.seeklogo.net/wp-content/uploads/2014/07/new-disney-channel-logo.png","Disney Channel +1")),
        self.chanlist.append(cat_("index.php?chn=RGlzbmV5IFhE&country=Germany","http://vignette2.wikia.nocookie.net/boneheads/images/6/63/Disney_XD.png/revision/20151114155635","Disney XD")),
        self.chanlist.append(cat_("index.php?chn=Tmlja2Vsb2TDqW9uIDQgVGVlbg==&country=Germany","https://lh3.googleusercontent.com/fE1vUsdj04qhkUv0wtxLiiBoTXEXWDtYPrr2D6vmsEFgMq_PsWHoWpsZPcUAOlgRiPBW=s200","Nickelodéon 4 Teen")),
        self.chanlist.append(cat_("index.php?chn=RGlzbmV5IEp1bmlvcg==&country=Germany","http://opus.cf/logos2/RGlzbmV5IEp1bmlvcg==.png","Disney Junior")),
        self.chanlist.append(cat_("index.php?chn=Wm91em91cyBUVg==&country=Germany","http://www.zouzous.fr/zouzous_og_600x315.jpg?20160831101514","Zouzous TV")),
        self.chanlist.append(cat_("index.php?chn=Tm8gTGlmZQ==&country=Germany","http://nolife-tv.com/cdata/images/nolife_share.png","No Life")),
        self.chanlist.append(cat_("index.php?chn=VXNodWFpYSBUVg==&country=Germany","http://i.imgur.com/C0fjS02.png","Ushuaia TV")),
        self.chanlist.append(cat_("index.php?chn=TmF0aW9uYWwgR2VvZ3JhcGhpYyBDaGFubmVs&country=Germany","http://seeklogo.com/images/N/National_Geographic_Channel-logo-F53F22661B-seeklogo.com.gif","National Geographic Channel")),
        self.chanlist.append(cat_("index.php?chn=TmF0IEdlbyBXaWxk&country=Germany","http://ww1.prweb.com/prfiles/2013/06/27/11288239/PR-NatGeoWILD.jpg","Nat Geo Wild")),
        self.chanlist.append(cat_("index.php?chn=SGlzdG9pcmU=&country=Germany","https://boutique.orange.fr/media-cms/mediatheque/362x263-histoire-26858.png","Histoire")),
        self.chanlist.append(cat_("index.php?chn=QWxzYWNlIDIw&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/6/67/Alsace_20_logo_2013.png/320px-Alsace_20_logo_2013.png","Alsace 20")),
        self.chanlist.append(cat_("index.php?chn=QW5nZXJzIFTDqWzDqQ==&country=Germany","http://2016.festivaldanjou.com/wp-content/uploads/2016/05/logo-angers-tele.png","Angers Télé")),
        self.chanlist.append(cat_("index.php?chn=TWlyYWJlbGxlIFRW&country=Germany","https://static.playmedia-cdn.net/img/tv_channels/212_medium.png","Mirabelle TV")),
        self.chanlist.append(cat_("index.php?chn=QW50ZW5uZSBSZXVuaW9u&country=Germany","https://pbs.twimg.com/profile_images/526996215926255617/Yl9fnDZR.png","Antenne Reunion")),
        self.chanlist.append(cat_("index.php?chn=T001IFRW&country=Germany","https://www.tv-direct.fr/logo-tv/logo-om5.jpg","OM5 TV")),
        self.chanlist.append(cat_("index.php?chn=VFYgUmVubmVzIDM1&country=Germany","http://www.tebeo.bzh/contents/images/partenaires/11.jpg","TV Rennes 35")),
        self.chanlist.append(cat_("index.php?chn=WXZlbGluZXMgMcOocmU=&country=Germany","http://s3-eu-central-1.amazonaws.com/bbbook-prod/posts/photos/000/000/238/thumb/logo-Yvelines1.jpg?1404226096","Yvelines 1ère")),
        self.chanlist.append(cat_("index.php?chn=V2Vv&country=Germany","https://lh3.ggpht.com/wDZE09KbaHDb5YMKpU8REPxHv4WXeoOuvnxjd6m4ONXhCUCNMt-Ahx3cyqyKZ5KOYw=w300","Weo")),
        self.chanlist.append(cat_("index.php?chn=R3JhbmQgTGlsbGUgVFY=&country=Germany","http://kaleido.pro/wp-content/uploads/2014/05/grand-lille-tv-logo.jpg","Grand Lille TV")),
        self.chanlist.append(cat_("index.php?chn=SUxUVg==&country=Germany","http://www.telesnpdc.tv/img/partenaires/logo-iltv.png","ILTV")),
        self.chanlist.append(cat_("index.php?chn=VMOpYsOpbw==&country=Germany","http://domainedutriskellrouge.fr/wp-content/uploads/2016/06/Logo_T%C3%A9b%C3%A9o.jpg","Tébéo")),
        self.chanlist.append(cat_("index.php?chn=VMOpYsOpU3Vk&country=Germany","http://www.mondialtv.fr/wp-content/uploads/logo-tebesud.png","TébéSud")),
        self.chanlist.append(cat_("index.php?chn=TGEgQ2hhaW5lIE5vcm1hbmRl&country=Germany","https://pbs.twimg.com/profile_images/3142333564/b2d9c7255754bd8805902b504d358ee9_400x400.png","La Chaine Normande")),
        self.chanlist.append(cat_("index.php?chn=Vm9zZ2VzIFTDqWzDqXZpc2lvbg==&country=Germany","http://www.crel.fr/media/pressmedia/logo_vosges_television.png","Vosges Télévision")),
        self.chanlist.append(cat_("index.php?chn=VFZQSQ==&country=Germany","http://www.misscotebasque.com/wp-content/uploads/2015/11/tvpi.jpg","TVPI")),
        self.chanlist.append(cat_("index.php?chn=VFY3IEJvcmRlYXV4&country=Germany","https://upload.wikimedia.org/wikipedia/fr/8/85/Tv7Bordeaux-logo.jpeg","TV7 Bordeaux")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgU2F2b2ly&country=Germany","https://pbs.twimg.com/profile_images/485083706923573248/C5VxHhGM.jpeg","Canal Savoir")),
        self.chanlist.append(cat_("index.php?chn=VFY3IENvbG1hcg==&country=Germany","http://www.centraltv.fr/wp-content/uploads/tv7_colmar_fr.png","TV7 Colmar")),
        self.chanlist.append(cat_("index.php?chn=VEw3&country=Germany","https://upload.wikimedia.org/wikipedia/fr/2/21/TL7_logo.jpg","TL7")),
        self.chanlist.append(cat_("index.php?chn=VFY4IE1vbnQgQmxhbmM=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/0/06/TV8_Mont-blanc_logo_2013.png","TV8 Mont Blanc")),
        self.chanlist.append(cat_("index.php?chn=QXp1ciBUVg==&country=Germany","http://opus.cf/logos2/QXp1ciBUVg==.png","Azur TV")),
        self.chanlist.append(cat_("index.php?chn=TWEgVMOpbMOp&country=Germany","http://4.bp.blogspot.com/-Smfe605rQu8/Vk0FASLvZkI/AAAAAAAAA-o/qTZkiG-H5ks/s640/ob_458a08_logo-20de-20ma-20tele-jpg.jpeg","Ma Télé")),
        self.chanlist.append(cat_("index.php?chn=TUNNIFRvcA==&country=Germany","http://www.lagardere.com/fichiers/fckeditor/Image/Groupe/Societes_et_marques/--Logos/MCM_TOP/MCM-TOP_138.gif","MCM Top")),
        self.chanlist.append(cat_("index.php?chn=QmVCbGFjayBDYXJpYmJlYW4=&country=Germany","https://alloforfait.fr/wp-content/uploads/2014/02/BeBlack-Caribbean.jpg","BeBlack Caribbean")),
        self.chanlist.append(cat_("index.php?chn=QmVCbGFjayBDbGFzc2lr&country=Germany","https://static.playmedia-cdn.net/img/tv_channels/642_medium.png","BeBlack Classik")),
        self.chanlist.append(cat_("index.php?chn=QmVCbGFjayBBZnJpY2E=&country=Germany","https://static.playmedia-cdn.net/img/tv_channels/642_medium.png","BeBlack Africa")),
        self.chanlist.append(cat_("index.php?chn=RCFDSQ==&country=Germany","http://www.dici.fr/sites/dici.fr/files/pages/6181/logoregie.jpg","D!CI")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgQWxwaGEgTmV1Y2jDonRlbCDigJMgRGlzdHJpY3QgZOKAmVl2ZXJkb24=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/7/77/Logo_Canal_Alpha_Noire_2.jpg","Canal Alpha Neuchâtel – District d’Yverdon")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgQWxwaGEg4oCTIEp1cmEgQmVybm9pcw==&country=Germany","https://upload.wikimedia.org/wikipedia/fr/7/77/Logo_Canal_Alpha_Noire_2.jpg","Canal Alpha – Jura Bernois")),
        self.chanlist.append(cat_("index.php?chn=VMOpbMOpIEJpZWxpbmd1ZQ==&country=Germany","http://allwebtv.eu/wp-content/uploads/2016/01/TELEBIELINGUE-150x150.png","Télé Bielingue")),
        self.chanlist.append(cat_("index.php?chn=TMOpbWFuIEJsZXU=&country=Germany","http://www.lemanbleu.ch/Htdocs/Images/Pictures/21245.jpg?puid=74da0311-2f84-4bc4-9ff8-fff285759132","Léman Bleu")),
        self.chanlist.append(cat_("index.php?chn=TGEgVMOpbMOp&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/1/1d/Logo_la_tele_2014.png/200px-Logo_la_tele_2014.png","La Télé")),
        self.chanlist.append(cat_("index.php?chn=Um91Z2UgVFY=&country=Germany","http://fernsehen-live-stream.com/uploads/posts/2016-02/1454870301_rouge-tv.jpg","Rouge TV")),
        self.chanlist.append(cat_("index.php?chn=T3VpIFRW&country=Germany","http://logowow.net/logos/thumb-HKYekzSWA.png","Oui TV")),
        self.chanlist.append(cat_("index.php?chn=TlJKIFRW&country=Germany","https://upload.wikimedia.org/wikipedia/commons/thumb/7/7b/Energy_TV_Logo.png/150px-Energy_TV_Logo.png","NRJ TV")),
        self.chanlist.append(cat_("index.php?chn=TlJKIEhpdHM=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/archive/0/0c/20091220193040!Logo_NRJ_Hits.jpg","NRJ Hits")),
        self.chanlist.append(cat_("index.php?chn=TlJKIEhpdHMgQmVsZ2lxdWU=&country=Germany","https://upload.wikimedia.org/wikipedia/fr/archive/0/0c/20091220193040!Logo_NRJ_Hits.jpg","NRJ Hits Belgique")),
        self.chanlist.append(cat_("index.php?chn=QmUgQ3VyaW91cyBUVg==&country=Germany","http://www.socialize-network.com/wp-content/uploads/2015/06/be-curious-tv-01.png","Be Curious TV")),
        self.chanlist.append(cat_("index.php?chn=UlRMIFRWSQ==&country=Germany","http://www.allortl.be/wp-content/themes/allortl/assets/img/min/rtlinfini-logo.png","RTL TVI")),
        self.chanlist.append(cat_("index.php?chn=VMOpbMOpIE1C&country=Germany","http://cdn.wtvpc.com/wp-content/uploads/2016/02/TeleMBlogo_807-150x120.png","Télé MB")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgQw==&country=Germany","http://www.auplusnet.be/wp-content/uploads/2014/02/Logo_canal_c.jpg","Canal C")),
        self.chanlist.append(cat_("index.php?chn=UlRDIFTDqWzDqSBMacOoZ2U=&country=Germany","http://www.voo.be/voo2015/assets/images/chaines/locales/RTC.jpg","RTC Télé Liège")),
        self.chanlist.append(cat_("index.php?chn=Tm9Uw6lsw6k=&country=Germany","http://www.notele.be/webfiles/logo/logo.png","NoTélé")),
        self.chanlist.append(cat_("index.php?chn=QW50ZW5uZSBDZW50cmU=&country=Germany","http://www.mondialtv.fr/wp-content/uploads/logo-actv-be.png","Antenne Centre")),
        self.chanlist.append(cat_("index.php?chn=VMOpbMOpIFNhbWJyZQ==&country=Germany","http://www.telesambre.be/images/logo_telesambre_carre.jpg","Télé Sambre")),
        self.chanlist.append(cat_("index.php?chn=VMOpbMOpIFZlc2RyZQ==&country=Germany","https://pbs.twimg.com/profile_images/485030732209729536/Xkd-cXPA.jpeg","Télé Vesdre")),
        self.chanlist.append(cat_("index.php?chn=TWEgVMOpbMOpIFtCRV0=&country=Germany","http://www.matele.be/uploads/image/logo_matele.png","Ma Télé [BE]")),
        self.chanlist.append(cat_("index.php?chn=Q2FuYWwgWm9vbQ==&country=Germany","https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQeSNMtsgN_1kJ4nksI9g1-n62vYM5JAZRUhltTeTo_7nCRMf_S","Canal Zoom")),
        self.chanlist.append(cat_("index.php?chn=VFYgTHV4&country=Germany","https://upload.wikimedia.org/wikipedia/fr/thumb/a/af/Tvlux.jpg/128px-Tvlux.jpg","TV Lux")),
        self.chanlist.append(cat_("index.php?chn=Qlgx&country=Germany","http://si.rosselcdn.net/sites/default/files/imagecache/pagallery_450x300/2016/02/09/506697891_B977809379Z.1_20160209175701_000_GCR65P9GP.1-0.jpg","BX1")),
        self.chanlist.append(cat_("index.php?chn=TW9uYWNvIEluZm8=&country=Germany","http://en.kingofsat.net/jpg/monacoinfo.jpg","Monaco Info")),
        self.chanlist.append(cat_("index.php?chn=Q1BBQw==&country=Germany","http://www.cpac.ca/wp-content/themes/cpac/_resources/_images/structure/642x220_cpac_main_logo.png","CPAC")),
        self.chanlist.append(cat_("index.php?chn=UlRJIDE=&country=Germany","http://www.replaytvdirect.fr/logo/rti1.jpg","RTI 1")),
        self.chanlist.append(cat_("index.php?chn=TmF0aW9uYWwgR2VvZ3JhcGhpYyBXZWIgVFY=&country=Germany","http://www.stream4free.top//images/avatars/nationalgeo.jpg","National Geographic Web TV")),
        self.chanlist.append(cat_("index.php?chn=U3BlY2lhbCBJbnZlc3RpZ2F0aW9u&country=Germany","http://www.stream4free.top//images/avatars/specialinvestigation.jpg","Special Investigation")),
        self.chanlist.append(cat_("index.php?chn=TmF0dXJl&country=Germany","http://www.stream4free.top//images/avatars/nature.jpg","Nature")),
        self.chanlist.append(cat_("index.php?chn=U3RhcmdhdGUgU0cxIC0gU0dB&country=Germany","http://www.stream4free.top//images/avatars/stargate.jpg","Stargate SG1 - SGA")),
        self.chanlist.append(cat_("index.php?chn=SGlzdG9pcmUgV2ViIFRW&country=Germany","http://www.stream4free.top//images/avatars/histoire.png","Histoire Web TV")),
        self.chanlist.append(cat_("index.php?chn=S2FhbWVsb3R0&country=Germany","http://www.stream4free.top//images/avatars/kaamelott.jpg","Kaamelott")),
        self.chanlist.append(cat_("index.php?chn=VFYgU2NpZW5jZXM=&country=Germany","http://www.stream4free.top//images/avatars/science.jpg","TV Sciences")),
        self.chanlist.append(cat_("index.php?chn=U29kYQ==&country=Germany","http://www.stream4free.top//images/avatars/soda.jpg","Soda")),
        self.chanlist.append(cat_("index.php?chn=SCBJbnTDqWdyYWxl&country=Germany","http://www.stream4free.top//images/avatars/h.jpg","H Intégrale")),
        self.chanlist.append(cat_("index.php?chn=VFYgUmVwbGF5&country=Germany","http://www.stream4free.top//images/avatars/tv-replay.jpg","TV Replay")),
        self.chanlist.append(cat_("index.php?chn=U291dGggUGFyaw==&country=Germany","http://www.stream4free.top//images/avatars/south_park_hd.png","South Park")),
        self.chanlist.append(cat_("index.php?chn=TCdVbml2ZXJzIGV0IHNlcyBteXN0w6hyZXM=&country=Germany","http://www.stream4free.top//images/avatars/univers.jpg","L'Univers et ses mystères")),
        self.chanlist.append(cat_("index.php?chn=Q2Ftw6lyYSBDYWbDqQ==&country=Germany","http://www.stream4free.top//images/avatars/cameracafe.jpg","Caméra Café")),
        self.chanlist.append(cat_("index.php?chn=RHJhZ29uQmFsbCBEQlo=&country=Germany","http://www.stream4free.top//images/avatars/dbz.png","DragonBall DBZ")),
        self.chanlist.append(cat_("index.php?chn=U2ltcHNvbnM=&country=Germany","http://www.stream4free.top//images/avatars/Simpsons-HD-Wallpapers_resize.jpg","Simpsons")),
        self.chanlist.append(cat_("index.php?chn=TWFuIHZzIFdpbGQ=&country=Germany","http://www.stream4free.top//images/avatars/manwild.jpg","Man vs Wild")),
        self.chanlist.append(cat_("index.php?chn=RGl2ZXJzIERvY3M=&country=Germany","http://www.stream4free.top//images/avatars/divers.jpg","Divers Docs")),
        self.chanlist.append(cat_("index.php?chn=RmluYW5jZSBldCBNb25kaWFsaXNtZQ==&country=Germany","http://www.stream4free.top//images/avatars/finance.jpg","Finance et Mondialisme")),
        self.chanlist.append(cat_("index.php?chn=SidJcmFpIGRvcm1pciBjaGV6IHZvdXM=&country=Germany","http://www.stream4free.top//images/avatars/antoine.jpg","J'Irai dormir chez vous")),
        self.chanlist.append(cat_("index.php?chn=NzAgU2hvdw==&country=Germany","http://www.stream4free.top//images/avatars/70show.jpg","70 Show")),
        self.chanlist.append(cat_("index.php?chn=RW5xdcOqdGUgRXhjbHVzaXZl&country=Germany","http://www.stream4free.top//images/avatars/enquetexclu.jpg","Enquête Exclusive")),
        self.chanlist.append(cat_("index.php?chn=VW4gR2FycyBVbmUgRmlsbGU=&country=Germany","http://www.stream4free.top//images/avatars/garsfille.jpg","Un Gars Une Fille")),
        self.chanlist.append(cat_("index.php?chn=Qydlc3QgcGFzIHNvcmNpZXI=&country=Germany","http://www.france3.fr/emissions/sites/default/files/styles/ftv_site_logo_fb/public/images/theme-site/2014/09/38/cps-graphisme-125696-605949.jpg?itok=UebOI3nu","C'est pas sorcier")),
        self.chanlist.append(cat_("index.php?chn=TWEgRmFtaWxsZSBkJ2Fib3Jk&country=Germany","http://1.bp.blogspot.com/-jGwmDmt4Zto/T8-EjNAgSzI/AAAAAAAAE0E/zybZ2a35PKA/s1600/Ma+Famille+d'abord+saison+2.jpg","Ma Famille d'abord")),
        self.chanlist.append(cat_("index.php?chn=T2dneSBldCBsZXMgY2FmYXJkcw==&country=Germany","http://racacaxtv.ga/oggy.png","Oggy et les cafards")),
        self.chanlist.append(cat_("index.php?chn=TGVzIFppbnppbnMgZGUgbCdlc3BhY2U=&country=Germany","http://racacaxtv.ga/zinzins.png","Les Zinzins de l'espace")),
        self.chanlist.append(cat_("index.php?chn=TGVzIFNpbXBzb24=&country=Germany","http://racacaxtv.ga/simpson.png","Les Simpson")),
        self.chanlist.append(cat_("index.php?chn=VFBNUA==&country=Germany","http://racacaxtv.ga/tpmp.png","TPMP")),
        self.chanlist.append(cat_("index.php?chn=TkNJUw==&country=Germany","http://opus.cf/ncis.png","NCIS")),
        self['menulist'].l.setList(self.chanlist)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster_teledunet()

    def ok(self):
        if self.check == 'abc':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            self.loading_ok = False
            uri = selectedEntry
            print uri
            uri='http://racacaxtv.ga/'+uri
            req = urllib2.Request(uri)
            req.add_header('User-Agent', 'stagefright')
            try:
                page = urllib2.urlopen(req)
                response = page.read()
                #cookie = page.info()['Set-Cookie']
                print response
                page_param = re.findall('<a href="(s4fwatch.*?)"><img class="alignleft size-full wp-image-46" src="(.*?)" alt="makeimg" style="height:100px;"><br>1',response,re.DOTALL)
                if page_param:
                    pageurl='http://racacaxtv.ga/'+page_param[0][0]
                    print pageurl
                    pageurl=pageurl.replace(' ','%20')
                    req = urllib2.Request(pageurl)
                    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36')
                    req.add_header('Host', 'racacaxtv.ga')
                    page = urllib2.urlopen(req)
                    response = page.read()
                    file=re.findall('file: "(.*?)",',response)
                    self.play_that_shit(file[0])
            except:
                print'page currently offline'

    def play_that_shit(self, data):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()

    def load_poster_teledunet(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/highlive_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/HighLive/images/'
        jpg_name = 'no_cover.png'
        file_name = 'cricfree.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[bkssport_live] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[cricfree] no cover.. error'
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later on'), MessageBox.TYPE_INFO, timeout=3)

    def errorload2(self, error):
        print '[cricfree] error %s' % error
        count_movies = len(self.letter_movielist)
        self.loading_ok = True
        self.loading = 0
        self.count = 0

    def errorload(self, error):
        print error

    def dir(self):
        if not pathExists('/tmp/highlive/'):
            os.system('mkdir /tmp/highlive/')
        else:
            print '[cricfree] /tmp/highlive/ allready present'


def main(session, **kwargs):
    session.open(cricfree_perm)


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    return [PluginDescriptor(name='Cricfree - Livestreams', description='watch live events', where=[PluginDescriptor.WHERE_PLUGINMENU], fnc=main, icon='plugin.png')]