# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/wizihd.py
from setup import *
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(letter, link, img):
    res = [(letter, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class streamhdeu(Screen):

    def __init__(self, session):
        global old_ref
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['title'] = Label('StreamHD')
        self['name'] = Label('')
        self['text'] = Label('')
        self['poster'] = Pixmap()
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.index = ''
        old_ref = self.session.nav.getCurrentlyPlayingServiceReference()
        self.onLayoutFinish.append(self.category)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def category(self):
        self.index = 'cat'
        self.cat_list = []
        cat = [('http://www.streamhd.eu/football/', 'http://wizhdsports.com/images/2.png','Football'),
              ('http://www.streamhd.eu/nfl/', 'http://wizhdsports.com/images/02061406341.png','NFL'),
              ('http://www.streamhd.eu/nba/' , 'http://wizhdsports.com/images/nba.gif','NBA'),
              ('http://www.streamhd.eu/nhl/' , 'http://wizhdsports.com/images/10.png','NHL'),
              ('http://www.streamhd.eu/mlb/', 'http://wizhdsports.com/images/2902160718ball.gif','MLB'),
              ('http://www.streamhd.eu/ufc/', 'http://wizhdsports.com/images/2511150639ufc.gif','UFC'),
              ('http://www.streamhd.eu/wwe/', 'http://wizhdsports.com/images/wwe.gif','WWE'),
              ('http://www.streamhd.eu/american-football/ncaaf-live-stream/', 'http://wizhdsports.com/images/8.gif','NCAAF')]
        for url, img, title in cat:
            self.cat_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def get_matches(self, data):
        self.index = 'matches'
        self.match_list = []
        matches=re.findall('<td><span class="eventsmall">(.*?)</span><span class="hidden-xs">GMT</span> </td>.*?<td><span class="eventsmall"><a href="(.*?)"> (.*?) </a></span> </td>',data,re.DOTALL)
        if matches:
            for starttime, url , title in matches:
                title=starttime+' '+title
                url='http://www.streamhd.eu'+url
                self.match_list.append(show_(title, url, None))
            self['menulist'].l.setList(self.match_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
        return

    def get_link(self, data):
        print data
        link = re.findall('<iframe class="embed-responsive-item" name="videoiframe" src="(.*?)" frameborder="0" allowfullscreen="yes" scrolling="no"></iframe>', data)
        print link
        if link:
            getPage(link[0], timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_id, link)

    def get_id(self, data, url):
        print data
        id = re.findall('<script type="text/javascript"> fid="(.*?)";', data)
        print id
        if id:
            id = id[0]
            url = 'http://hdcast.org/streamhd.php?u='+id+'&vw=100%&vh=100%'
            print url
            getPage(url, timeout=8, method='GET', headers={'Referer': url,
             'Host': 'hdcast.org',
             'Referer':'http://streamhd.eu',
             'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_p2purl, url)
 
    def get_p2purl(self, data, url):
        import base64
        print data
        curl = re.findall('src=(.*?)&amp;width=100', data)
        if curl:
            print curl
            getPage(curl[0], timeout=8, method='GET', headers={'Referer': url,
             'Accept':'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
             'Cache-Control':'max-age=0',
             'Connection':'keep-alive',
             'Upgrade-Insecure-Requests':'1',
             'User-Agent':'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.116 Safari/537.36'
             }).addCallback(self.get_final_link, url, url)
			 
    def get_final_link(self, data, url, new_url):
        print data
        nurl = re.findall('file:"(http://.*?)",', data)
        print nurl
        if nurl:
            play_link = nurl[0]
            print play_link
            self.play_that_shit(play_link, url)

    def result(self, data):
        print data
        self.play_that_shit(data, None)
        return

    def play_that_shit(self, data, url):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        #host = data.split('/')[2]
        #print host
        p2plink = 'http://127.0.0.1:88/hls://' + data + ' headers={"Connection":"keep-alive","Cookie":"__cfduid=d50ad36ce8b641ce256a24e4aa77c974e1458413075","Referer":"%s","User-Agent":"stagefright","X-Requested-With":"ShockwaveFlash/21.0.0.182"}' % url
        sref = eServiceReference(4097, 0, p2plink)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def ok(self):
        if self.index == 'cat':
            link = self['menulist'].l.getCurrentSelection()[0][1]
            getPage(link, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_matches)
        elif self.index == 'matches':
            link = self['menulist'].l.getCurrentSelection()[0][1]
            getPage(link, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_link)

    def exit(self):
        if self.index == 'matches':
            self.index = 'cat'
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
        else:
            self.close()