# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/streamger.py
from setup import *
from about import *
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class streamger(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('GER/AUT/CH/ITA')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_('About'))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.dir()
        self.onLayoutFinish.append(self.list_channels)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def list_channels(self):
        self.channels = []
        german = [('http://wownet.ro/logo/0001.png', 'Das Erste', 'http://wownet.ro/str/0001.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0002.png', 'Das Erste HD', 'http://wownet.ro/str/0002.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0003.png', 'ZDF', 'http://wownet.ro/str/0003.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0004.png', 'ZDF HD', 'http://wownet.ro/str/0004.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0005.png', 'RTL', 'http://wownet.ro/str/0005.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/00051.png', 'RTL HD', 'http://wownet.ro/str/00051.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0006.png', 'Sat.1', 'http://wownet.ro/str/0006.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0007.png', 'ProSieben', 'http://wownet.ro/str/0007.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/00071.png', 'ProSieben HD', 'http://wownet.ro/str/00071.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0008.png', 'kabel eins', 'http://wownet.ro/str/0008.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0009.png', 'RTL II', 'http://wownet.ro/str/0009.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0010.png', 'VOX', 'http://wownet.ro/str/0010.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0011.png', 'arte', 'http://wownet.ro/str/0011.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0012.png', 'arte HD', 'http://wownet.ro/str/0012.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0013.png', '3sat', 'http://wownet.ro/str/0013.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0014.png', '3sat HD', 'http://wownet.ro/str/0014.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0106.png', 'NDR Hamburg', 'http://wownet.ro/str/0106.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0107.png', 'NDR Hamburg HD', 'http://wownet.ro/str/0107.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0108.png', 'NDR Meck.-Vorp.', 'http://wownet.ro/str/0108.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0109.png', 'NDR Meck.-Vorp. HD', 'http://wownet.ro/str/0109.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0110.png', 'NDR Niedersachsen', 'http://wownet.ro/str/0110.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0111.png', 'NDR Niedersachsen HD', 'http://wownet.ro/str/0111.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0112.png', 'NDR Schleswig-Hol.', 'http://wownet.ro/str/0112.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0113.png', 'NDR Schleswig-Hol. HD', 'http://wownet.ro/str/0113.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0017.png', 'WDR', 'http://wownet.ro/str/0017.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0018.png', 'WDR HD', 'http://wownet.ro/str/0018.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0116.png', 'MDR Sachsenanhalt', 'http://wownet.ro/str/0116.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0117.png', 'MDR Sachsen', 'http://wownet.ro/str/0117.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0118.png', 'MDR Th\xc3\xbcringen', 'http://wownet.ro/str/0118.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0020.png', 'MDR HD', 'http://wownet.ro/str/0020.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0021.png', 'BR', 'http://wownet.ro/str/0021.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0022.png', 'BR HD', 'http://wownet.ro/str/0022.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0015.png', 'Der SR', 'http://wownet.ro/str/0015.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0023.png', 'SWR', 'http://wownet.ro/str/0023.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0024.png', 'SWR HD', 'http://wownet.ro/str/0024.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0025.png', 'HR', 'http://wownet.ro/str/0025.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0026.png', 'HR HD', 'http://wownet.ro/str/0026.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0027.png', 'RBB', 'http://wownet.ro/str/0027.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0028.png', 'RBB HD', 'http://wownet.ro/str/0028.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0029.png', 'Phoenix', 'http://wownet.ro/str/0029.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0030.png', 'Phoenix HD', 'http://wownet.ro/str/0030.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0031.png', 'ARD Alpha', 'http://wownet.ro/str/0031.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0032.png', 'N24', 'http://wownet.ro/str/0032.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0033.png', 'N24 HD', 'http://wownet.ro/str/0033.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0034.png', 'n-tv', 'http://wownet.ro/str/0034.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0035.png', 'euronews', 'http://wownet.ro/str/0035.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0036.png', 'Disney Channel', 'http://wownet.ro/str/0036.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0037.png', 'Sixx', 'http://wownet.ro/str/0037.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0122.png', 'ServusTV DE', 'http://wownet.ro/str/0122.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0123.png', 'ServusTV DE HD', 'http://wownet.ro/str/0123.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0040.png', 'RTL NITRO', 'http://wownet.ro/str/0040.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0041.png', 'TELE 5', 'http://wownet.ro/str/0041.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0120.png', 'JOIZ DE', 'http://wownet.ro/str/0120.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/01201.png', 'JOIZ DE HD', 'http://wownet.ro/str/01201.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0043.png', 'Nickelodeon', 'http://wownet.ro/str/0043.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0044.png', 'Viva/Comedy Central', 'http://wownet.ro/str/0044.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0045.png', 'Super RTL', 'http://wownet.ro/str/0045.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0046.png', 'KiKA', 'http://wownet.ro/str/0046.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0047.png', 'KiKA HD', 'http://wownet.ro/str/0047.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0048.png', 'RIC', 'http://wownet.ro/str/0048.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0049.png', 'Eurosport', 'http://wownet.ro/str/0049.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0050.png', 'SPORT1', 'http://wownet.ro/str/0050.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0051.png', 'ProSieben Maxx', 'http://wownet.ro/str/0051.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0052.png', 'DMAX', 'http://wownet.ro/str/0052.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0124.png', 'm\xc3\xbcnchen.tv', 'http://wownet.ro/str/0124.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0100.png', 'blizz TV HD', 'http://wownet.ro/str/0100.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0119.png', 'Family TV HD', 'http://wownet.ro/str/0119.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0103.png', 'Alex Berlin', 'http://wownet.ro/str/0103.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0104.png', 'NRW TV HD', 'http://wownet.ro/str/0104.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0053.png', 'ZDFneo', 'http://wownet.ro/str/0053.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0054.png', 'ZDFneo HD', 'http://wownet.ro/str/0054.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0055.png', 'ZDFkultur', 'http://wownet.ro/str/0055.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0056.png', 'ZDFkultur HD', 'http://wownet.ro/str/0056.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0057.png', 'ZDFinfo', 'http://wownet.ro/str/0057.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0058.png', 'ZDFinfo HD', 'http://wownet.ro/str/0058.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0059.png', 'eins|plus', 'http://wownet.ro/str/0059.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0060.png', 'eins|plus HD', 'http://wownet.ro/str/0060.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0061.png', 'eins.festival', 'http://wownet.ro/str/0061.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0062.png', 'eins.festival HD', 'http://wownet.ro/str/0062.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0063.png', 'tagesschau24', 'http://wownet.ro/str/0063.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0064.png', 'tagesschau24 HD', 'http://wownet.ro/str/0064.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0065.png', 'Deluxe Music', 'http://wownet.ro/str/0065.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0066.png', 'Anixe', 'http://wownet.ro/str/0066.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0067.png', 'Anixe HD', 'http://wownet.ro/str/0067.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0125.png', 'Deutsche Welle', 'http://wownet.ro/str/0125.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0068.png', 'DW Europe', 'http://wownet.ro/str/0068.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0098.png', 'DAF', 'http://wownet.ro/str/0098.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0099.png', 'Welt der Wunder TV', 'http://wownet.ro/str/0099.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0069.png', 'k-tv', 'http://wownet.ro/str/0069.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0105.png', 'Bibel TV', 'http://wownet.ro/str/0105.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0070.png', 'ORF eins', 'http://wownet.ro/str/0070.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0071.png', 'ORF eins HD', 'http://wownet.ro/str/0071.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0072.png', 'ORF 2', 'http://wownet.ro/str/0072.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0073.png', 'ORF 2 HD', 'http://wownet.ro/str/0073.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0096.png', 'ORF III', 'http://wownet.ro/str/0096.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0097.png', 'ORF Sport+', 'http://wownet.ro/str/0097.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0074.png', 'ATV', 'http://wownet.ro/str/0074.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0126.png', 'gotv Music', 'http://wownet.ro/str/0126.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0075.png', 'SRF 1', 'http://wownet.ro/str/0075.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0076.png', 'SRF 1 HD', 'http://wownet.ro/str/0076.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0077.png', 'SRF zwei', 'http://wownet.ro/str/0077.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0078.png', 'SRF zwei HD', 'http://wownet.ro/str/0078.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0079.png', 'SRF info', 'http://wownet.ro/str/0079.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0080.png', '3plus', 'http://wownet.ro/str/0080.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://logo.iptv.ink/446148.png', 'PULS 8 HD', 'http://hls.tv.iptv.ink/puls8ch@446148.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0042.png', 'JOIZ CH', 'http://wownet.ro/str/0042.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0081.png', 'S1 HD', 'http://wownet.ro/str/0081.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0082.png', 'TV24 HD', 'http://wownet.ro/str/0082.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0083.png', 'Tele Z\xc3\xbcri', 'http://wownet.ro/str/0083.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0084.png', 'Tele Z\xc3\xbcri HD', 'http://wownet.ro/str/0084.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0085.png', 'Tele B\xc3\xa4rn', 'http://wownet.ro/str/0085.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0086.png', 'Tele Basel', 'http://wownet.ro/str/0086.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0087.png', 'Tele Bielingue', 'http://wownet.ro/str/0087.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0088.png', 'Tele S\xc3\xbcdostschweiz', 'http://wownet.ro/str/0088.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0089.png', 'Tele Ostschweiz', 'http://wownet.ro/str/0089.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0090.png', 'Tele 1', 'http://wownet.ro/str/0090.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0091.png', 'Tele Top SH', 'http://wownet.ro/str/0091.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0092.png', 'Tele Top TG', 'http://wownet.ro/str/0092.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0093.png', 'Tele Top ZH', 'http://wownet.ro/str/0093.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0094.png', 'Tele M1 Ost', 'http://wownet.ro/str/0094.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0095.png', 'Tele M1 West', 'http://wownet.ro/str/0095.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0201.png', 'TF1', 'http://wownet.ro/str/0201.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0202.png', 'TF1 HD', 'http://wownet.ro/str/0202.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0203.png', 'France 2', 'http://wownet.ro/str/0203.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0204.png', 'France 2 HD', 'http://wownet.ro/str/0204.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0205.png', 'France 3', 'http://wownet.ro/str/0205.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0221.png', 'France 4', 'http://wownet.ro/str/0221.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0207.png', 'France 5', 'http://wownet.ro/str/0207.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0206.png', 'Canal+', 'http://wownet.ro/str/0206.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0208.png', 'M6', 'http://wownet.ro/str/0208.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0209.png', 'M6 HD', 'http://wownet.ro/str/0209.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0210.png', 'RTS Un', 'http://wownet.ro/str/0210.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0211.png', 'RTS Un HD', 'http://wownet.ro/str/0211.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0212.png', 'RTS Deux', 'http://wownet.ro/str/0212.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0213.png', 'RTS Deux HD', 'http://wownet.ro/str/0213.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0214.png', 'arte', 'http://wownet.ro/str/0214.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0215.png', 'arte HD', 'http://wownet.ro/str/0215.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0216.png', 'D8', 'http://wownet.ro/str/0216.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0217.png', 'W9', 'http://wownet.ro/str/0217.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0218.png', 'TMC', 'http://wownet.ro/str/0218.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0219.png', 'NT 1', 'http://wownet.ro/str/0219.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0220.png', 'NRJ 12', 'http://wownet.ro/str/0220.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0222.png', 'BFM TV', 'http://wownet.ro/str/0222.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0235.png', 'BFM Business', 'http://wownet.ro/str/0235.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0223.png', 'i>T\xc3\xa9l\xc3\xa9', 'http://wownet.ro/str/0223.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0224.png', 'D17', 'http://wownet.ro/str/0224.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0225.png', 'gulli', 'http://wownet.ro/str/0225.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0226.png', 'France \xc3\x94', 'http://wownet.ro/str/0226.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0227.png', 'HD1 HD', 'http://wownet.ro/str/0227.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0228.png', 'L Equipe 21 HD', 'http://wownet.ro/str/0228.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0229.png', '6ter HD', 'http://wownet.ro/str/0229.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0230.png', 'Num\xc3\xa9ro 23 HD', 'http://wownet.ro/str/0230.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0231.png', 'RMC D\xc3\xa9couverte HD', 'http://wownet.ro/str/0231.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0232.png', 'Ch\xc3\xa9rie 25 HD', 'http://wownet.ro/str/0232.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0233.png', 'RTL 9 HD', 'http://wownet.ro/str/0233.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0234.png', 'TV5MONDE', 'http://wownet.ro/str/0234.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0236.png', 'France 24', 'http://wownet.ro/str/0236.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0237.png', 'euronews', 'http://wownet.ro/str/0237.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0238.png', 'Montagne TV', 'http://wownet.ro/str/0238.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0239.png', 'Cartoon Network', 'http://wownet.ro/str/0239.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0240.png', 'TVM 3', 'http://wownet.ro/str/0240.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0241.png', 'rouge TV', 'http://wownet.ro/str/0241.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0242.png', 'canal 9', 'http://wownet.ro/str/0242.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0243.png', 'kto', 'http://wownet.ro/str/0243.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0244.png', 'la t\xc3\xa9l\xc3\xa9', 'http://wownet.ro/str/0244.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0245.png', 'l\xc3\xa9man bleu', 'http://wownet.ro/str/0245.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0246.png', 'canal alpha', 'http://wownet.ro/str/0246.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0247.png', 'canal alpha NE', 'http://wownet.ro/str/0247.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0401.png', 'BBC One', 'http://wownet.ro/str/0401.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0402.png', 'BBC One HD', 'http://wownet.ro/str/0402.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0403.png', 'BBC Two', 'http://wownet.ro/str/0403.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0404.png', 'BBC Two HD', 'http://wownet.ro/str/0404.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0405.png', 'BBC Three', 'http://wownet.ro/str/0405.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0406.png', 'BBC Three HD', 'http://wownet.ro/str/0406.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0407.png', 'BBC Four', 'http://wownet.ro/str/0407.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0408.png', 'BBC Four HD', 'http://wownet.ro/str/0408.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0409.png', 'iTV', 'http://wownet.ro/str/0409.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0410.png', 'iTV HD', 'http://wownet.ro/str/0410.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0411.png', 'iTV 2', 'http://wownet.ro/str/0411.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0412.png', 'iTV 3', 'http://wownet.ro/str/0412.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0413.png', 'iTV 4', 'http://wownet.ro/str/0413.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0414.png', 'Channel 4 HD', 'http://wownet.ro/str/0414.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0415.png', 'Film4', 'http://wownet.ro/str/0415.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0416.png', 'Channel 5', 'http://wownet.ro/str/0416.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0417.png', 'More4', 'http://wownet.ro/str/0417.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0418.png', 'E4', 'http://wownet.ro/str/0418.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0419.png', 'Fashion TV', 'http://wownet.ro/str/0419.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0420.png', 'travel channel', 'http://wownet.ro/str/0420.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0421.png', 'BBC News HD', 'http://wownet.ro/str/0421.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0422.png', 'BBC World News', 'http://wownet.ro/str/0422.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0423.png', 'CNN', 'http://wownet.ro/str/0423.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0424.png', 'CCTV News', 'http://wownet.ro/str/0424.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0425.png', 'Al Jazeera', 'http://wownet.ro/str/0425.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0426.png', 'Bloomberg', 'http://wownet.ro/str/0426.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0427.png', 'CNBC', 'http://wownet.ro/str/0427.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0428.png', 'NHK World', 'http://wownet.ro/str/0428.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0429.png', 'Russia Today [EN]', 'http://wownet.ro/str/0429.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0431.png', 'Russia Today HD [EN]', 'http://wownet.ro/str/0431.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0430.png', 'Sky News', 'http://wownet.ro/str/0430.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0601.png', 'RSI LA 1', 'http://wownet.ro/str/0601.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0602.png', 'RSI LA 1 HD', 'http://wownet.ro/str/0602.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0603.png', 'RSI LA 2', 'http://wownet.ro/str/0603.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0604.png', 'RSI LA 2 HD', 'http://wownet.ro/str/0604.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0605.png', 'Rai 1', 'http://wownet.ro/str/0605.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0606.png', 'Rai 2', 'http://wownet.ro/str/0606.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0607.png', 'Rai 3', 'http://wownet.ro/str/0607.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0623.png', 'Rai 4', 'http://wownet.ro/str/0623.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0624.png', 'Rai 5', 'http://wownet.ro/str/0624.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0608.png', 'Rai Gulp', 'http://wownet.ro/str/0608.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0609.png', 'Rai Scoula', 'http://wownet.ro/str/0609.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0610.png', 'Rai Storia', 'http://wownet.ro/str/0610.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0611.png', 'Rai Sport 1', 'http://wownet.ro/str/0611.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0612.png', 'Rai Sport 2', 'http://wownet.ro/str/0612.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0613.png', 'Rai News', 'http://wownet.ro/str/0613.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0621.png', 'Rai Movie', 'http://wownet.ro/str/0621.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0622.png', 'Rai Premium', 'http://wownet.ro/str/0622.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0614.png', 'Canale 5', 'http://wownet.ro/str/0614.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0615.png', 'Italia 1', 'http://wownet.ro/str/0615.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0616.png', 'TV Moda', 'http://wownet.ro/str/0616.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0617.png', 'LA7', 'http://wownet.ro/str/0617.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0619.png', 'RETE 4', 'http://wownet.ro/str/0619.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0620.png', 'Cielo', 'http://wownet.ro/str/0620.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0618.png', 'Tele Ticino', 'http://wownet.ro/str/0618.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0801.png', 'TRT1 HD', 'http://wownet.ro/str/0801.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0805.png', 'TRT HD', 'http://wownet.ro/str/0805.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0803.png', 'TRT HABER HD', 'http://wownet.ro/str/0803.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0807.png', 'TRT SPOR HD', 'http://wownet.ro/str/0807.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0809.png', 'TRT M\xc3\x9cZIK', 'http://wownet.ro/str/0809.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0811.png', 'TRT \xc3\x87ocuk', 'http://wownet.ro/str/0811.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0813.png', 'TRT T\xc3\x9cRK HD', 'http://wownet.ro/str/0813.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0815.png', 'Kanal D HD', 'http://wownet.ro/str/0815.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0816.png', 'CNN T\xc3\xbcrk', 'http://wownet.ro/str/0816.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0817.png', 'TV 2', 'http://wownet.ro/str/0817.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0818.png', 'Dream TV', 'http://wownet.ro/str/0818.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0819.png', 'Dreamt\xc3\xbcrk TV', 'http://wownet.ro/str/0819.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0820.png', 'Taksim', 'http://wownet.ro/str/0820.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0821.png', 'FOX TV', 'http://wownet.ro/str/0821.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0822.png', 'STAR TV', 'http://wownet.ro/str/0822.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0823.png', 'ATV', 'http://wownet.ro/str/0823.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0829.png', 'ATV Azerbaycan', 'http://wownet.ro/str/0829.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0824.png', 'SHOW TV', 'http://wownet.ro/str/0824.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0825.png', 'KANAL 7 HD', 'http://wownet.ro/str/0825.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0826.png', 'TV 8', 'http://wownet.ro/str/0826.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0827.png', 'NTV', 'http://wownet.ro/str/0827.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0828.png', 'NTV SPOR', 'http://wownet.ro/str/0828.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0700.png', '\xd0\x9f\xd0\xb5\xd1\x80\xd0\xb2\xd1\x8b\xd0\xb9 \xd0\xba\xd0\xb0\xd0\xbd\xd0\xb0\xd0\xbb', 'http://wownet.ro/str/0700.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0702.png', '\xd0\xa0\xd0\xbe\xd1\x81\xd1\x81\xd0\xb8\xd1\x8f-1', 'http://wownet.ro/str/0702.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0704.png', '\xd0\xa0\xd0\xbe\xd1\x81\xd1\x81\xd0\xb8\xd1\x8f-2', 'http://wownet.ro/str/0704.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0706.png', '\xd0\xa0\xd0\xbe\xd1\x81\xd1\x81\xd0\xb8\xd1\x8f-24', 'http://wownet.ro/str/0706.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0724.png', '\xd0\xa0\xd0\xbe\xd1\x81\xd1\x81\xd0\xb8\xd1\x8f \xd0\x9a', 'http://wownet.ro/str/0724.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0708.png', '\xd0\xa1\xd0\xbf\xd0\xbe\xd1\x80\xd1\x82 1', 'http://wownet.ro/str/0708.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0710.png', '\xd0\x9e\xd0\xa2\xd0\xa0', 'http://wownet.ro/str/0710.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0711.png', '\xd0\xa2\xd0\x9d\xd0\xa2', 'http://wownet.ro/str/0711.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0712.png', '\xd0\xa2\xd0\x9d\xd0\xa2-Comedy', 'http://wownet.ro/str/0712.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0713.png', '\xd0\xa1\xd0\xa2\xd0\xa1', 'http://wownet.ro/str/0713.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0714.png', '\xd0\x9d\xd0\xa2\xd0\x92', 'http://wownet.ro/str/0714.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0715.png', '\xd0\x9f\xd1\x8f\xd1\x82\xd1\x8b\xd0\xb9', 'http://wownet.ro/str/0715.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0716.png', '\xd0\x9e\xd0\xa2\xd0\xa1', 'http://wownet.ro/str/0716.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0717.png', 'Lifenews', 'http://wownet.ro/str/0717.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0718.png', '\xd0\xa2\xd0\x92-3', 'http://wownet.ro/str/0718.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0719.png', '\xd0\x9f\xd1\x8f\xd1\x82\xd0\xbd\xd0\xb8\xd1\x86\xd0\xb0', 'http://wownet.ro/str/0719.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0720.png', '\xd0\x97\xd0\xb2\xd0\xb5\xd0\xb7\xd0\xb4\xd0\xb0', 'http://wownet.ro/str/0720.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0721.png', '49 \xd0\x9a\xd0\x90\xd0\x9d\xd0\x90\xd0\x9b', 'http://wownet.ro/str/0721.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0722.png', '\xd0\xa0\xd0\x91\xd0\x9a', 'http://wownet.ro/str/0722.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0723.png', '\xd0\xae\xd0\xbc\xd0\xbe\xd1\x80 \xd0\xa2\xd0\x92', 'http://wownet.ro/str/0723.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0725.png', '\xd0\x9c\xd0\xb8\xd1\x80 24', 'http://wownet.ro/str/0725.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0726.png', 'EuroNews', 'http://wownet.ro/str/0726.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0727.png', '\xd0\xa2\xd0\x92\xd0\xa6', 'http://wownet.ro/str/0727.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0728.png', 'TVXXI', 'http://wownet.ro/str/0728.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0735.png', '2x2', 'http://wownet.ro/str/0735.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0736.png', '\xd0\x9a\xd0\xb0\xd1\x80\xd1\x83\xd1\x81\xd0\xb5\xd0\xbb\xd1\x8c', 'http://wownet.ro/str/0736.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0731.png', 'Nickelodeon', 'http://wownet.ro/str/0731.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0734.png', 'Cartoon Network', 'http://wownet.ro/str/0734.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0500.png', 'RTP 1', 'http://wownet.ro/str/0500.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0501.png', 'RTP 2', 'http://wownet.ro/str/0501.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0502.png', 'SIC', 'http://wownet.ro/str/0502.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0503.png', 'TVI', 'http://wownet.ro/str/0503.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0504.png', 'TVI 24', 'http://wownet.ro/str/0504.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0505.png', 'RTP \xc3\x81frica', 'http://wownet.ro/str/0505.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0506.png', 'RTP Mem\xc3\xb3ria', 'http://wownet.ro/str/0506.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0507.png', 'RTP Madeira', 'http://wownet.ro/str/0507.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0508.png', 'RTP A\xc3\xa7ores', 'http://wownet.ro/str/0508.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0509.png', 'RTP Internacional', 'http://wownet.ro/str/0509.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0510.png', 'RTP Informa\xc3\xa7\xc3\xa3o', 'http://wownet.ro/str/0510.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/0511.png', 'Econ\xc3\xb3mico TV', 'http://wownet.ro/str/0511.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1001.png', '\xce\x95\xce\xa1\xce\xa41', 'http://wownet.ro/str/1001.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1002.png', '\xce\x95\xce\xa1\xce\xa42', 'http://wownet.ro/str/1002.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1003.png', '\xce\x95\xce\xa1\xce\xa43', 'http://wownet.ro/str/1003.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1005.png', 'MEGA', 'http://wownet.ro/str/1005.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1006.png', 'ALPHA', 'http://wownet.ro/str/1006.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1010.png', 'EURONEWS', 'http://wownet.ro/str/1010.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1100.png', 'TVP 1', 'http://wownet.ro/str/1100.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1101.png', 'TVP 2', 'http://wownet.ro/str/1101.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1102.png', 'TVP Info', 'http://wownet.ro/str/1102.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1103.png', 'TVP Historia', 'http://wownet.ro/str/1103.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1104.png', 'TVP Seriale', 'http://wownet.ro/str/1104.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1106.png', 'TVN', 'http://wownet.ro/str/1106.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1107.png', 'TVN 24', 'http://wownet.ro/str/1107.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1108.png', 'TVN Style', 'http://wownet.ro/str/1108.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1109.png', 'TVN Turbo', 'http://wownet.ro/str/1109.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1110.png', 'TTV', 'http://wownet.ro/str/1110.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1111.png', 'AXN', 'http://wownet.ro/str/1111.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1112.png', 'AXN White', 'http://wownet.ro/str/1112.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1113.png', 'AXN Black', 'http://wownet.ro/str/1113.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1120.png', 'HBO', 'http://wownet.ro/str/1120.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1121.png', 'HBO 2', 'http://wownet.ro/str/1121.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1122.png', 'HBO Comedy', 'http://wownet.ro/str/1122.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1115.png', 'TLC', 'http://wownet.ro/str/1115.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1116.png', 'N Sport', 'http://wownet.ro/str/1116.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1117.png', 'Disney Channel', 'http://wownet.ro/str/1117.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1118.png', 'Disney XD', 'http://wownet.ro/str/1118.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1123.png', 'Eskatv', 'http://wownet.ro/str/1123.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1124.png', 'Eska Best Music HD', 'http://wownet.ro/str/1124.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1125.png', 'Eska Party HD', 'http://wownet.ro/str/1125.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1126.png', 'Eska Rock HD', 'http://wownet.ro/str/1126.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1127.png', 'Wawa TV HD', 'http://wownet.ro/str/1127.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1128.png', 'Polo TV', 'http://wownet.ro/str/1128.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1119.png', 'Fokus TV', 'http://wownet.ro/str/1119.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1200.png', 'Nova', 'http://cz.wownet.ro:8003 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1201.png', 'Nova Cinema', 'http://cz.wownet.ro:8020 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1202.png', 'Nova Sport', 'http://cz.wownet.ro:8023 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1203.png', 'Prima', 'http://cz.wownet.ro:8004 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1204.png', 'Prima Love', 'http://cz.wownet.ro:8019 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1205.png', 'Prima Cool', 'http://cz.wownet.ro:8021 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1206.png', 'Prima ZOOM', 'http://cz.wownet.ro:8011 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1207.png', '\xc4\x8cT1', 'http://cz.wownet.ro:8001 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1208.png', '\xc4\x8cT2', 'http://cz.wownet.ro:8002 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1209.png', '\xc4\x8cT Sport', 'http://cz.wownet.ro:8014 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1210.png', '\xc4\x8cT24', 'http://cz.wownet.ro:8015 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1211.png', '\xc4\x8cT:D', 'http://cz.wownet.ro:8005 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1212.png', 'Noe', 'http://cz.wownet.ro:8017 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1213.png', 'Barrandov', 'http://cz.wownet.ro:8022 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1214.png', '\xc3\x93\xc4\x8dko', 'http://cz.wownet.ro:8016 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1215.png', '\xc3\x93\xc4\x8dko Gold', 'http://cz.wownet.ro:8012 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1216.png', '\xc5\xa0l\xc3\xa1gr TV', 'http://cz.wownet.ro:8013 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1217.png', 'RETRO', 'http://cz.wownet.ro:8018 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/1218.png', 'VH1 Classic', 'http://cz.wownet.ro:8024 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9001.png', 'VEVO US/CA 1', 'http://wownet.ro/str/9001.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9002.png', 'VEVO US/CA 1 HD', 'http://wownet.ro/str/9002.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9003.png', 'VEVO US/CA 2', 'http://wownet.ro/str/9003.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9004.png', 'VEVO US/CA 2 HD', 'http://wownet.ro/str/9004.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9005.png', 'VEVO US/CA 3', 'http://wownet.ro/str/9005.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9006.png', 'VEVO US/CA 3 HD', 'http://wownet.ro/str/9006.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9007.png', 'VEVO DE', 'http://wownet.ro/str/9007.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}'),
         ('http://wownet.ro/logo/9008.png', 'VEVO DE HD', 'http://wownet.ro/str/9008.m3u8 headers={"X-Forwarded-For":"81.17.18.50"}')]
        for img, title, url in german:
            self.channels.append(show_(title, url, img))

        self['menulist'].l.setList(self.channels)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def ok(self):
        url = self['menulist'].l.getCurrentSelection()[0][1]
        self.play_channel(url)

    def play_channel(self, data):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        data = 'http://127.0.0.1:88/hlsvariant://' + data
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print 'Error: no data'

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ exists'