from imports import *


class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class myonlinetv(Screen):

    def __init__(self, session):
        Screen.__init__(self, session)
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        self.ch_list=[]
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_('About'))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self['title'] = Label('MyTVOnline')
        self['menulist'] = m2list([])
        self.onLayoutFinish.append(self.list_cat)
        self['shortcuts'] = NumberActionMap(['ShortcutActions',
         'WizardActions',
         'NumberActions',
         'InputActions',
         'InputAsciiActions',
         'KeyboardInputActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right}, -1)
        self['OkCancelActions'] = HelpableActionMap(self, 'OkCancelActions', {'cancel': self.exit,
         'ok': self.ok}, -1)
        self['ColorActions'] = HelpableActionMap(self, 'ColorActions', {'red': self.exit,
         'blue': self.blue,
         'yellow':self.about,
         }, -1)
        self['EPGSelectActions'] = HelpableActionMap(self, 'EPGSelectActions', {'nextBouquet': self.b_up,
         'prevBouquet': self.b_down}, -1)

    def about(self):
        self.session.open(AboutScreen)

    def blue(self):
        self.close()

    def b_up(self):
        self['menulist'].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def up(self):
        self['menulist'].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def b_down(self):
        self['menulist'].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def down(self):
        self['menulist'].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def left(self):
        self['menulist'].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def right(self):
        self['menulist'].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def list_cat(self):
        self.sel = '1'
        self.c_list=[]
        countries=[('French TV'),
        ('English TV'),
        ('German TV'),
        ('Arabic M-Orient TV'),
        ('Turk TV'),
        ('Asia TV'),
        ('China TV'),
        ('Indo PAK TV'),
        ('Espana TV'),
        ('Porto and Brasil TV'),
        ('Europe Est TV'),
        ('Ro-Bg TV'),
        ('Russie-Ukr TV'),
        ('Balkan TV'),
        ('Holland TV'),
        ('Italia TV'),
        ('Nordic TV'),
        ('Iran TV')]
        for country in countries:
            self.c_list.append(cat_(country,None))
        self['menulist'].l.setList(self.c_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
			
    def list_urls(self):
        self.sel='2'
        selected = self['menulist'].getCurrent()[0][0]        
        if selected=='French TV':
            urls=[('http://www.mytvonline.org/fr-divers.html'),('http://www.mytvonline.org/fr-music.html'),('http://www.mytvonline.org/fr-sport.html'),('http://www.mytvonline.org/fr-local.html'),('http://www.mytvonline.org/fr-news.html'),('http://www.mytvonline.org/fr-generaliste.html')]
        elif selected=='English TV':
            urls=[('http://www.mytvonline.org/en-generalist.html'),('http://www.mytvonline.org/en-local.html'),('http://www.mytvonline.org/en-news.html'),('http://www.mytvonline.org/en-divers.html'),('http://www.mytvonline.org/en-music.html'),('http://www.mytvonline.org/en-sport.html')]
        elif selected=='German TV':	
            urls=[('http://www.mytvonline.org/allemande.php'),('http://www.mytvonline.org/de-generalist.html'),('http://www.mytvonline.org/de-local.html'),('http://www.mytvonline.org/de-news.html'),('http://www.mytvonline.org/de-divers.html'),('http://www.mytvonline.org/de-music.html'),('http://www.mytvonline.org/de-sport.html')]
        elif selected=='Arabic M-Orient TV':
            urls=[('http://www.mytvonline.org/ar-generalist.html'),('http://www.mytvonline.org/ar-news.html'),('http://www.mytvonline.org/ar-divers.html'),('http://www.mytvonline.org/ar-music.html'),('http://www.mytvonline.org/ar-sport.html')]
        elif selected=='Turk TV':
            urls=[('http://www.mytvonline.org/tr-generalist.html'),('http://www.mytvonline.org/tr-local.html'),('http://www.mytvonline.org/tr-news.html'),('http://www.mytvonline.org/tr-divers.html'),('http://www.mytvonline.org/tr-music.html'),('http://www.mytvonline.org/tr-sport.html')]
        elif selected=='Asia TV':
            urls=[('http://www.mytvonline.org/asia-generalist.html'),('http://www.mytvonline.org/asia-news.html'),('http://www.mytvonline.org/asia-divers.html'),('http://www.mytvonline.org/asia-music.html'),('http://www.mytvonline.org/asia-sport.html')]
        elif selected=='China TV':
            urls=[('http://www.mytvonline.org/cn-generalist.html'),('http://www.mytvonline.org/cn-news.html'),('http://www.mytvonline.org/cn-divers.html'),('http://www.mytvonline.org/cn-music.html'),('http://www.mytvonline.org/cn-sport.html')]
        elif selected=='Indo PAK TV':
            urls=[('http://www.mytvonline.org/indo-generalist.html'),('http://www.mytvonline.org/indo-news.html'),('http://www.mytvonline.org/indo-divers.html'),('http://www.mytvonline.org/indo-music.html'),('http://www.mytvonline.org/indo-sport.html')]
        elif selected=='Espana TV':
            urls=[('http://www.mytvonline.org/es-generalist.html'),('http://www.mytvonline.org/es-news.html'),('http://www.mytvonline.org/es-divers.html'),('http://www.mytvonline.org/es-music.html'),('http://www.mytvonline.org/es-sport.html')]
        elif selected=='Porto and Brasil TV':
            urls=[('http://www.mytvonline.org/pt-generalist.html'),('http://www.mytvonline.org/pt-news.html'),('http://www.mytvonline.org/pt-divers.html'),('http://www.mytvonline.org/pt-music.html'),('http://www.mytvonline.org/pt-sport.html')]
        elif selected=='Europe Est TV':
            urls=[('http://www.mytvonline.org/est-generalist.html'),('http://www.mytvonline.org/est-news.html'),('http://www.mytvonline.org/est-divers.html'),('http://www.mytvonline.org/est-music.html'),('http://www.mytvonline.org/est-sport.html')]
        elif selected=='Ro-Bg TV':
            urls=[('http://www.mytvonline.org/robg-generalist.html'),('http://www.mytvonline.org/robg-news.html'),('http://www.mytvonline.org/robg-divers.html'),('http://www.mytvonline.org/robg-music.html'),('http://www.mytvonline.org/robg-sport.html')]
        elif selected=='Russie-Ukr TV':
            urls=[('http://www.mytvonline.org/rukr-generalist.html'),('http://www.mytvonline.org/rukr-news.html'),('http://www.mytvonline.org/rukr-divers.html'),('http://www.mytvonline.org/rukr-music.html'),('http://www.mytvonline.org/rukr-sport.html')]
        elif selected=='Balkan TV':
            urls=[('http://www.mytvonline.org/yu-generalist.html'),('http://www.mytvonline.org/yu-news.html'),('http://www.mytvonline.org/yu-divers.html'),('http://www.mytvonline.org/yu-music.html'),('http://www.mytvonline.org/yu-sport.html')]
        elif selected=='Holland TV':
            urls=[('http://www.mytvonline.org/nl-generalist.html'),('http://www.mytvonline.org/nl-news.html'),('http://www.mytvonline.org/nl-divers.html'),('http://www.mytvonline.org/nl-music.html'),('http://www.mytvonline.org/nl-sport.html')]
        elif selected=='Italia TV':
            urls=[('http://www.mytvonline.org/it-generalist.html'),('http://www.mytvonline.org/it-news.html'),('http://www.mytvonline.org/it-divers.html'),('http://www.mytvonline.org/it-music.html'),('http://www.mytvonline.org/it-sport.html')]
        elif selected=='Nordic TV':
            urls=[('http://www.mytvonline.org/nord-generalist.html'),('http://www.mytvonline.org/nord-news.html'),('http://www.mytvonline.org/nord-divers.html'),('http://www.mytvonline.org/nord-music.html'),('http://www.mytvonline.org/nord-sport.html')]
        elif selected=='Iran TV':
            urls=[('http://www.mytvonline.org/iran-generalist.html'),('http://www.mytvonline.org/iran-news.html'),('http://www.mytvonline.org/iran-divers.html'),('http://www.mytvonline.org/iran-music.html'),('http://www.mytvonline.org/iran-sport.html')]

        for url in urls:
            getPage(url, timeout=15, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_channels) 
			

    def get_channels(self,data):
        print data
        channels=re.findall('onclick="window\.open\(\'(.*?)\',\'video1\',\'menubar=.*?<img src="(.*?)" title="(.*?)"',data)
        print channels
        if channels:
            for each in channels:
                url, img, title = each
                self.ch_list.append(show_(title, url, img))
            self['menulist'].l.setList(self.ch_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
            auswahl = self['menulist'].getCurrent()[0][0]
            self['name'].setText(auswahl)
			
			
    def get_m3u8(self,data):
        src=re.findall('source: "(.*?)",',data)
        if src:
            self.play_ch(src[0])
        else:
            src=re.findall('file: "(.*?)",',data)
            if src:
                self.play_ch(src[0])
            else:
                src=re.findall('target="(.*?)" loop=',data)
                if src:
                    self.play_ch(src[0])
			
    def ok(self):
        print self.sel
        if self.sel == '1':
            self.list_urls()
        elif self.sel == '2':
            url = self['menulist'].getCurrent()[0][1]
            print url
            getPage(url, timeout=15, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_m3u8)
			
    def exit(self):
        if self.sel == '2':
            self.list_cat()
        else:
            self.close()

    def play_ch(self, data):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)