# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/flashmoviez.py
from imports import *
from about import *
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image, index):
    res = [(name,
      link,
      image,
      index)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class flashmoviez(Screen):

    def __init__(self, session):
        global old_ref
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_('About'))
        self['blue'] = Label('')
        self['Menu'] = Label('')
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self['title'] = Label('FlashMoviez')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.dir()
        self.info = ''
        self.video_list = []
        old_ref = self.session.nav.getCurrentlyPlayingServiceReference()
        self.onLayoutFinish.append(self.show_cat)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'videos':
            try:
                self.load_poster()
                info = self['menulist'].getCurrent()[0][3]
                self['text'].setText(info)
            except:
                print 'error loading poster'

    def show_cat(self):
        self.info = 'cat'
        self.cat = []
        self.cat_list = [('http://flash-moviez.ucoz.org/publ/alle_moviez/aktuell/2', 'Kinofilme'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/action/3', 'Action'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/abenteuer/4', 'Abenteuer'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/asia_cinema/14', 'Asia'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/bollywood_moviez/12', 'Bollywood'),
         ('http://flash-moviez.ucoz.org/publ/biografie/216', 'Biografie'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/dramaromantik/5', 'Drama / Romantik'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/dokus/11', 'Dokus / Shows'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/englisch/109', 'English'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/familie/215', 'Familie'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/geschichte/212', 'Geschichte'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/horror/6', 'Horror'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/history/213', 'Historie'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/hd_moviez/131', 'HD'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/komodien/7', 'Kom\xc3\xb6die'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/krieg_western/50', 'Krieg / Western'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/klassiker/173', 'Klassiker'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/mystery/214', 'Mystery'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/marchen/206', 'M\xc3\xa4rchen'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/musik/204', 'Musik'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/scifi_fantasy/8', 'SciFi / Fantasy'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/thriller/9', 'Thriller / Crime'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/zeichentrick/10', 'Zeichentrick / Animation'),
         ('http://flash-moviez.ucoz.org/publ/alle_moviez/720p/217', '720p Moviez')]
        for url, title in self.cat_list:
            self.cat.append(cat_(title, url))

        self['menulist'].l.setList(self.cat)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def get_videos(self, data):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        self.info = 'videos'
        block = re.findall('<span class="pagesBlockuz1">(.*?)<td align="right"', data, re.DOTALL)
        last_page = re.findall('onclick="spages\\(\'(.*?)\',\'.*?\',this\\);return false', block[0])
        print last_page
        if last_page:
            max_nr = int(last_page[-2])
        else:
            max_nr = 2
        i = 1
        url = str(selectedEntry)
        for i in range(1, max_nr):
            url = url + '-' + str(i)
            print url
            getPage(url, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Referer': 'http://flash-moviez.ucoz.org/publ/alle_moviez/action/3'}).addCallback(self.get_videos1)
            i += 1
            url = str(selectedEntry)

    def get_videos1(self, data):
        videos = re.findall('<div class="viewn_pict">.*?<a href="(.*?)" title="(.*?)" onmouseover="Tip\\(\'<img alt=.*?src=.*?<img src="(.*?)" width="..." border="0"></a>.*?<div class="viewn_text">(.*?)</div>', data, re.DOTALL)
        if videos:
            for url, title, img, info in videos:
                url='http://flash-moviez.ucoz.org'+url
                self.video_list.append(show_(title, url, img, info))

            self['menulist'].l.setList(self.video_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
            auswahl = self['menulist'].getCurrent()[0][0]
            self['name'].setText(auswahl)
            info = self['menulist'].getCurrent()[0][3]
            self['text'].setText(info)

    def get_link(self, data):
        link = re.findall('<a target="_blank" href=".*?(http://streamcloud.eu/.*?.html)', data, re.DOTALL)
        print link
        if link:
            getPage(link[0], timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Host': 'streamcloud.eu',
             'Referer': 'http://kinoger.com/main/2562-ted-2-2015.html'}).addCallback(self.get_hls)

    def get_hls(self, data):
        print data
        id = re.findall('<input type="hidden" name="id".*?value="(.*?)">', data)
        fname = re.findall('<input type="hidden" name="fname".*?alue="(.*?)">', data)
        hash = re.findall('<input type="hidden" name="hash" value="(.*?)">', data)
        if id and fname and hash:
            url = 'http://streamcloud.eu/%s' % id[0]
            post_data = urllib.urlencode({'op': 'download2',
             'usr_login': '',
             'id': id[0],
             'fname': fname[0],
             'referer': '',
             'hash': hash[0],
             'imhuman': 'Weiter+zum+Video'})
            getPage(url, method='POST', postdata=post_data, headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_hls1)

    def get_hls1(self, data):
        print data
        file = re.findall('file: "(.+?)",', data)
        print file
        if file:
            self.play_vid(file[0])

    def play_vid(self, data):
        self.info = 'player'
        if data:
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            sref = eServiceReference(4097, 0, data)
            sref.setName(selectedName)
            self.session.nav.playService(sref)
            self.hide()

    def ok(self):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        if self.info == 'cat':
            url = str(selectedEntry)
            getPage(url, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Content-Type': 'application/x-www-form-urlencoded',
             'Referer': 'http://flash-moviez.ucoz.org/publ/alle_moviez/action/3'}).addCallback(self.get_videos)
        elif self.info == 'videos':
            url = str(selectedEntry)
            getPage(url, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.get_link)

    def exit(self):
        print self.info
        if self.info == 'cat':
            self.close()
        elif self.info == 'videos':
            self.info = 'cat'
            self['menulist'].l.setList(self.cat)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'player':
            self.show()
            self.session.nav.playService(old_ref)
            self.info = 'videos'
            self['menulist'].l.setList(self.video_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
            self.load_poster()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/hayyes_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/hayyes/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[hayyes] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[hayyes] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/hayyes/'):
            os.system('mkdir /tmp/hayyes/')
        else:
            print '[hayyes] /tmp/hayyes/ allready present'