# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/bein_schedule.py
from imports import *
from Tools.Directories import fileExists, pathExists

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 26), font=4, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class bein_sports(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self['title'] = Label('BeinSports - Schedule')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.content_list = []
        self.onLayoutFinish.append(self.bein_sports_schedule)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        self[self.currentList].up()

    def down(self):
        self[self.currentList].down()

    def left(self):
        self[self.currentList].pageUp()

    def right(self):
        self[self.currentList].pageDown()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def exit(self):
        self.close()

    def bein_sports_schedule(self):
        self.schedule_list = []
        url = 'http://www.beinsports.com/en/tv-guide/176111452/website_mena_english/tv_guide'
        req = urllib2.Request(url)
        req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36')
        req.add_header('Host', 'www.beinsports.com')
        req.add_header('Connection', 'keep-alive')
        req.add_header('Cache-Control', 'max-age=0')
        req.add_header('Accept', 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8')
        page = urllib2.urlopen(req)
        response = page.read()
        page.close()
        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-1hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/1.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD1 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/1.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-2hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/2.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD2 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/2.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-3hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/3.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD3 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/3.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-4hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/4.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD4 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/4.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-5hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/5.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD5 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/5.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-6hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/6.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD6 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/6.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-7hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/7.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD7 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/7.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-8hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/8.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD8 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/8.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-9hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/9.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD9 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/9.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-10hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/10.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD10 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/10.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-11hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/11.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD11 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/11.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-12hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/12.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD12 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/12.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-13hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/13.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD13 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/13.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-14hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/14.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD14 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/14.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-15hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/15.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD15 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/15.ts'
            self.schedule_list.append(cat_(info, url))

        channel_section = re.findall('<div class="gr-0_5 cell-channel mobile-view channels ch-16hd"><img src="/i/beINSport/site/COM/perf-console/channel_logos_2014/with-background/16.png" alt="(.*?)hd" /></div>(.*?)</section>', response, re.DOTALL)
        matches = re.findall('<div class="single-epg-event" title="(.*?)"><span class="event-title">.*?</span>.*?<time  class="nodate" datetime="(.*?)".*?>(.*?)</time>', str(channel_section), re.DOTALL)
        for each in matches:
            title, date, time = each
            title = str(title).replace('<b>', ' ').replace('</b>', ' ')
            info = str(time) + 'HD16 : ' + title
            url = 'http://188.40.104.66:8000/live/AS3/HTT111oikiloilu/16.ts'
            self.schedule_list.append(cat_(info, url))

        self['menulist'].l.setList(self.schedule_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def play_that_shit(self, data, name):
        sref = eServiceReference(4097, 0, data)
        sref.setName(name)
        self.session.open(MoviePlayer, sref)

    def ok(self):
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        uri = selectedEntry
        self.play_that_shit(uri, selectedName)


def main(session, **kwargs):
    session.open(bein_sports)


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    return [PluginDescriptor(name='BeinSports', description='BeinSports Streamer', where=[PluginDescriptor.WHERE_PLUGINMENU], fnc=main, icon='plugin.png')]