﻿# -*- coding: utf-8 -*-
#
# Copyright (C) 2011 by Coolman & Swiss-MAD
#
# In case of reuse of this source code please do not remove this copyright.
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	For more information on the GNU General Public License see:
#	<http://www.gnu.org/licenses/>.
#

from operator import isCallable
from enigma import eTimer

instanceTab = []

class DelayedFunction:
	def __init__(self, delay, function, *params):
		try:
			if isCallable(function):
				global instanceTab
				instanceTab.append(self)
				self.function = function
				self.params = params
				self.timer = None
				self.timer = eTimer()
				self.timer_conn = None
				try:
					self.timer_conn = self.timer.timeout.connect(self.timerLaunch)
				except:
					self.timer.timeout.get().append(self.timerLaunch)
				self.timer.start(delay, False)
		except Exception, e:
			pass

	def cancel(self):
		try:
			global instanceTab
			instanceTab.remove(self)
			self.timer.stop()
			try:
				self.timer_conn = None
			except:
				self.timer.timeout.get().remove(self.timerLaunch)
			self.timer = None
		except Exception, e:
			pass

	def timerLaunch(self):
		try:
			global instanceTab
			instanceTab.remove(self)
			self.timer.stop()
			try:
				self.timer_conn = None
			except:
				self.timer.timeout.get().remove(self.timerLaunch)
			self.timer = None
			self.function(*self.params)
		except Exception, e:
			pass

	def exists(self):
		global instanceTab
		try:
			i = instanceTab.index(self)
		except ValueError:
			i = -1
		if i < 0:
			return False
		else:
			return True