from setup import *
from imports import *

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def cat_(letter, link, path):
    res = [(letter, link, path)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class tvnanet(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['text'] = Label('')
        self['poster'] = Pixmap()
        self['title'] = Label('tvnanet.biz')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.onLayoutFinish.append(self.abc)

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def abc(self):
        self.loading_ok = False
        self.check = 'abc'
        self.currentList = 'menulist'
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.genre_name = 'Al Cinema'
        self.load_data_channels()

    def load_data_channels(self):
        self.letter_list = []
        tvnanet_list = [('GLOBO SP','http://ekostreams.co/ch/bobo.php?width=600&height=384'),
        ('GLOBO RBS','http://ekostreams.co/ch/bobo_rbs.php?width=600&height=384'),
        ('GLOBO MG','http://ekostreams.co/ch/boboms.php?width=600&height=384'),
        ('SBT','http://ekostreams.co/ch/sbt.php?width=600&height=384'),
        ('RECORD','http://ekostreams.co/ch/record.php?width=600&height=384'),
        ('BAND','http://ekostreams.co/ch/band.php?width=600&height=384'),
        ('SPORTVHD','http://ekostreams.co/ch/sportvhd.php?width=600&height=384'),
        ('SPORTV2','http://ekostreams.co/ch/sportv2.php?width=600&height=384'),
        ('SPORTV3','http://ekostreams.co/ch/sportv3.php?width=600&height=384'),
        ('ESPN BRASIL','http://ekostreams.co/ch/espnbrasil.php?width=600&height=384'),
        ('ESPN','http://ekostreams.co/ch/espn.php?width=600&height=384'),
        ('FOXSPORTS','http://ekostreams.co/ch/foxsports.php?width=600&height=384'),
        ('FOXSPORTS2','http://ekostreams.co/ch/foxsports2.php?width=600&height=384'),
        ('COMBATE','http://ekostreams.co/ch/combate.php?width=600&height=384')]

        for each in tvnanet_list:
            title, url,  = each
            self.letter_list.append(cat_(title, url, None))
        self['menulist'].l.setList(self.letter_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def ok(self):
        if self.check == 'abc':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            self.loading_ok = False
            uri = selectedEntry
            getPage(uri, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.103 Safari/537.36',
             'Referer': 'http://ekostreams.co',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.read_link)

    def read_link(self, data):
        livecast_page = re.findall('<iframe src="(http://pxstream.tv/embed/.*?)" name="Player"', data)
        print livecast_page
        if livecast_page:
            getPage(livecast_page[0], timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.103 Safari/537.36',
             'Referer': 'http://ekostreams.co',
             'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.lc_link)

    def lc_link(self, data):
        print data
        hls = re.findall('source: "(.*?)",', data)
        if hls:
            location = urllib2.urlopen(hls[0])
            hls=location.geturl()
            play='http://127.0.0.1:88/hlsvariant://'+hls+' headers={"User-agent":"stagefright"}'
            print hls
            self.play_that_shit(play)

    def play_that_shit(self, data):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later on'), MessageBox.TYPE_INFO, timeout=3)

    def errorload2(self, error):
        print '[glarab] error %s' % error
        count_movies = len(self.letter_movielist)
        self.loading_ok = True
        self.loading = 0
        self.count = 0

    def errorload(self, error):
        print error


def main(session, **kwargs):
    session.open(glwiz)