# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/hungarian_iptv.py
from imports import *
from about import *
from StringIO import StringIO
import gzip
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'
cj = {}

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class hungarian(Screen):

    def __init__(self, session):
        global old_ref
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit,
         'blue': self.dnitnow}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_('About'))
        self['blue'] = Label('')
        self['Menu'] = Label('')
        self['text'] = Label('')
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self['title'] = Label('Hungary IPTV')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        old_ref = self.session.nav.getCurrentlyPlayingServiceReference()
        self.onLayoutFinish.append(self.list_cat)

    def about(self):
        self.session.open(AboutScreen)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

        elif self.info == 'list_channels':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

        elif self.info == 'list_channels':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_shows':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

        elif self.info == 'list_cat':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

        elif self.info == 'list_episodes':
            try:
                self.load_poster()
            except:
                print 'error loading poster'

    def list_cat(self):
        self.info = 'list_cat'
        self.cat_list = []
        cat = [('http://212.40.98.162/intstreams/mtva/mtv1live.smil/chunklist_w953311020_b3300000.m3u8', 'M1', 'http://www.tv-logo.com/pt-data/uploads/images/logo/magyar_tv1_hd.jpg'),
         ('http://212.40.98.162/intstreams/mtva/mtv2live.smil/playlist.m3u8', 'M2', 'http://www.tv-logo.com/pt-data/uploads/images/logo/magyar_tv2_hd.jpg'),
         ('http://85.25.43.23:8080/hls/jhdalsjhd344.m3u8', 'RTL klub', 'http://www.tv-logo.com/pt-data/uploads/images/logo/rtl_klub.jpg'),
         ('http://212.40.98.162/intstreams/mtva/dunalive.smil/playlist.m3u8', 'Duna TV', 'http://www.tv-logo.com/pt-data/uploads/images/logo/duna_tv_hd.jpg'),
         ('http://109.199.58.6/1VoZ0JgEJNSXjI3zuZYAG5kQ-1pmVPtMnsNY=/9186/VID_854x480_HUN.m3u8', 'Duna World', 'http://www.lyngsat-logo.com/logo/tv/dd/duna_world_hd.png'),
         ('http://212.40.98.162/intstreams/mtva/mtv4live.smil/chunklist_w163884905_b3300000.m3u8', 'M4 Sport', 'http://'),
         ('http://stream.1music.hu/stream/1music.m3u8', '1 Music Channel Hungary', 'http://www.lyngsat-logo.com/logo/tv/num/1music_channel_hu.png'),
         ('rtmp://195.228.75.100/atvliveedge/_definst_/atvstream_2_aac', 'ATV+1', 'http://www.lyngsat-logo.com/logo/tv/mm/magyar_atv_plus1.png'),
         ('rtmp://95.140.34.51:8010/live/live', 'Eger TV', 'http://www.lyngsat-logo.com/logo/tv/ee/eger_tv_hu.png'),
         ('rtmp://195.56.44.163:1935/live/mitv', 'Miskolc TV', 'http://www.lyngsat-logo.com/logo/tv/mm/miskolc_tv_hu.png'),
         ('http://streamserver.mno.netrix.hu/hls_delayed/live_ep_512k.m3u8', 'H\xc3\xadr TV +1', 'http://www.lyngsat-logo.com/logo/tv/hh/hir_tv_plus1.png'),
         ('rtmp://video.fixhd.tv/fix/hd.stream', 'Fix Tv', 'http://www.tv-logo.com/pt-data/uploads/images/logo/fix_hd_hu.jpg'),
         ('rtmp;//217.113.62.243:1935/live/live', 'Alf\xc3\xb6ld Tv', 'http://www.tv-logo.com/pt-data/uploads/images/logo/alfold_tv_hu.jpg'),
         ('rtmp://91.82.85.44:1935/live/konyhatv', 'Konyha TV', 'http://'),
         ('rtmp://91.82.85.44:1935/liveios851739io/_definst_/bptv.sdp', 'Budapest Tv', 'http://www.tv-logo.com/pt-data/uploads/images/logo/budapest_europa_televizio.jpg'),
         ('rtmp://79.120.178.90:1935/williams/williamstv', 'Williems Tv', 'http://www.lyngsat-logo.com/hires/ww/williams_tv_hu.png'),
         ('http://www.tiszatv.hu:443/tiszatv.f4v', 'Tisza Tv', 'http://www.lyngsat-logo.com/logo/tv/tt/tisza_tv_hu.png')]
        for each in cat:
            url, title, img = each
            self.cat_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        self.load_poster()

    def list_channels(self, data):
        print data
        self.info = 'list_channels'
        self.show_list = []
        iframe = re.findall("<iframe.*?FRAMEBORDER.*?src='(.*?)' height=", data)
        print iframe
        if iframe:
            getPage(iframe[0], timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36'}).addCallback(self.get_link)
        else:
            link = re.findall('<param name="src" value="(.*?)"/>', data)
            if link:
                self.play_movie(link[0])

    def get_link(self, data):
        print data
        link = re.findall("'file': '(.*?)'", data)
        print link
        if link:
            self.play_movie(link[0])

    def get_ultracast_link(self, data):
        print data
        link = re.findall("file: '(.*?)',", data)
        print link
        if link:
            self.play_movie(link[0])
        else:
            link = re.findall('file:"(.*?)"\\}', data)
            print link
            if link:
                self.play_movie(link[0])

    def play_movie(self, link):
        self.info = 'player'
        if link:
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            sref = eServiceReference(4097, 0, link)
            sref.setName(selectedName)
            self.session.nav.playService(sref)
            self.hide()

    def ok(self):
        cj = {}
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        if self.info == 'list_cat':
            url = str(selectedEntry)
            self.play_movie(url)
        elif self.info == 'list_channels':
            url = str(selectedEntry)
            getPage(url, timeout=8, method='GET', headers={'Host': 'bratu-marian.ro',
             'Referer': 'http://bratu-marian.ro/channel-1/',
             'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36'}).addCallback(self.get_link)
        elif self.info == 'list_live':
            url = str(selectedEntry)
            getPage(url, timeout=8, method='GET', headers={'Host': 'bratu-marian.ro',
             'Referer': 'http://bratu-marian.ro/channel-1/',
             'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36'}).addCallback(self.get_link)

    def exit(self):
        print self.info
        if re.match('(list_cat)', self.info, re.S | re.I):
            if fileExists('/tmp/hayyes_poster.jpg'):
                os.system('rm -r /tmp/hayyes_poster.jpg')
            self.close(self.session, 'exit')
        elif self.info == 'list_channels':
            self.close()
        elif self.info == 'list_episodes':
            self.info = 'list_shows'
            self['menulist'].l.setList(self.show_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'list_streams':
            self.info = 'list_episodes'
            self['blue'].hide()
            self['menulist'].l.setList(self.episodes_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'player':
            self.show()
            self.session.nav.playService(old_ref)
            self.info = 'list_cat'
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
        elif self.info == 'list_live':
            self.info = 'list_cat'
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/hayyes_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/hayyes/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[hayyes] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[hayyes] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/hayyes/'):
            os.system('mkdir /tmp/hayyes/')
        else:
            print '[hayyes] /tmp/hayyes/ allready present'


class unwise():

    def worker(self, str_eval):
        page_value = ''
        try:
            ss = 'w,i,s,e=(' + str_eval + ')'
            exec ss
            page_value = self.__unwise(w, i, s, e)
        except:
            return

        return page_value

    def __unwise(self, w, i, s, e):
        lIll = 0
        ll1I = 0
        Il1l = 0
        ll1l = []
        l1lI = []
        while True:
            if lIll < 5:
                l1lI.append(w[lIll])
            elif lIll < len(w):
                ll1l.append(w[lIll])
            lIll += 1
            if ll1I < 5:
                l1lI.append(i[ll1I])
            elif ll1I < len(i):
                ll1l.append(i[ll1I])
            ll1I += 1
            if Il1l < 5:
                l1lI.append(s[Il1l])
            elif Il1l < len(s):
                ll1l.append(s[Il1l])
            Il1l += 1
            if len(w) + len(i) + len(s) + len(e) == len(ll1l) + len(l1lI) + len(e):
                break

        lI1l = ''.join(ll1l)
        I1lI = ''.join(l1lI)
        ll1I = 0
        l1ll = []
        for lIll in range(0, len(ll1l), 2):
            ll11 = -1
            if ord(I1lI[ll1I]) % 2:
                ll11 = 1
            l1ll.append(chr(int(lI1l[lIll:lIll + 2], 36) - ll11))
            ll1I += 1
            if ll1I >= len(l1lI):
                ll1I = 0

        ret = ''.join(l1ll)
        if 'eval(function(w,i,s,e)' in ret:
            ret = re.compile('eval\\(function\\(w,i,s,e\\).*}\\((.*?)\\)').findall(ret)[0]
            return self.worker(ret)
        else:
            return ret