#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

if [ -f /etc/enigma2/bootlogo.mvi ]; then
		echo found /etc/enigma2/bootlogo.mvi
		/usr/bin/showiframe /etc/enigma2/bootlogo.mvi
	elif [ -f /usr/share/bootlogo.mvi ]; then
		echo found /usr/share/bootlogo.mvi
		/usr/bin/showiframe /usr/share/bootlogo.mvi
fi

# workaround for corrupt ssl files
if ! grep ^config.misc.firstrun=false /etc/enigma2/settings >/dev/null; then
	rm -rf /etc/enigma2/cert.pem &
	rm -rf /etc/enigma2/key.pem &
fi

# update NTP time if NTP Time Enabled
if grep ^config.misc.SyncTimeUsing=1 /etc/enigma2/settings >/dev/null; then
	/usr/sbin/ntpdate -s -u pool.ntp.org &
fi

#check for installed vfdcontrol
if [ -e /usr/lib/enigma2/python/Plugins/SystemPlugins/VFDControl/plugin.pyo ]; then
	opkg remove enigma2-plugin-systemplugins-vfdcontrol
	rm -rf /usr/lib/enigma2/python/Plugins/SystemPlugins/VFDControl
fi

[ -L /usr/lib/libssl.so.0.9.8 ] || ln -s /usr/lib/libssl.so.1.0.0 /usr/lib/libssl.so.0.9.8

[ -L /usr/lib/libcrypto.so.0.9.8 ] || ln -s /usr/lib/libcrypto.so.1.0.0 /usr/lib/libcrypto.so.0.9.8

# check if media/net directory exists
[ -d /media/net ] || mkdir /media/net

# check if usr/scripts directory exists
[ -d /usr/scripts ] || mkdir /usr/scripts
chmod -R 755 /usr/scripts

# check for settings files
[ -f /etc/enigma2/settings ] || cp /usr/share/enigma2/defaults/* /etc/enigma2/

# check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

#check for specific pagecache helper lib
if [ -e /usr/lib/libpagecache.so ]; then
	LIBS="$LIBS /usr/lib/libpagecache.so"
fi

#check for receiver specific passthrough helper lib
if [ -e /usr/lib/libpassthrough.so ]; then
	LIBS="$LIBS /usr/lib/libpassthrough.so"
fi

touch /etc/enigma2/settings

# hook to execute scripts always before enigma2 start
[ -x /usr/bin/enigma2_pre_start.sh ] && /usr/bin/enigma2_pre_start.sh
[ -x /usr/bin/enigma2_pre_start_ciplus.sh ] && /usr/bin/enigma2_pre_start_ciplus.sh

sync
sysctl -p

if [ -d /home/root ]; then
	cd /home/root
	export HOME=/home/root
fi

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
        [ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

if [ "$(grep config.crash.enabledebug /etc/enigma2/settings)" == "config.crash.enabledebug=true" ]; then
	RANDOMIZE1970=''
	time=`date +%Y` ;
	if [ "$time" = 1970 ]; then
		RANDOMIZE1970="$(strings /dev/urandom | grep -o '[[:alnum:]]' | head -n 5 | tr -d '\n')"
	fi
		CONFIG_CRASH_DEBUG_PATH=$(grep ^config.crash.debug_path= /etc/enigma2/settings | cut -f2 -d=)
	if [ -z $CONFIG_CRASH_DEBUG_PATH ]; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2 --debug-no-color &> /home/root/logs/Enigma2-debug-$(date +%Y%m%d_%H-%M-%S)$RANDOMIZE1970.log
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2 --debug-no-color &> ${CONFIG_CRASH_DEBUG_PATH}Enigma2-debug-$(date +%Y%m%d_%H-%M-%S)$RANDOMIZE1970.log		
	fi
else
	# in case $TERM is "linux" the serial output is activated - discard debug output
	if [ "$TERM" = linux ]; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2 2> /dev/null
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2
	fi
fi

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal

ret=$?
case $ret in
	1)
		/sbin/halt
		;;
	2)
		if [ -f /proc/stb/fp/force_restart ]; then
			echo 1 > /proc/stb/fp/force_restart
		fi
		/sbin/reboot
		;;
	3)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	4)
		/sbin/rmmod lcd
		/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
		sleep 1;
		/sbin/rmmod fp
		/sbin/modprobe fp
		/sbin/reboot
		;;
	9)
		sed -i '/config.plugins.configurationbackup.backupdirs/d' /etc/enigma2/settings
		;;
	16)
		echo "rescue" > /proc/stb/fp/boot_mode
		/sbin/reboot
		;;
	42)
		python /usr/lib/enigma2/python/upgrade.pyo
		;;
	43)
		init 1
		;;
	44)
		# little hack but it will be fixed soon in drivers
		/usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/bin/fbclear
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/wait.mvi
		echo fpupload >/proc/vfd && sleep 3 && dd bs=256k if=/tmp/micom.bin of=/dev/mcu
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/reboot.mvi
		# Wait forever for the user to power off
		while(true) ; do sleep 60 ; done
		;;
	45)
		echo "    " > /dev/lcd0
		/usr/bin/gigablue_wol
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
