# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/thaisports.py
from setup import *
from imports import *
cj = {}

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, img):
    res = [(name, link, img)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show3_(name, link, img, id):
    res = [(name,
      link,
      img,
      id)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class thaisports(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('thaisports')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.abc)

    def about(self):
        self.session.open(AboutScreen)

    def jobix(self):
        if JobManagerInstalled:
            self.session.open(JobManagerFrontEnd)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]
            self.get_play_link(self.filmname, link)

    def up(self):
        self[self.currentList].up()
        self.load_poster()

    def down(self):
        self[self.currentList].down()
        self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        self.load_poster()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def abc(self):
        self.loading_ok = False
        self.check = 'abc'
        self.currentList = 'menulist'
        self.letter_movielist = []
        self['menulist'].selectionEnabled(1)
        self['menulist'].show()
        self.genre_name = 'Al Cinema'
        self.load_data_channels()

    def load_data_channels(self):
        self.index = '1'
        self.letter_list = []
        thaisports_list = [('CTH Stadium 1 HD', 'http://www.khaozap.com/wp-content/uploads/2015/04/64.jpg', 'http://khaozap.com/wp/sport/cth1.php'),
         ('CTH Stadium 2 HD', 'http://www.khaozap.com/wp-content/uploads/2015/04/Stadium2.jpg', 'http://khaozap.com/wp/sport/cth2.php'),
         ('CTH Stadium 3 HD', 'http://www.khaozap.com/wp-content/uploads/2015/04/72.jpg', 'http://khaozap.com/wp/sport/cth3.php'),
         ('CTH Stadium 4 HD', 'http://www.khaozap.com/wp-content/uploads/2015/04/73.jpg', 'http://khaozap.com/wp/sport/cth4.php'),
         ('CTH Stadium 5 HD', 'http://www.khaozap.com/wp-content/uploads/2015/05/74.jpg', 'http://khaozap.com/wp/sport/cth5.php'),
         ('CTH Stadium 6 HD', 'http://www.khaozap.com/wp-content/uploads/2015/12/Stadium6.jpg', 'www.khaozap.com/\xe0\xb8\x94\xe0\xb8\xb9\xe0\xb8\x9a\xe0\xb8\xad\xe0\xb8\xa5\xe0\xb8\xad\xe0\xb8\xad\xe0\xb8\x99\xe0\xb9\x84\xe0\xb8\xa5\xe0\xb8\x99\xe0\xb9\x8c/\xe0\xb8\x94\xe0\xb8\xb9\xe0\xb8\x9a\xe0\xb8\xad\xe0\xb8\xa5\xe0\xb8\xad\xe0\xb8\xad\xe0\xb8\x99\xe0\xb9\x84\xe0\xb8\xa5\xe0\xb8\x99\xe0\xb9\x8c\xe0\xb8\x8a\xe0\xb9\x88\xe0\xb8\xad\xe0\xb8\x87-cth-stadium-6-hd/'),
         ('CTH Stadium X HD', 'http://www.khaozap.com/wp-content/uploads/2015/12/stadiumx.png', 'www.khaozap.com/\xe0\xb8\x94\xe0\xb8\xb9\xe0\xb8\x9a\xe0\xb8\xad\xe0\xb8\xa5\xe0\xb8\xad\xe0\xb8\xad\xe0\xb8\x99\xe0\xb9\x84\xe0\xb8\xa5\xe0\xb8\x99\xe0\xb9\x8c/\xe0\xb8\x94\xe0\xb8\xb9\xe0\xb8\x9a\xe0\xb8\xad\xe0\xb8\xa5\xe0\xb8\xad\xe0\xb8\xad\xe0\xb8\x99\xe0\xb9\x84\xe0\xb8\xa5\xe0\xb8\x99\xe0\xb9\x8c\xe0\xb8\x8a\xe0\xb9\x88\xe0\xb8\xad\xe0\xb8\x87-cth-stadium-x-hd/'),
         ('True Sport HD', 'http://www.khaozap.com/wp-content/uploads/2015/09/18.jpg', 'http://khaozap.com/wp/sport/thd1.php'),
         ('True Sport HD2', 'http://www.khaozap.com/wp-content/uploads/2015/09/18.jpg', 'http://khaozap.com/wp/sport/thd2.php'),
         ('True Sport HD3', 'http://www.khaozap.com/wp-content/uploads/2015/04/18.jpg', 'http://khaozap.com/wp/sport/thd3.php'),
         ('True Sport 1', 'http://www.khaozap.com/wp-content/uploads/2016/02/truesport1.jpg', 'http://khaozap.com/wp/sport/tsp1.php'),
         ('True Sport 2', 'http://www.khaozap.com/wp-content/uploads/2016/02/Truesport2.jpg', 'http://khaozap.com/wp/sport/tsp2.php'),
         ('True Sport 3', 'http://www.khaozap.com/wp-content/uploads/2015/04/110.jpg', 'http://khaozap.com/wp/sport/tsp3.php'),
         ('True Sport 5', 'http://www.khaozap.com/wp-content/uploads/2016/02/111.jpg', 'http://khaozap.com/wp/sport/tsp5.php'),
         ('True Sport 6', 'http://www.khaozap.com/wp-content/uploads/2016/02/TRUE-SPORT-6-live.gif', 'http://khaozap.com/wp/sport/tsp6.php'),
         ('True Sport 7', 'http://www.khaozap.com/wp-content/uploads/2016/02/true7.jpg', 'http://khaozap.com/wp/sport/tsp7.php'),
         ('beIN Sports', 'http://www.khaozap.com/wp-content/uploads/2015/09/unnamed.png', 'http://khaozap.com/wp/sport/beinsport.php'),
         ('Fox Sport HD', 'http://www.khaozap.com/wp-content/uploads/2015/09/832_300.png', 'http://khaozap.com/wp/sport/foxsport.php'),
         ('Fox Sport 2', 'http://www.khaozap.com/wp-content/uploads/2015/09/Fox_Sports_2_logo.png', 'http://khaozap.com/wp/sport/foxsport2.php'),
         ('Fox Sport 3', 'http://www.khaozap.com/wp-content/uploads/2015/09/FOX-Sports-3-En-vivo-por-Internet.png', 'http://khaozap.com/wp/sport/foxsport3.php'),
         ('NBA TV', 'http://www.khaozap.com/wp-content/uploads/2015/12/NBA_TV.svg_.png', 'http://khaozap.com/wp/sport/nba.php'),
         ('Golf Channel Thailand HD', 'http://www.khaozap.com/wp-content/uploads/2016/02/1415095824.jpg', 'http://khaozap.com/wp/sport/golfch.php'),
         ('True Tennis HD', 'http://www.khaozap.com/wp-content/uploads/2016/02/138.jpg', 'http://khaozap.com/wp/sport/truetennis.php')]
        for each in thaisports_list:
            title, img, url = each
            self.letter_list.append(show_(title, url, img))

        self['menulist'].l.setList(self.letter_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()

    def get_hls(self, url):
        print url
        if 'http://' in url:
            url = url
        else:
            url = 'http://' + url
        getPage(url, timeout=8, method='GET', cookies=cj, headers={'Host': 'khaozap.com',
         'Referer': 'http://www.khaozap.com/%e0%b8%94%e0%b8%b9%e0%b8%9a%e0%b8%ad%e0%b8%a5%e0%b8%ad%e0%b8%ad%e0%b8%99%e0%b9%84%e0%b8%a5%e0%b8%99%e0%b9%8c/%e0%b8%94%e0%b8%b9%e0%b8%9a%e0%b8%ad%e0%b8%a5%e0%b8%ad%e0%b8%ad%e0%b8%99%e0%b9%84%e0%b8%a5%e0%b8%99%e0%b9%8c%e0%b8%8a%e0%b9%88%e0%b8%ad%e0%b8%87-cth-stadium-1-hd/',
         'User-Agent': 'Mozilla/5.0 (Linux; U; Android 4.3; en-us; SM-N900T Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30',
         'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.play_that_shit)

    def ok(self):
        final_uri = self['menulist'].l.getCurrentSelection()[0][1]
        self.get_hls(final_uri)

    def play_that_shit(self, data):
        print data
        selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        hls_link = re.findall("file: '(.*?)',", data)
        print hls_link
        if hls_link:
            self.play_that_shit1(hls_link[0])

    def play_that_shit1(self, data):
        selectedName = self['menulist'].l.getCurrentSelection()[0][0]
        fin_uri = 'http://127.0.0.1:88/hlsvariant://' + data + ' headers={"Host":"livesg.khaozap.com:1935","Referer":"http://khaozap.com/wp/sport/truetennis.php","User-Agent":"Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.103 Safari/537.36","X-Requested-With":"ShockwaveFlash/20.0.0.286"}'
        sref = eServiceReference(4097, 0, fin_uri)
        sref.setName(selectedName)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/teledunet_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/teledunet/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[teledunet] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[teledunet] no cover.. error'
        return

    def stream_not_found(self):
        message = self.session.open(MessageBox, _('Stream not found, try again later on'), MessageBox.TYPE_INFO, timeout=3)

    def errorload2(self, error):
        print '[teledunet] error %s' % error
        count_movies = len(self.letter_movielist)
        self.loading_ok = True
        self.loading = 0
        self.count = 0

    def errorload(self, error):
        print error

    def dir(self):
        if not pathExists('/tmp/teledunet/'):
            os.system('mkdir /tmp/teledunet/')
        else:
            print '[teledunet] /tmp/teledunet/ allready present'