from setup import *
from imports import *
import requests

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def cat_(name, link):
    res = [(name, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res

class streamm(Screen):

    def __init__(self, session):
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        self.session = session
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'red': self.exit,
         'cancel': self.exit}, -1)
        self['menulist'] = m2list([])
        self['poster'] = Pixmap()
        self['title'] = Label('Streamm.eu')
        self['text'] = Label('')
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = ''
        self.count = 0
        self.loading = 0
        self.onLayoutFinish.append(self.get_matches)

    def about(self):
        self.session.open(AboutScreen)

    def up(self):
        self[self.currentList].up()

    def down(self):
        self[self.currentList].down()

    def left(self):
        self[self.currentList].pageUp()

    def right(self):
        self[self.currentList].pageDown()

    def switchList(self):
        if self.currentList == 'menulist':
            self['ButtonBlue'].hide()
            self['TextBlue'].hide()
            self['menulist'].selectionEnabled(0)
            self.currentList = 'menulist2'
            self.check = 'abc'
        else:
            self['ButtonBlue'].show()
            self['TextBlue'].show()
            self['menulist'].selectionEnabled(1)
            self.currentList = 'menulist'
            self.check = 'letter_movie'

    def get_matches(self):
        self.check='matches'
        self.m_list=[]
        url='http://streamm.eu/livesports.html'
        try:
            data=requests.get(url).text
        except:
            data=''
        matches=re.findall('<div class="row">.*?<img src=".*?" alt="(.*?)" width="30" height="30">.*?alt="(.*?)" width="30" height="30">.*?<a href="(.*?)" class="btn',data,re.DOTALL)
        if matches:
            for (team1,team2,url) in matches:
                title=str(team1)+' : '+str(team2)
                url='http://streamm.eu/'+str(url)				
                self.m_list.append(cat_(title,url))	
            self['menulist'].l.setList(self.m_list)
            self['menulist'].l.setItemHeight(40)
            self['menulist'].moveToIndex(0)
			
    def ok(self):
        if self.check=='matches':
            uri = self['menulist'].l.getCurrentSelection()[0][1]
            self.get_lnk(uri)

    def get_lnk(self,url):
        try:
            data=requests.get(url).text
        except:
            data=''	
        print 'data : ' ,data#<iframe src="http://streamm.eu/embed/hd2.html" 
        src=re.findall('iframe src="(.*?)"',data)
        if src:
            lnk=requests.get(src[0]).text
            if lnk:
                code=re.findall('str=\'(.*?)\'; document',lnk)
                if code:
                    code=code[0].replace('@','%')
                    code=urllib.unquote(code)
                    hls=re.findall('hls: \'(.*?)\'',code)
                    if hls:
                        self.play_that_shit(str(hls[0]))
            else:
                n_lnk=re.findall('src="(.*?eu/.*?)"',lnk)
                lnk=requests.get(n_lnk[0]).text
                hls=re.findall('hls: \'(.*?)\'',lnk)
                if hls:
                    self.play_that_shit(str(hls[0]))
				
    def play_that_shit(self, data):
        title=self['menulist'].l.getCurrentSelection()[0][0]
        sref = eServiceReference(4097, 0, data)
        sref.setName(title)
        self.session.open(MoviePlayer, sref)

    def exit(self):
        self.close()


