# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/newspaper.py
from imports import *
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def show_news(news):
    res = [news]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=6, text=news, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class newspaper(Screen):

    def __init__(self, session):
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit,
         'blue': self.dnitnow}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['text'] = Label('')
        self['name'] = Label('')
        self['poster'] = Pixmap()
        self['title'] = Label('Newspaper')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.list_cat)

    def about(self):
        self.session.open(AboutScreen)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()

    def list_cat(self):
        self.info = 'list_cat'
        self.cat_list = []
        cat = [('\xd8\xa7\xd9\x84\xd8\xad\xd9\x8a\xd8\xa7\xd8\xa9 - \xd8\xa2\xd8\xae\xd8\xb1 \xd8\xa7\xd9\x84\xd8\xa7\xd8\xae\xd8\xa8\xd8\xa7\xd8\xb1', 'http://www.alhayat.com/more/home/2?page=', 'http://www.alhayat.com/IMAGES/GENERAL/logo.aspx'), ('\xd8\xa7\xd9\x84\xd8\xa3\xd9\x88\xd8\xb3\xd8\xb7  - \xd8\xa2\xd8\xae\xd8\xb1 \xd8\xa7\xd9\x84\xd8\xa7\xd8\xae\xd8\xa8\xd8\xa7\xd8\xb1', 'http://aawsat.com/home/international/section/news?page=', 'http://www.aawsat.net/images/logo.png')]
        for each in cat:
            category, link, img = each
            self.cat_list.append(show_(category, link, img))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def list_shows(self, link):
        self.info = 'list_shows'
        self.show_list = []
        i = 1
        for i in range(1, 10):
            uri = link + str(i)
            print uri
            getPage(uri, timeout=8, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_it, link)
            i += 1

    def list_it(self, data, link):
        if 'www.alhayat.com' in link:
            news = re.findall('<a class="pictureLandingRT" href="/Articles/(.*?)/.*?" title="(.*?)">.*?<img alt="" src="(.*?)" />.*?<a class="descriptionTilteLandingRT" href=".*?" title="(.*?)</a>', data, re.DOTALL)
            for each in news:
                path, name, thumb, info = each
                path = 'http://www.alhayat.com' + '/Articles/' + str(path)
                thumb = 'http://www.alhayat.com/' + str(thumb)
                self.show_list.append(show_(name, path, thumb))

        elif 'http://aawsat.com' in link:
            news = re.findall('<div class="views-field views-field-field-new-photo">.*?<img typeof="foaf:Image" src="(.*?)" width=".*?" height=".*?">.*?<a href="(.*?)">(.*?)</a>.*?<p>(.*?)\\.*?\\</div>', data, re.DOTALL)
            for each in news:
                thumb, path, name, info = each
                path = 'http://aawsat.com' + str(path)
                self.show_list.append(show_(name, path, thumb))

        self['menulist'].l.setList(self.show_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def list_episodes(self, path):
        self.info = 'list_episodes'
        self.episodes_list = []
        getPage(path, timeout=8, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_episodes1, path)

    def list_episodes1(self, data, path):
        if 'alhayat.com' in path:
            news = re.findall('<div class="ArticlesDetDescription" id="DetDescription">.*?<p>(.*?)\n', data, re.DOTALL)
            for news in news:
                fullnews = re.sub('<a href=".*?">', '', str(news), re.DOTALL)
                finalnews = fullnews.replace('<p>', '\n').replace('</p>', '').replace('</a>', '')
                dedented_text = textwrap.dedent(finalnews)
                for width in [200]:
                    dedented_news = textwrap.wrap(dedented_text, width=width)
                    print len(dedented_news)
                    for each in dedented_news:
                        line = each
                        print line
                        self.episodes_list.append(show_news(line))

        if 'aawsat.com' in path:
            news = re.findall("<div class='node_new_resource'>(.*?)</div>\n", data, re.DOTALL)
            for news in news:
                news = news.replace('<br />', '').replace('</div>', '')
                dedented_text = textwrap.dedent(news)
                for width in [210]:
                    dedented_text = textwrap.wrap(dedented_text, width=width)
                    for each in dedented_text:
                        line = each
                        self.episodes_list.append(show_news(line))

        self['menulist'].l.setList(self.episodes_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)

    def ok(self):
        if self.info == 'list_cat':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            self.list_shows(url)
        elif self.info == 'list_shows':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            self.list_episodes(url)

    def exit(self):
        print self.info
        if re.match('(list_cat)', self.info, re.S | re.I):
            if fileExists('/tmp/newspaper_poster.jpg'):
                os.system('rm -r /tmp/newspaper_poster.jpg')
            self.close(self.session, 'exit')
        elif self.info == 'list_shows':
            self.info = 'list_cat'
            self['blue'].hide()
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'list_episodes':
            self.info = 'list_shows'
            self['menulist'].l.setList(self.show_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'list_streams':
            self.info = 'list_episodes'
            self['blue'].hide()
            self['menulist'].l.setList(self.episodes_list)
            self['menulist'].l.setItemHeight(40)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/newspaper_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/newspaper/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[newspaper] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[newspaper] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/newspaper/'):
            os.system('mkdir /tmp/newspaper/')
        else:
            print '[newspaper] /tmp/newspaper/ allready present'


def main(session, **kwargs):
    session.open(newspaper)


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    return [PluginDescriptor(name='newspaper', description='newspaper Streamer', where=[PluginDescriptor.WHERE_PLUGINMENU], fnc=main, icon='plugin.png')]