# Embedded file name: /usr/lib/enigma2/python/Plugins/Extensions/Albatros/alqudseyes.py
from imports import *
PLUGIN_PATH = '/usr/lib/enigma2/python/Plugins/Extensions/Albatros'

class m2list(MenuList):

    def __init__(self, list):
        MenuList.__init__(self, list, False, eListboxPythonMultiContent)
        self.l.setFont(0, gFont('Regular', 14))
        self.l.setFont(1, gFont('Regular', 16))
        self.l.setFont(2, gFont('Regular', 18))
        self.l.setFont(3, gFont('Regular', 20))
        self.l.setFont(4, gFont('Regular', 22))
        self.l.setFont(5, gFont('Regular', 24))
        self.l.setFont(6, gFont('Regular', 26))
        self.l.setFont(7, gFont('Regular', 28))
        self.l.setFont(8, gFont('Regular', 32))


def show_(name, link, image):
    res = [(name, link, image)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def episodes_(name, link, image, info):
    res = [(name,
      link,
      image,
      info)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=name, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


def cat_(letter, link):
    res = [(letter, link)]
    res.append(MultiContentEntryText(pos=(0, 0), size=(800, 40), font=8, text=letter, flags=RT_HALIGN_CENTER | RT_VALIGN_CENTER))
    return res


class alqudseyes(Screen):

    def __init__(self, session):
        self.session = session
        sz_w = getDesktop(0).size().width()
        if sz_w == 1920:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen_new.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen_new.xml"
        else:
            if config.Albatros.skin.value=='1':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin/defaultListScreen.xml"
            elif config.Albatros.skin.value=='2':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin2/defaultListScreen.xml"
            elif config.Albatros.skin.value=='3':
                path = "/usr/lib/enigma2/python/Plugins/Extensions/Albatros/skin3/defaultListScreen.xml"
        with open(path, 'r') as f:
            self.skin = f.read()
            f.close()
        Screen.__init__(self, session)
        self['actions'] = ActionMap(['OkCancelActions',
         'ColorActions',
         'DirectionActions',
         'MovieSelectionActions'], {'up': self.up,
         'down': self.down,
         'left': self.left,
         'right': self.right,
         'ok': self.ok,
         'cancel': self.exit,
         'red': self.exit,
         'blue': self.dnitnow}, -1)
        self['menulist'] = m2list([])
        self['red'] = Label(_('Exit'))
        self['green'] = Label('')
        self['yellow'] = Label(_(' '))
        self['blue'] = Label('')
        self['Menu'] = Label(_(' '))
        self['name'] = Label(' ')
        self['poster'] = Pixmap()
        self['title'] = Label('Alqudseyes')
        self['text'] = Label('')
        self.dnfile = 'False'
        self.currentList = 'menulist'
        self.menulist = []
        self.loading_ok = False
        self.check = 'abc'
        self.count = 0
        self.loading = 0
        self.dir()
        self.onLayoutFinish.append(self.list_cat)

    def about(self):
        self.session.open(AboutScreen)

    def dnitnow(self):
        if JobManagerInstalled and self.check == 'letter_movie':
            self.dnfile = 'True'
            link = self['menulist'].getCurrent()[0][1]
            self.filmname = self['menulist'].getCurrent()[0][0]

    def up(self):
        self[self.currentList].up()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def down(self):
        self[self.currentList].down()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def left(self):
        self[self.currentList].pageUp()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def right(self):
        self[self.currentList].pageDown()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)
        if self.info == 'list_cat':
            self.load_poster()
        elif self.info == 'list_shows':
            self.load_poster()
        elif self.info == 'list_episodes':
            self.load_poster()
            try:
                seasoninfo = self['menulist'].getCurrent()[0][3]
                self['text'].setText(seasoninfo)
            except:
                self['text'].setText('')

    def list_cat(self):
        self.info = 'list_cat'
        self.cat_list = []
        cat = [('Movies', 'http://www.alqudseyes.com/movies', 'http://www.alqudseyes.com/img/film.png'),
         ('Arabic Series', 'http://www.alqudseyes.com/series?category=20', 'http://www.alqudseyes.com/img/2015.png'),
         ('Egytian Series', 'http://www.alqudseyes.com/series?category=21', 'http://www.alqudseyes.com/img/2015.png'),
         ('Syrian Series', 'http://www.alqudseyes.com/series?category=22', 'http://www.alqudseyes.com/img/2014.png'),
         ('Ramadan Series 2011', 'http://www.alqudseyes.com/series?category=27', 'http://www.alqudseyes.com/img/2013.png'),
         ('Ramadan Series 2012', 'http://www.alqudseyes.com/series?category=28', 'http://www.alqudseyes.com/img/2013.png'),
         ('Ramadan Series 2014', 'http://www.alqudseyes.com/series?category=30', 'http://www.alqudseyes.com/img/2013.png'),
         ('Lybian Series', 'http://www.alqudseyes.com/series?category=23', 'http://www.alqudseyes.com/img/ar.png'),
         ('Turkey Series', 'http://www.alqudseyes.com/series?category=19', 'http://www.alqudseyes.com/img/tur.png'),
         ('Golf Series', 'http://www.alqudseyes.com/series?category=24', 'http://www.alqudseyes.com/img/tur2.png'),
         ('Cartoon', 'http://www.alqudseyes.com/series?category=25', 'http://www.alqudseyes.com/img/cartoon.png'),
         ('TV Series', 'http://www.alqudseyes.com/series?category=26', 'http://www.alqudseyes.com/img/2015.png'),
         ('Dubbed Series', 'http://www.alqudseyes.com/series?category=29', 'http://www.alqudseyes.com/img/2015.png')]
        for each in cat:
            category, link, thumb = each
            self.cat_list.append(show_(category, link, thumb))

        self['menulist'].l.setList(self.cat_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def list_shows(self, link):
        self.info = 'list_shows'
        self.show_list = []
        i = 0
        for i in range(0, 40):
            if '%D9%84%D8%A8%D9%86%D8%A7%D9%86%D9%8A%D8%A9/c5' in link:
                url = link
            else:
                url = link + '?sort=desc&sort_by=date&movies=10&page=' + str(i)
            print url
            getPage(url, timeout=8, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_it, link)
            i += 1

    def list_it(self, data, link):
        movies = re.findall('<article class="movie">.*?<a href="(.*?)">.*?<figure class="movie-image">.*?<img src="(.*?)" alt="(.*?)">', data, re.DOTALL)
        for path, thumb, name in movies:
            self.show_list.append(show_(name, path, thumb))

        self['menulist'].l.setList(self.show_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def list_episodes(self, path):
        self.info = 'list_episodes'
        self.episodes_list = []
        getPage(path, timeout=8, method='GET', headers={'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.list_episodes1, path)

    def list_episodes1(self, data, path):
        movies = re.findall('<div class="info-episodes">.*?<h5><a href="(.*?)">(.*?)</a></h5>', data, re.DOTALL)
        thumb = re.findall('<div class="col-sm-12 col-md-3 sm-box">.*?<img src="(.*?)"', data, re.DOTALL)[0]
        for path, name in movies:
            self.episodes_list.append(show_(name, path, thumb))

        self['menulist'].l.setList(self.episodes_list)
        self['menulist'].l.setItemHeight(40)
        self['menulist'].moveToIndex(0)
        self.load_poster()
        auswahl = self['menulist'].getCurrent()[0][0]
        self['name'].setText(auswahl)

    def get_play_link(self, data, path):
        print 'now we search the rtmp url'
        path = path.replace('/movies', '/movies/watch')
        print path
        getPage(path, timeout=8, method='GET', headers={'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.103 Safari/537.36',
         'Referer': 'http://www.alqudseyes.com/series/584',
         'Content-Type': 'application/x-www-form-urlencoded'}).addCallback(self.read_link, path)

    def read_link(self, data, path):
        print 'play that shit'
        link = re.findall('mp4:"(.*?)",', data)
        if link:
            self.play_movie(link[0])

    def play_movie(self, link):
        if link:
            sref = eServiceReference(4097, 0, link)
            sref.setName(self.filmname)
            self.session.open(MoviePlayer, sref)

    def ok(self):
        if self.info == 'list_cat':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            url = str(selectedEntry)
            self.list_shows(url)
        elif self.info == 'list_shows':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            if 'movies' in url:
                self.filmname = str(selectedName)
                self.get_play_link(self.filmname, url)
            else:
                self.list_episodes(url)
        elif self.info == 'list_episodes':
            selectedEntry = self['menulist'].l.getCurrentSelection()[0][1]
            selectedName = self['menulist'].l.getCurrentSelection()[0][0]
            print selectedEntry
            url = str(selectedEntry)
            self.filmname = str(selectedName)
            self.get_play_link(self.filmname, url)

    def exit(self):
        print self.info
        if re.match('(list_cat)', self.info, re.S | re.I):
            if fileExists('/tmp/alqudseyes_poster.jpg'):
                os.system('rm -r /tmp/alqudseyes_poster.jpg')
            self.close(self.session, 'exit')
        elif self.info == 'list_shows':
            self.info = 'list_cat'
            self['blue'].hide()
            self['menulist'].l.setList(self.cat_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'list_episodes':
            self.info = 'list_shows'
            self['menulist'].l.setList(self.show_list)
            self['menulist'].l.setItemHeight(40)
        elif self.info == 'list_streams':
            self.info = 'list_episodes'
            self['blue'].hide()
            self['menulist'].l.setList(self.episodes_list)
            self['menulist'].l.setItemHeight(40)

    def load_poster(self):
        jp_link = self['menulist'].getCurrent()[0][2]
        tmp_image = jpg_store = '/tmp/alqudseyes_poster.jpg'
        try:
            downloadPage(jp_link, tmp_image).addCallback(self.downloadPic, tmp_image)
        finally:
            print "Error: can't find file or read data"

    def show_cover(self):
        jpg_link = '/usr/lib/enigma2/python/Plugins/Extensions/alqudseyes/images/'
        jpg_name = 'no_cover.png'
        jpg_store = jpg_link + jpg_name
        if not os.path.exists(jpg_store):
            self.downloadPic(file_name, jpg_store)
        else:
            self.poster_resize(jpg_store)

    def downloadPic(self, data, jpg_store):
        if fileExists(jpg_store):
            self.poster_resize(jpg_store)
        else:
            print '[alqudseyes] logo not found'

    def poster_resize(self, poster_path):
        self['poster'].instance.setPixmap(None)
        self['poster'].hide()
        sc = AVSwitch().getFramebufferScale()
        self.picload = ePicLoad()
        size = self['poster'].instance.size()
        self.picload.setPara((size.width(),
         size.height(),
         sc[0],
         sc[1],
         False,
         1,
         '#FF000000'))
        if self.picload.startDecode(poster_path, 0, 0, False) == 0:
            ptr = self.picload.getData()
            if ptr != None:
                self['poster'].instance.setPixmap(ptr)
                self['poster'].show()
            else:
                print '[alqudseyes] no cover.. error'
        return

    def dir(self):
        if not pathExists('/tmp/alqudseyes/'):
            os.system('mkdir /tmp/alqudseyes/')
        else:
            print '[alqudseyes] /tmp/alqudseyes/ allready present'


def main(session, **kwargs):
    session.open(alqudseyes)


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    return [PluginDescriptor(name='alqudseyes', description='alqudseyes Streamer', where=[PluginDescriptor.WHERE_PLUGINMENU], fnc=main, icon='plugin.png')]